#! /bin/sh
lastdir=`pwd`
programDir=`cd $(dirname $0);pwd`
pgmName=$0
pgmName=${pgmName##*/}
programPath=$programDir/$pgmName
#echo $programDir-----------------$0===========$pgmName============$programPath
if [ "$1" == "" ]; then
    echo "usage:./unzip_recursive seleted_path_to_unzip_recursively"
    exit 1
fi
cd "$1"
if [ "$?" != "0" ]; then
    echo "error! `pwd` $1"
    exit 1
fi
    for filename in *
    do
        if [ -d "$filename" ]
        then
            "$programPath" "$filename"
        else
            unpackPath="${filename##*/}"
	    unpackTmp="unpack-$unpachPath"
            if [ "${filename##*.}" == "zip" -o "${filename##*.}" == "war" ] 
            then
                mkdir -p "$unpackTmp"
                unzip -oq -d "$unpackTmp" "$filename" 2>/dev/null
		if [ "$?" == "0" ]; then
		   echo "unpack file `pwd`/$filename" 
		fi
		rm -f "$filename"
		mv "$unpackTmp" "$unpackPath"
                "$programPath" "$unpackPath"
            elif [ "${filename##*.}" == "tar" -o "${filename##*.tar.}" == "gz" -o "${filename##*.}" == "bz2" -o "${filename##*.}" == "tgz" ]
            then
                mkdir -p "$unpackTmp"
                cd "$unpackTmp"
                tar -xf "../$filename" 2>/dev/null
                cd ../
		if [ "$?" == "0" ]; then
		   echo "unpack file `pwd`/$filename" 
		fi
		rm -f "$filename"
		mv "$unpackTmp" "$unpackPath"
                "$programPath" "$unpackPath"
            elif [ "${filename##*.}" == "rpm" ]
            then
                mkdir -p "$unpackTmp"
                cd "$unpackTmp"
                rpm2cpio "../$filename" | cpio -idm 2> /dev/null
                cd ../
		if [ "$?" == "0" ]; then
		   echo "unpack file `pwd`/$filename" 
		fi
		rm -f "$filename"
		mv "$unpackTmp" "$unpackPath"
                "$programPath" "$unpackPath"
            fi
        fi
    done
cd "$lastdir"
