#! /bin/sh
singleSoLog="NonJarResult.log"
touch $singleSoLog
touch JarResult.log
unzipRecusive()
{
    for filename in "$1"/*
    do
        #echo $filename
        suffix="jar"
        if [ -d "$filename" ]
	then
            unzipRecusive "$filename" 
        else
            if [ "${filename##*.}" = "$suffix" ]
            then
		./checkJar.sh "$filename"  
            elif [ "`readelf -h \"${filename}\" 2>/dev/null|grep Machine`" != "" ]
	    then
		if [ "`readelf -h \"${filename}\" 2>/dev/null|grep AArch64`" = "" ]
		then
		    echo "$filename" >> $singleSoLog
		fi
	    fi
        fi
    done
}
if [ "$1" == "" ]; then
    echo "usage:./search_so.sh path_to_search_jars"
    exit 1
fi
unzipRecusive "$1"
sort -n JarResult.log | uniq > tmp
mv -f tmp JarResult.log
sort -n out.csv | uniq > tmp
mv -f tmp out.csv
