#!/usr/bin/env python3
# coding=utf-8
# Copyright (C) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import node
import compute
import controller
import subprocess
import socket

def set_yum():
    subprocess.run("mv /etc/yum.repos.d/openEuler.repo /etc/yum.repos.d/openEuler.repo.bak".split(), check=True)
    subprocess.run("mv /etc/yum.conf /etc/yum.conf.bak".split(), check=True)
    subprocess.run("cp ./openEuler.repo /etc/yum.repos.d/".split(), check=True)
    subprocess.run("cp ./yum.conf /etc/yum.conf".split(), check=True)
    subprocess.run("yum clean all".split(), check=True)
    subprocess.run("yum makecache".split(), check=True)

def get_node_ip(node: node.Node):
    with open("/etc/hosts", 'r') as f:
        while True:
            line = f.readline()
            if line is None or line == "":
                break
            if len(line.split()) == 2 and line.split()[1][:len(line.split()[1])] == "controller":
                node.controller_ip = line.split()[0]

            if len(line.split()) == 2 and line.split()[1][:len(line.split()[1])] == "compute01":
                node.compute1_ip = line.split()[0]

            if len(line.split()) == 2 and line.split()[1][:len(line.split()[1])] == "compute02":
                node.compute2_ip = line.split()[0]

def set_chrony(node: node.Node):
    subprocess.run("yum install chrony -y".split(), check=True)
    subprocess.run("timedatectl set-timezone Asia/Shanghai".split(), check=True)
    node.set_chrony_conf()
    subprocess.run("systemctl enable chronyd.service".split(), check=True)
    subprocess.run("systemctl restart chronyd.service".split(), check=True)
    if isinstance(node, controller.Controller):
        subprocess.run("timedatectl set-ntp yes".split(), check=True)

def close_selinux():
    subprocess.run("setenforce 0".split())

def open_firewall_port():
    subprocess.run("systemctl stop firewalld.service".split())
    subprocess.run("systemctl disable firewalld.service".split())

if __name__ == '__main__':
    node_type = socket.gethostname()
    if node_type == 'controller':
        node = controller.Controller()
    elif node_type == 'compute01' or node_type == 'compute02':
        node = compute.Compute()
        if node_type == 'compute01':
            node.index = 0
        else:
            node.index = 1
    else:
        raise ValueError("Incorrect node type: %s", node_type)

    get_node_ip(node)
    set_yum()
    node.set_network()
    node.install_sql()
    node.install_rabbit()
    node.install_memcached()
    set_chrony(node)
    close_selinux()
    open_firewall_port()
    node.install_keystone()
    node.install_glance()
    node.install_placement()
    node.install_neutron()
    node.install_nova()
    node.install_cinder()
    node.install_horizon()
    node.install_aodh()
    node.install_gnocchi()
    node.install_ceilmeter()
    node.install_mgmt()
    node.install_ovs()
    node.install_openstack_patch()
    node.install_hotliv()
