#!/usr/bin/env python3
# coding=utf-8
# Copyright (C) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import subprocess
import node
import pymysql
import os

class Controller(node.Node):
    _openstack_password = "123456"
    _placement_password = "123456"
    @property
    def openstack_password(self):
        return self._openstack_password

    @openstack_password.setter
    def openstack_password(self, passwd: str):
        self._openstack_password = passwd

    @property
    def keystone_password(self):
        return self._keystone_password

    @keystone_password.setter
    def keystone_password(self, passwd: str):
        self._keystone_password = passwd

    def install_sql(self):
        subprocess.run("yum install -y mariadb mariadb-server python3-PyMySQL".split(), check=True)
        config = "[mysqld]\n \
                    bind-address = %s\n \
                    default-storage-engine = innodb\n \
                    innodb_file_per_table = on\n \
                    max_connections = 4096\n \
                    collation-server = utf8_general_ci\n \
                    character-set-server = utf8\n" % super().controller_ip

        with open("/etc/my.cnf.d/openstack.cnf", "w") as f:
            f.write(config)
        subprocess.run("systemctl enable mariadb.service".split(), check=True)
        subprocess.run("systemctl start mariadb.service".split(), check=True)
        subprocess.run("mysql_secure_installation".split(), check=True)

    def install_rabbit(self):
        subprocess.run("yum -y install rabbitmq-server".split(), check=True)
        subprocess.run("systemctl enable rabbitmq-server.service".split(), check=True)
        subprocess.run("systemctl start rabbitmq-server.service".split(), check=True)

        subprocess.run(("rabbitmqctl add_user openstack 123456").split(), check=True)
        os.system("rabbitmqctl set_permissions openstack \".*\" \".*\" \".*\"")

    def install_memcached(self):
        subprocess.run("yum install -y python3-openstackclient".split(), check=True)
        subprocess.run("yum install -y memcached python3-memcached".split(), check=True)

        with open("/etc/sysconfig/memcached", "w") as f:
            f.write("PORT=\"11211\"\n \
                        USER=\"memcached\"\n \
                        MAXCONN=\"1024\"\n \
                        CACHESIZE=\"64\"\n \
                        OPTIONS=\"-l 127.0.0.1,::1,controller\"\n")

        subprocess.run("systemctl enable memcached.service".split(), check=True)
        subprocess.run("systemctl start memcached.service".split(), check=True)

    def set_chrony_conf(self):
        with open("/etc/chrony.conf", "a") as f:
            f.write("allow %s\n" % super().compute1_ip)
            if super().compute2_ip !="":
                f.write("allow %s\n" % super().compute2_ip)
            f.write("local stratum 10\n")


    def install_keystone(self):
        self._keystone_password = "123456"
        self._admin_pass = "123456"
        conn = pymysql.connect(host=super().controller_ip, user="root", passwd="123456")
        cursor = conn.cursor()
        cursor.execute("CREATE DATABASE keystone;")
        cursor.execute("GRANT ALL PRIVILEGES ON keystone.* TO 'keystone'@'localhost' IDENTIFIED BY %s;", self._keystone_password)
        cursor.execute("GRANT ALL PRIVILEGES ON keystone.* TO 'keystone'@'%%' IDENTIFIED BY %s", self._keystone_password)
        conn.commit()
        cursor.close()
        conn.close()

        subprocess.run("yum install openstack-keystone httpd mod_wsgi -y".split(), check=True)
        cont =[]
        with open("/etc/keystone/keystone.conf", "r") as f:
            while True:
                line = f.readline()
                if line == None or line == '':
                    break
                cont.append(line)
        index = 0
        for i in range(len(cont)):
            if cont[i] == '[token]\n':
                index = i + 1
        assert(index != 0)
        cont.insert(index, "provider = fernet\n")

        index = 0
        for i in range(len(cont)):
            if cont[i] == '[database]\n':
                index = i+1
        assert(index != 0)
        cont.insert(index, "connection = mysql+pymysql://keystone:%s@controller/keystone\n" % self._keystone_password)

        with open("/etc/keystone/keystone.conf", "w") as f:
            f.writelines(cont)

        os.system("su -s /bin/sh -c \"keystone-manage db_sync\" keystone")
        os.system("keystone-manage fernet_setup --keystone-user keystone --keystone-group keystone")
        os.system("keystone-manage credential_setup --keystone-user keystone --keystone-group keystone")
        os.system("keystone-manage bootstrap --bootstrap-password %s \
                    --bootstrap-admin-url http://controller:5000/v3/ \
                    --bootstrap-internal-url http://controller:5000/v3/ \
                    --bootstrap-public-url http://controller:5000/v3/ \
                    --bootstrap-region-id RegionOne" % self._admin_pass)
        
        with open("/etc/httpd/conf.modules.d/10-wsgi-python3.conf", "w") as f:
            lines = [
                "<IfModule !wsgi_module>\n" ,
                "LoadModule wsgi_module modules/mod_wsgi_python3.so\n",
                "</IfModule>\n"
            ]
            f.writelines(lines)
        with open("/etc/httpd/conf/httpd.conf", "a") as f:
            f.write("ServerName controller\n")

        subprocess.run("ln -s /usr/share/keystone/wsgi-keystone.conf /etc/httpd/conf.d/".split(), check=True)
        subprocess.run("systemctl enable httpd.service".split(), check=True)
        subprocess.run("systemctl start httpd.service".split(), check=True)
        
        os.system("openstack domain create --description \"An Example Domain\" example")
        os.system("openstack project create --domain default --description \"Service Project\" service")
        os.system("openstack project create --domain default --description \"Demo Project\" myproject")
        subprocess.run("openstack user create --domain default --password-prompt myuser".split() , check=True)
        subprocess.run("openstack role create myrole".split(), check=True)
        subprocess.run("openstack role add --project myproject --user myuser myrole".split(), check=True)

    def install_glance(self):
        self._glance_password = "123456"
        conn = pymysql.connect(host=super().controller_ip, user="root", passwd="123456")
        cursor = conn.cursor()
        cursor.execute("CREATE DATABASE glance;")
        cursor.execute("GRANT ALL PRIVILEGES ON glance.* TO 'glance'@'localhost' IDENTIFIED BY %s;", self._glance_password)
        cursor.execute("GRANT ALL PRIVILEGES ON glance.* TO 'glance'@'%%' IDENTIFIED BY %s", self._glance_password)
        conn.commit()
        cursor.close()
        conn.close()

        subprocess.run("openstack user create --domain default --password-prompt glance".split(), check=True)
        subprocess.run("openstack role add --project service --user glance admin".split(), check=True)
        os.system("openstack service create --name glance --description \"OpenStack Image\" image")

        subprocess.run("openstack endpoint create --region RegionOne image public http://controller:9292".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne image internal http://controller:9292".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne image admin http://controller:9292".split(), check=True)

        subprocess.run("yum install openstack-glance python3-rbd -y".split(), check=True)
        cont = []
        with open("/etc/glance/glance-api.conf", "r") as f:
            while True:
                line = f.readline()
                if line == None or line == '':
                    break
                cont.append(line)

        index1 = 0
        index2 = 0
        index3 = 0
        index4 = 0
        for i in range(len(cont)):
            if cont[i] == '[database]\n':
                index1 = i + 1
        cont.insert(index1, "connection = mysql+pymysql://glance:%s@controller/glance\n" % self._glance_password)

        for i in range(len(cont)):
            if cont[i] == '[keystone_authtoken]\n':
                index2 = i + 1
        cont.insert(index2, "www_authenticate_uri  = http://controller:5000\n"
                            "auth_url = http://controller:5000\n"
                            "memcached_servers = controller:11211\n"
                            "auth_type = password\n"
                            "project_domain_name = Default\n"
                            "user_domain_name = Default\n"
                            "project_name = service\n"
                            "username = glance\n"
                            "password = %s\n" % self._glance_password)

        for i in range(len(cont)):
            if cont[i] == '[paste_deploy]\n':
                index3 = i + 1
        cont.insert(index3, "flavor = keystone\n")

        for i in range(len(cont)):
            if cont[i] == '[glance_store]\n':
                index4 = i + 1
        cont.insert(index4, "stores = rbd\n"
                            "default_store = rbd\n"
                            "rbd_store_pool = images\n"
                            "rbd_store_user = glance\n"
                            "rbd_store_ceph_conf = /etc/ceph/ceph.conf\n"
                            "rbd_store_chunk_size = 8\n")

        for i in range(len(cont)):
            if cont[i] == '[DEFAULT]\n':
                index4 = i + 1
        cont.insert(index4, "transport_url = rabbit://openstack:123456@controller\n")

        for i in range(len(cont)):
            if cont[i] == '[oslo_messaging_notifications]\n':
                index4 = i + 1
        cont.insert(index4, "driver = messagingv2\n")

        with open("/etc/glance/glance-api.conf", "w") as f:
            f.writelines(cont)
        os.system("su -s /bin/sh -c \"glance-manage db_sync\" glance")

        cont = []
        with open("/etc/glance/glance-registry.conf", "r") as f:
            while True:
                line = f.readline()
                if line == None or line == '':
                    break
                cont.append(line)

        for i in range(len(cont)):
            if cont[i] == '[DEFAULT]\n':
                index4 = i + 1
        cont.insert(index4, "transport_url = rabbit://openstack:123456@controller\n")

        for i in range(len(cont)):
            if cont[i] == '[oslo_messaging_notifications]\n':
                index4 = i + 1
        cont.insert(index4,"driver = messagingv2\n")

        with open("/etc/glance/glance-registry.conf", "w")  as f:
            f.writelines(cont)
        os.system("su -s /bin/sh -c \"glance-manage db_sync\" glance")

        subprocess.run("systemctl enable openstack-glance-api.service".split(), check=True)
        subprocess.run("systemctl start openstack-glance-api.service".split(), check=True)

    def install_placement(self):
        self._placement_password = "123456"
        conn = pymysql.connect(host=super().controller_ip, user="root", passwd="123456")
        cursor = conn.cursor()
        cursor.execute("CREATE DATABASE placement;")
        cursor.execute("GRANT ALL PRIVILEGES ON placement.* TO 'placement'@'localhost' IDENTIFIED BY %s;", self._placement_password)
        cursor.execute("GRANT ALL PRIVILEGES ON placement.* TO 'placement'@'%%' IDENTIFIED BY %s", self._placement_password)
        conn.commit()
        cursor.close()
        conn.close()

        subprocess.run("openstack user create --domain default --password-prompt placement".split(), check=True)
        subprocess.run("openstack role add --project service --user placement admin".split(), check=True)
        os.system("openstack service create --name placement --description \"Placement API\" placement")

        subprocess.run("openstack endpoint create --region RegionOne placement public http://controller:8778".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne placement internal http://controller:8778".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne placement admin http://controller:8778".split(), check=True)

        subprocess.run("yum install openstack-placement-api -y".split(), check=True)
        cont = []
        with open("/etc/placement/placement.conf", "r") as f:
            while True:
                line = f.readline()
                if line == None or line == '':
                    break
                cont.append(line)

        index1 = 0
        index2 = 0
        index3 = 0
        for i in range(len(cont)):
            if cont[i] == '[placement_database]\n':
                index1 = i + 1
        cont.insert(index1, "connection = mysql+pymysql://placement:%s@controller/placement\n" % self._placement_password)

        for i in range(len(cont)):
            if cont[i] == '[api]\n':
                index2 = i + 1
        cont.insert(index2, "auth_strategy = keystone\n")

        for i in range(len(cont)):
            if cont[i] == '[keystone_authtoken]\n':
                index3 = i + 1
        cont.insert(index3, "auth_url = http://controller:5000\n"
                            "memcached_servers = controller:11211\n"
                            "auth_type = password\n"
                            "project_domain_name = Default\n"
                            "user_domain_name = Default\n"
                            "project_name = service\n"
                            "username = placement\n"
                            "password = %s\n" % self._placement_password)

        with open("/etc/placement/placement.conf", "w") as f:
            f.writelines(cont)

        os.system("su -s /bin/sh -c \"placement-manage db sync\" placement")
        subprocess.run("systemctl restart httpd".split(), check=True)

    def install_neutron(self):
        super().install_neutron()
        self._neutron_password = "123456"
        self._nova_password = "123456"
        conn = pymysql.connect(host=super().controller_ip, user="root", passwd="123456")
        cursor = conn.cursor()
        cursor.execute("CREATE DATABASE neutron;")
        cursor.execute("GRANT ALL PRIVILEGES ON neutron.* TO 'neutron'@'localhost' IDENTIFIED BY %s;", self._neutron_password)
        cursor.execute("GRANT ALL PRIVILEGES ON neutron.* TO 'neutron'@'%%' IDENTIFIED BY %s", self._neutron_password)
        conn.commit()
        cursor.close()
        conn.close()

        subprocess.run("openstack user create --domain default --password-prompt neutron".split(), check=True)
        subprocess.run("openstack role add --project service --user neutron admin".split(), check=True)
        os.system("openstack service create --name neutron --description \"OpenStack Networking\" network")

        subprocess.run("openstack endpoint create --region RegionOne network public http://controller:9696".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne network internal http://controller:9696".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne network admin http://controller:9696".split(), check=True)

        subprocess.run("yum install openstack-neutron openstack-neutron-ml2 openstack-neutron-openvswitch openstack-neutron-metering-agent ebtables -y".split(), check=True)
        cont = []
        with open("/etc/neutron/neutron.conf", "r") as f:
            while True:
                line = f.readline()
                if line == None or line == '':
                    break
                cont.append(line)

        index1 = 0
        index2 = 0
        index3 = 0
        index4 = 0
        for i in range(len(cont)):
            if cont[i] == '[database]\n':
                index1 = i + 1
        cont.insert(index1, "connection = mysql+pymysql://neutron:%s@controller/neutron\n" % self._neutron_password)

        for i in range(len(cont)):
            if cont[i] == '[DEFAULT]\n':
                index2 = i + 1
        cont.insert(index2, "core_plugin = ml2\n"
                            "service_plugins = router,metering,qos,placement,trunk,segments\n"
                            "transport_url = rabbit://openstack:%s@controller\n"
                            "auth_strategy = keystone\n"
                            "notify_nova_on_port_status_changes = true\n"
                            "notify_nova_on_port_data_changes = true\n" % self.openstack_password)
        
        for i in range(len(cont)):
            if cont[i] == '[keystone_authtoken]\n':
                index3 = i + 1
        cont.insert(index3, "www_authenticate_uri = http://controller:5000\n"
                            "auth_url = http://controller:5000\n"
                            "memcached_servers = controller:11211\n"
                            "auth_type = password\n"
                            "project_domain_name = Default\n"
                            "user_domain_name = Default\n"
                            "project_name = service\n"
                            "username = neutron\n"
                            "password = %s\n" % self._neutron_password)

        for i in range(len(cont)):
            if cont[i] == '[oslo_concurrency]\n':
                index4 = i + 1
        cont.insert(index4, "lock_path = /var/lib/neutron/tmp\n")

        for i in range(len(cont)):
            if cont[i] == '[oslo_messaging_notifications]\n':
                index4 = i + 1
        cont.insert(index4, "driver = messagingv2\n")

        with open("/etc/neutron/neutron.conf", "w") as f:
            f.writelines(cont)
            nova =  "[nova]\n" \
                    "auth_url = http://controller:5000\n" \
                    "auth_type = password\n" \
                    "project_domain_name = default\n" \
                    "user_domain_name = default\n" \
                    "region_name = RegionOne\n" \
                    "project_name = service\n" \
                    "username = nova\n" \
                    "password = %s\n" % self._nova_password

            placement = "[placement]\n" \
                        "region_name = RegionOne\n" \
                        "project_domain_name = Default\n" \
                        "project_name = service\n" \
                        "auth_type = password\n" \
                        "user_domain_name = Default\n" \
                        "auth_url = http://controller:5000/v3\n" \
                        "username = placement\n" \
                        "password = %s" % self._placement_password
            f.writelines([nova, placement])

        with open("/etc/neutron/plugins/ml2/ml2_conf.ini", "a") as f:
            ml2 = "[ml2]\n" \
                    "type_drivers = flat,vlan,vxlan\n" \
                    "tenant_network_types = flat, vlan, vxlan\n" \
                    "mechanism_drivers = openvswitch\n" \
                    "extension_drivers = port_security, qos\n"

            ml2_type_flat = "[ml2_type_flat]\n" \
                            "flat_networks = provider\n"

            ml2_type_vlan = "[ml2_type_vlan]\n" \
                            "network_vlan_ranges = provider\n"

            ml2_type_vxlan = "[ml2_type_vxlan]\n" \
                                "vni_ranges = 1:1000\n"
            
            securitygroup = "[securitygroup]\n" \
                            "enable_ipset = true\n"

            ovs = "[ovs]\n" \
                    "datapath_type = netdev\n" \
                    "bridge_mappings = provider:br-provider\n" \
                    "tunnel_bridge = br-tun\n" \
                    "local_ip = 9.88.17.2\n" \
                    "resource_provider_bandwidths = br-provider:10000000:10000000\n"

            f.writelines([ml2, ml2_type_flat, ml2_type_vlan, ml2_type_vxlan, securitygroup, ovs])

        with open("/etc/neutron/plugins/ml2/openvswitch_agent.ini", "a") as f:
            securitygroup = "[securitygroup]\n" \
                            "enable_security_group = true\n" \
                            "firewall_driver = iptables_hybrid\n\n"

            ml2 = "[ml2]\n" \
                    "type_drivers = flat,vlan,vxlan\n" \
                    "tenant_network_types = flat, vlan, vxlan\n" \
                    "mechanism_drivers = openvswitch\n" \
                    "extension_drivers = port_security,qos\n\n"

            ml2_type_flat = "[ml2_type_flat]\n" \
                            "flat_networks = provider\n\n"

            ml2_type_vlan = "[ml2_type_vlan]\n" \
                            "network_vlan_ranges = provider\n" \
                            "enable_ipset = true\n\n"

            ml2_type_vxlan = "[ml2_type_vxlan]\n" \
                                "vni_ranges = 1:1000\n\n"

            ovs = "[ovs]\n" \
                    "bridge_mappings = provider:br-ex\n" \
                    "tunnel_bridge = br-tun\n" \
                    "local_ip = 9.88.17.2\n" \
                    "resource_provider_bandwidths = br-ex:10000000:10000000\n\n"

            agent = "[agent]\n" \
                    "tunnel_types = vxlan\n" \
                    "extensions  = qos\n\n"
                
            f.writelines([securitygroup, ml2, ml2_type_flat, ml2_type_vlan, ovs, agent])

        with open("/etc/neutron/dhcp_agent.ini", "a") as f:
            default = "interface_driver = openvswitch\n" \
                        "dhcp_driver = neutron.agent.linux.dhcp.Dnsmasq\n" \
                        "enable_isolated_metadata = true\n" \
                        "force_metadata = true\n"

            f.write(default)

        with open("/etc/neutron/l3_agent.ini", "a") as f:
            default = "interface_driver = openvswitch\n"
            f.write(default)

        with open("/etc/neutron/metadata.ini", "a") as f:
            default = "[DEFAULT]\n" \
                        "nova_metadata_host = 9.88.14.2\n" \
                        "metadata_proxy_shared_secret = 123456\n"
            f.write(default)

        cont = []
        with open("/etc/sysctl.conf", "r") as f:
            while True:
                line = f.readline()
                if line is None or line == "":
                    break
                cont.append(line)
                
        for i in  range(len(cont)):
            if "net.ipv4.ip_forward" in cont[i]:
                cont[i] = "net.ipv4.ip_forward=1\n"
            if "net.ipv4.conf.all.rp_filter" in cont[i]:
                cont[i] = "net.ipv4.conf.all.rp_filter=0\n"
            if "net.ipv4.conf.default.rp_filter" in cont[i]:
                cont[i] = "net.ipv4.conf.default.rp_filter=0\n"

        with open("/etc/sysctl.conf", "w") as f:
            f.writelines(cont)

        subprocess.run("sysctl -p".split(), check=True)
        subprocess.run("ln -s /etc/neutron/plugins/ml2/ml2_conf.ini /etc/neutron/plugin.ini".split(), check=True)
        os.system("su -s /bin/sh -c \"neutron-db-manage --config-file /etc/neutron/neutron.conf \
                    --config-file /etc/neutron/plugins/ml2/ml2_conf.ini upgrade head\" neutron")

        subprocess.run("systemctl enable neutron-server.service neutron-openvswitch-agent.service \
                        neutron-metadata-agent.service neutron-dhcp-agent.service neutron-l3-agent.service neutron-metering-agent.service".split(), check=True)
        subprocess.run("systemctl start neutron-server.service neutron-openvswitch-agent.service \
                        neutron-metadata-agent.service neutron-dhcp-agent.service neutron-l3-agent.service neutron-metering-agent.service".split(), check=True)
        subprocess.run("ovs-vsctl add-br br-ex".split(), check=True)

    def install_nova(self):
        self._nova_password = "123456"
        conn = pymysql.connect(host=super().controller_ip, user="root", passwd="123456")
        cursor = conn.cursor()
        cursor.execute("CREATE DATABASE nova_api;")
        cursor.execute("CREATE DATABASE nova;")
        cursor.execute("CREATE DATABASE nova_cell0;")
        cursor.execute("GRANT ALL PRIVILEGES ON nova_api.* TO 'nova'@'localhost' IDENTIFIED BY %s;", self._nova_password)
        cursor.execute("GRANT ALL PRIVILEGES ON nova_api.* TO 'nova'@'%%' IDENTIFIED BY %s", self._nova_password)
        cursor.execute("GRANT ALL PRIVILEGES ON nova.* TO 'nova'@'localhost' IDENTIFIED BY %s;", self._nova_password)
        cursor.execute("GRANT ALL PRIVILEGES ON nova.* TO 'nova'@'%%' IDENTIFIED BY %s", self._nova_password)
        cursor.execute("GRANT ALL PRIVILEGES ON nova_cell0.* TO 'nova'@'localhost' IDENTIFIED BY %s;", self._nova_password)
        cursor.execute("GRANT ALL PRIVILEGES ON nova_cell0.* TO 'nova'@'%%' IDENTIFIED BY %s", self._nova_password)
        conn.commit()
        cursor.close()
        conn.close()

        subprocess.run("openstack user create --domain default --password-prompt nova".split(), check=True)
        subprocess.run("openstack role add --project service --user nova admin".split(), check=True)
        os.system("openstack service create --name nova --description \"OpenStack Compute\" compute")

        subprocess.run("openstack endpoint create --region RegionOne compute public http://controller:8774/v2.1".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne compute internal http://controller:8774/v2.1".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne compute admin http://controller:8774/v2.1".split(), check=True)

        subprocess.run("yum install openstack-nova-api openstack-nova-conductor openstack-nova-novncproxy openstack-nova-scheduler -y".split(), check=True)
        subprocess.run("cp -f ./nova.conf /etc/nova/nova.conf".split(), check=True)
        cont=[]
        with open("/etc/nova/nova.conf", "r") as f:
            while True:
                line = f.readline()
                if line is None or line == "":
                    break
                cont.append(line)
        for i in range(len(cont)):
            if "transport_url = " in cont[i]:
                cont[i] = "transport_url = rabbit://openstack:123456@controller:5672/\n"

            if "my_ip = " in cont[i]:
                cont[i] = "my_ip = 9.88.14.2\n"

            if "connection = mysql+pymysql://nova:" in cont[i] and "[database]" in cont[i - 1]:
                cont[i] = "connection = mysql+pymysql://nova:123456@controller/nova\n"

            if "connection = mysql+pymysql://nova:" in cont[i] and "[api_database]" in cont[i - 1]:
                cont[i] = "connection = mysql+pymysql://nova:123456@controller/nova_api\n"

            if "password = " in cont[i]:
                cont[i] = "password = 123456\n"

            if "metadata_proxy_shared_secret = " in cont[i]:
                cont[i] = "metadata_proxy_shared_secret = 123456\n"

        with open("/etc/nova/nova.conf", "w") as f:
            f.writelines(cont)

        os.system("su -s /bin/sh -c \"nova-manage api_db sync\" nova")
        os.system("su -s /bin/sh -c \"nova-manage cell_v2 map_cell0\" nova")
        os.system("su -s /bin/sh -c \"nova-manage cell_v2 create_cell --name=cell1 --verbose\" nova")
        os.system("su -s /bin/sh -c \"nova-manage db sync\" nova")
        os.system("su -s /bin/sh -c \"nova-manage cell_v2 list_cells\" nova")
        os.system("su -s /bin/sh -c \"nova-manage cell_v2 discover_hosts --verbose\" nova")
        subprocess.run("systemctl enable openstack-nova-api.service openstack-nova-scheduler.service openstack-nova-conductor.service openstack-nova-novncproxy.service".split(), check=True)
        subprocess.run("systemctl start openstack-nova-api.service openstack-nova-scheduler.service openstack-nova-conductor.service openstack-nova-novncproxy.service".split(), check=True)
        
    def install_cinder(self):
        super().install_cinder()
        conn = pymysql.connect(host=super().controller_ip, user="root", passwd="123456")

        cursor = conn.cursor()
        cursor.execute("CREATE DATABASE cinder;")
        cursor.execute("GRANT ALL PRIVILEGES ON cinder.* TO 'cinder'@'localhost' IDENTIFIED BY %s;", "123456")
        cursor.execute("GRANT ALL PRIVILEGES ON cinder.* TO 'cinder'@'%%' IDENTIFIED BY %s;","123456")
        conn.commit()
        cursor.close()
        conn.close()

        subprocess.run("openstack user create --domain default --password-prompt cinder".split(), check=True)
        subprocess.run("openstack role add --project service --user cinder admin".split(), check=True)
        os.system("openstack service create --name cinderv2 --description \"OpenStack Block Storage\" volumev2")
        os.system("openstack service create --name cinderv3 --description \"OpenStack Block Storage\" volumev3")

        os.system("openstack endpoint create --region RegionOne volumev2 public http://controller:8776/v2/%\(project_id\)s")
        os.system("openstack endpoint create --region RegionOne volumev2 internal http://controller:8776/v2/%\(project_id\)s")
        os.system("openstack endpoint create --region RegionOne volumev2 admin http://controller:8776/v2/%\(project_id\)s")
        os.system("openstack endpoint create --region RegionOne volumev3 public http://controller:8776/v3/%\(project_id\)s")
        os.system("openstack endpoint create --region RegionOne volumev3 internal http://controller:8776/v3/%\(project_id\)s")
        os.system("openstack endpoint create --region RegionOne volumev3 admin http://controller:8776/v3/%\(project_id\)s")
        subprocess.run("yum install openstack-cinder-api openstack-cinder-scheduler ceph -y".split(), check=True)

        subprocess.run("cp ./cinder.conf /etc/cinder/cinder.conf".split(), check=True)
        cont = []
        with open("/etc/cinder/cinder.conf", "r") as f:
            while True:
                line = f.readline()
                if line is None or line == "":
                    break
                cont.append(line)

        for i in range(len(cont)):
            if "my_ip = " in cont[i]:
                cont[i] = "my_ip = %s\n" % self._controller_ip

        with open("/etc/cinder/cinder.conf", "w") as f:
            f.writelines(cont)

        os.system("su -s /bin/sh -c \"cinder-manage db sync\" cinder")
        subprocess.run("systemctl restart openstack-nova-api.service".split(), check=True)
        subprocess.run("systemctl enable openstack-cinder-api.service openstack-cinder-scheduler.service".split(), check=True)
        subprocess.run("systemctl start openstack-cinder-api.service openstack-cinder-scheduler.service".split(), check=True)

    def install_horizon(self):
        subprocess.run("yum -y install openstack-dashboard".split(), check=True)
        subprocess.run("cp ./local_settings /etc/openstack-dashboard/".split(), check=True)
        subprocess.run("systemctl restart httpd.service memcached.service".split(), check=True)

    def install_aodh(self):
        conn = pymysql.connect(host=super().controller_ip, user="root", passwd="123456")
        cursor = conn.cursor()
        cursor.execute("CREATE DATABASE aodh;")
        cursor.execute("GRANT ALL PRIVILEGES ON aodh.* TO 'aodh'@'localhost' IDENTIFIED BY %s;", "123456")
        cursor.execute("GRANT ALL PRIVILEGES ON aodh.* TO 'aodh'@'%%' IDENTIFIED BY %s;","123456")
        conn.commit()
        cursor.close()
        conn.close()

        subprocess.run("openstack user create --domain default --password-prompt aodh".split(), check=True)
        subprocess.run("openstack role add --project service --user aodh admin".split(), check=True)
        os.system("openstack service create --name aodh --description \"Telemetry\" alarming")

        subprocess.run("openstack endpoint create --region RegionOne alarming public http://controller:8042".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne alarming internal http://controller:8042".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne alarming admin http://controller:8042".split(), check=True)

        subprocess.run("yum install openstack-aodh-api openstack-aodh-evaluator openstack-aodh-notifier \
                            openstack-aodh-listener openstack-aodh-expirer python3-aodhclient -y".split(), check=True)

        subprocess.run("cp ./aodh.conf /etc/aodh/aodh.conf".split(), check=True)
        os.system("aodh-dbsync")
        subprocess.run("systemctl enable openstack-aodh-api.service openstack-aodh-evaluator.service \
                        openstack-aodh-notifier.service openstack-aodh-listener.service".split(), check=True)
        subprocess.run("systemctl start openstack-aodh-api.service openstack-aodh-evaluator.service \
                        openstack-aodh-notifier.service openstack-aodh-listener.service".split(), check=True)

    def install_gnocchi(self):
        conn = pymysql.connect(host=super().controller_ip, user="root", passwd="123456")
        cursor = conn.cursor()
        cursor.execute("CREATE DATABASE gnocchi;")
        cursor.execute("GRANT ALL PRIVILEGES ON gnocchi.* TO 'gnocchi'@'localhost' IDENTIFIED BY %s;", "123456")
        cursor.execute("GRANT ALL PRIVILEGES ON gnocchi.* TO 'gnocchi'@'%%' IDENTIFIED BY %s;","123456")
        conn.commit()
        cursor.close()
        conn.close()

        subprocess.run("openstack user create --domain default --password-prompt gnocchi".split(), check=True)
        subprocess.run("openstack role add --project service --user gnocchi admin".split(), check=True)
        os.system("openstack service create --name gnocchi --description \"Metric Service\" metric")

        subprocess.run("openstack endpoint create --region RegionOne metric public http://controller:8041".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne metric internal http://controller:8041".split(), check=True)
        subprocess.run("openstack endpoint create --region RegionOne metric admin http://controller:8041".split(), check=True)

        subprocess.run("yum install python3-uWSGI.aarch64 -y".split(), check=True)
        subprocess.run("yum install openstack-gnocchi-api openstack-gnocchi-metricd python3-gnocchiclient -y".split(), check=True)
        subprocess.run("cp ./gnocchi.conf /etc/gnocchi/ -f".split(), check=True)

        subprocess.run("gnocchi-upgrade".split(), check=True)

        subprocess.run("systemctl enable openstack-gnocchi-api.service openstack-gnocchi-metricd.service".split(), check=True)
        subprocess.run("systemctl start openstack-gnocchi-api.service openstack-gnocchi-metricd.service".split(), check=True)

    def install_ceilmeter(self):
        subprocess.run("openstack user create --domain default --password-prompt ceilometer".split(), check=True)
        subprocess.run("openstack role add --project service --user ceilometer admin".split(), check=True)
        os.system("openstack service create --name ceilometer --description \"Telemetry\" metering")

        subprocess.run("yum install openstack-ceilometer-notification openstack-ceilometer-central -y".split(), check=True)

        subprocess.run("cp ./pipeline.yaml /etc/ceilometer/pipeline.yaml".split(), check=True)
        subprocess.run("cp ./ceilometer.conf /etc/ceilometer/ceilometer.conf".split(), check=True)
        subprocess.run("ceilometer-upgrade".split(), check=True)

        subprocess.run("systemctl enable openstack-ceilometer-notification.service openstack-ceilometer-central.service".split(), check=True)
        subprocess.run("systemctl start openstack-ceilometer-notification.service openstack-ceilometer-central.service".split(), check=True)

    def install_openstack_patch(self):
        pass

    def set_network(self):
        net_dev = input("please inpute net dev: ")

        subprocess.run("modprobe 8021q".split(), check=True)
        os.system("echo \"8021q\" > /etc/modules-load.d/8021q.conf")

        subprocess.run(("nmcli conn add type vlan con-name %s.1011 dev %s id 1011 ipv4.method manual \
                            ipv4.address 9.88.14.2/24 gw4 9.88.14.1 autoconnect yes" % (net_dev, net_dev)).split(), check=True)
        
        subprocess.run(("nmcli conn add type vlan con-name %s.1012 dev %s id 1012 ipv4.method manual \
                            ipv4.address 9.88.15.2/24 gw4 9.88.15.1 autoconnect yes" % (net_dev, net_dev)).split(), check=True)
        
        subprocess.run(("nmcli conn add type ethernet con-name %s ifname %s ipv4.method manual \
                            ipv4.address 9.88.17.2/24 gw4 9.88.17.1 autoconnect yes" % (net_dev, net_dev)).split(), check=True)
