#ifndef _RTE_ADAPTER_H
#define _RTE_ADAPTER_H

#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <stdarg.h>

#include "rte_atomic.h"
#include "rte_bus.h"
#include "rte_bus_pci.h"
#include "rte_bus_vdev.h"
#include "rte_cfgfile.h"
#include "rte_cycles.h"
#include "rte_dev.h"
#include "rte_devargs.h"
#include "rte_ethdev.h"
#include "rte_ethdev_driver.h"
#include "rte_bus_pci.h"
#include "rte_ethdev_pci.h"
#include "rte_flow.h"
#include "rte_flow_driver.h"
#include "rte_mbuf.h"
#include "rte_mempool.h"
#include "rte_ring.h"
#include "rte_spinlock.h"

extern void rte_adapter_init(void);
extern void rte_adapter_uninit(void);

void rte_atomic16_init_stub(rte_atomic16_t *v);
int16_t rte_atomic16_read_stub(const rte_atomic16_t *v);
void rte_atomic16_set_stub(rte_atomic16_t *v, int16_t new_value);
void rte_atomic16_add_stub(rte_atomic16_t *v, int16_t inc);
void rte_atomic16_sub_stub(rte_atomic16_t *v, int16_t dec);
void rte_atomic16_inc_stub(rte_atomic16_t *v);
void rte_atomic16_dec_stub(rte_atomic16_t *v);
void rte_atomic32_init_stub(rte_atomic32_t *v);
int32_t rte_atomic32_read_stub(rte_atomic32_t *v);
void rte_atomic32_set_stub(rte_atomic32_t *v, int32_t new_value);
void rte_atomic32_add_stub(rte_atomic32_t *v, int32_t inc);
void rte_atomic32_sub_stub(rte_atomic32_t *v, int32_t dec);
void rte_atomic32_inc_stub(rte_atomic32_t *v);
void rte_atomic32_dec_stub(rte_atomic32_t *v);

struct rte_pci_device_list* rte_pci_bus_get_device_list_ptr(struct rte_pci_bus *pci_bus);
struct rte_pci_device* rte_pci_device_list_get_first(struct rte_pci_device_list *device_list);
struct rte_pci_driver* rte_pci_driver_allocate(void);
void rte_pci_driver_free(struct rte_pci_driver *driver);
void rte_pci_driver_set_name(struct rte_pci_driver *driver, const char *name);
void rte_pci_driver_set_id_table(struct rte_pci_driver *driver, const struct rte_pci_id *pci_id);
void rte_pci_driver_set_drv_flags(struct rte_pci_driver *driver, uint32_t drv_flags);
void rte_pci_driver_set_probe(struct rte_pci_driver *driver, void *arg);
void rte_pci_driver_set_remove(struct rte_pci_driver *driver, void *arg);
struct rte_pci_device* rte_pci_device_get_next(struct rte_pci_device *pci_dev);
struct rte_pci_addr* rte_pci_device_get_addr_ptr(struct rte_pci_device *device);
struct rte_pci_id* rte_pci_device_get_id_ptr(struct rte_pci_device *device);
struct rte_mem_resource* rte_pci_device_get_mem_resource(struct rte_pci_device *device);
struct rte_device* rte_pci_device_get_device_ptr(struct rte_pci_device *device);
char* rte_pci_device_get_name(struct rte_pci_device *device);

struct rte_device* rte_vdev_device_get_device_ptr(struct rte_vdev_device *dev);
const char* rte_vdev_device_name_stub(const struct rte_vdev_device *dev);
struct rte_vdev_driver* rte_vdev_driver_allocate(void);
void rte_vdev_driver_free(struct rte_vdev_driver *driver);
void rte_vdev_driver_set_probe(struct rte_vdev_driver *driver, void *arg);
void rte_vdev_driver_set_remove(struct rte_vdev_driver *driver, void *arg);
void rte_vdev_driver_set_name(struct rte_vdev_driver *driver, const char *name);
void rte_vdev_driver_set_alias(struct rte_vdev_driver *driver, const char *alias);

uint64_t rte_get_tsc_cycles_stub(void);
void rte_delay_ms_stub(unsigned ms);
uint64_t rte_rdtsc_stub(void);
uint64_t rte_get_tsc_hz_stub(void);

const struct rte_driver* rte_device_get_driver(struct rte_device *device);
const char* rte_device_get_name(struct rte_device *device);
struct rte_devargs* rte_device_get_devargs(struct rte_device *device);

struct rte_eth_dev_info* rte_eth_dev_info_allocate(void);
void rte_eth_dev_info_free(struct rte_eth_dev_info *info);
void rte_eth_dev_info_set_driver_name(struct rte_eth_dev_info *info, char *driver_name);
void rte_eth_dev_info_set_max_rx_queues(struct rte_eth_dev_info *info, uint16_t max_rx_queues);
void rte_eth_dev_info_set_max_tx_queues(struct rte_eth_dev_info *info, uint16_t max_tx_queues);
void rte_eth_dev_info_set_max_rx_pktlen(struct rte_eth_dev_info *info, uint32_t max_rx_pktlen);
void rte_eth_dev_info_set_min_mtu(struct rte_eth_dev_info *info, uint16_t min_mtu);
void rte_eth_dev_info_set_max_mtu(struct rte_eth_dev_info *info, uint16_t max_mtu);
void rte_eth_dev_info_set_if_index(struct rte_eth_dev_info *info, unsigned int if_index);
const char* rte_eth_dev_info_get_driver_name(struct rte_eth_dev_info *info);
uint32_t rte_eth_dev_info_get_if_index(struct rte_eth_dev_info *info);

void rte_eth_dev_set_device(struct rte_eth_dev *dev, struct rte_device *device);
void rte_eth_dev_set_dev_ops(struct rte_eth_dev *dev, struct eth_dev_ops *dev_ops);
void rte_eth_dev_set_rx_pkt_burst(struct rte_eth_dev *dev, void *burst_cb);
void rte_eth_dev_set_tx_pkt_burst(struct rte_eth_dev *dev, void *burst_cb);
struct rte_device* rte_eth_dev_get_device(struct rte_eth_dev *dev);
struct rte_eth_dev_data* rte_eth_dev_get_data(struct rte_eth_dev *dev);
void* rte_eth_dev_get_data_dev_private(struct rte_eth_dev *dev);
struct rte_eth_link* rte_eth_dev_get_data_dev_link_ptr(struct rte_eth_dev *dev);
struct rte_pci_device* rte_eth_dev_get_pci_device_ptr(struct rte_eth_dev *dev);
void rte_eth_dev_data_set_rx_queues(struct rte_eth_dev_data *data, void **queues);
void rte_eth_dev_data_set_rx_queue_single(struct rte_eth_dev_data *data, int idx, void *queue);
void rte_eth_dev_data_set_tx_queues(struct rte_eth_dev_data *data, void **queues);
void rte_eth_dev_data_set_tx_queue_single(struct rte_eth_dev_data *data, int idx, void *queue);
void rte_eth_dev_data_set_dev_private(struct rte_eth_dev_data *data, void *private_data);
void rte_eth_dev_data_set_nb_rx_queues(struct rte_eth_dev_data *data,uint16_t nb_queues);
void rte_eth_dev_data_set_nb_tx_queues(struct rte_eth_dev_data *data, uint16_t nb_queues);
void rte_eth_dev_data_set_dev_link(struct rte_eth_dev_data *data, struct rte_eth_link dev_link);
void rte_eth_dev_data_set_mac_addrs(struct rte_eth_dev_data *data, struct rte_ether_addr *mac_addrs);
void rte_eth_dev_data_set_numa_node(struct rte_eth_dev_data *data, int numa_node);
void rte_eth_dev_data_set_mtu(struct rte_eth_dev_data *data, uint16_t mtu);
void rte_eth_dev_data_set_dev_started(struct rte_eth_dev_data *data, uint8_t dev_started);
void* rte_eth_dev_data_get_rx_queue_single(struct rte_eth_dev_data *data, int idx);
void* rte_eth_dev_data_get_tx_queue_single(struct rte_eth_dev_data *data, int idx);
uint16_t rte_eth_dev_data_get_nb_rx_queues(struct rte_eth_dev_data *data);
uint16_t rte_eth_dev_data_get_nb_tx_queues(struct rte_eth_dev_data *data);
struct rte_ether_addr* rte_eth_dev_data_get_mac_addrs(struct rte_eth_dev_data *data);
int rte_eth_dev_data_get_numa_node(struct rte_eth_dev_data *data);
char* rte_eth_dev_data_get_name(struct rte_eth_dev_data *data);
void* rte_eth_dev_data_get_dev_private(struct rte_eth_dev_data *data);
struct rte_eth_link* rte_eth_dev_data_get_dev_link_ptr(struct rte_eth_dev_data *data);
uint16_t rte_eth_dev_data_get_mtu(struct rte_eth_dev_data *data);
uint8_t rte_eth_dev_data_get_dev_started(struct rte_eth_dev_data *data);

struct eth_dev_ops* rte_eth_dev_ops_allocate(void);
void rte_eth_dev_ops_free(struct eth_dev_ops *edev_ops);
void rte_eth_dev_ops_set_dev_configure(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_dev_start(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_dev_stop(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_dev_close(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_dev_set_link_down(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_dev_set_link_up(struct eth_dev_ops *edev_ops,void *arg);
void rte_eth_dev_ops_set_dev_infos_get(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_stats_get(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_stats_reset(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_xstats_get_names(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_link_update(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_mtu_set(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_rx_queue_setup(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_tx_queue_setup(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_rx_queue_release(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_tx_queue_release(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_flow_ops_get(struct eth_dev_ops *edev_ops, void *arg);
void rte_eth_dev_ops_set_extra_config_set(struct eth_dev_ops *edev_ops, void *arg);

int rte_eth_dev_pci_generic_probe_stub(struct rte_pci_device *pci_dev,
    size_t private_data_size, eth_dev_pci_callback_t dev_init);
int rte_eth_dev_pci_generic_remove_stub(struct rte_pci_device *pci_dev,
    eth_dev_pci_callback_t dev_uninit);

struct rte_flow_ops* rte_flow_ops_allocate(void);
void rte_flow_ops_free(struct rte_flow_ops *flow_ops);
void rte_flow_ops_set_validate(struct rte_flow_ops *flow_ops, void *arg);
void rte_flow_ops_set_create(struct rte_flow_ops *flow_ops, void *arg);
void rte_flow_ops_set_destroy(struct rte_flow_ops *flow_ops, void *arg);
void rte_flow_ops_set_flush(struct rte_flow_ops *flow_ops, void *arg);
void rte_flow_ops_set_query(struct rte_flow_ops *flow_ops, void *arg);

size_t rte_mbuf_struct_size(void);
void* rte_mbuf_get_udata64_ptr(struct rte_mbuf *mbuf);
void* rte_pktmbuf_get_data(struct rte_mbuf *mbuf);
uint32_t rte_pktmbuf_get_data_len(struct rte_mbuf *mbuf);
uint32_t rte_pktmbuf_get_pkt_len(struct rte_mbuf *mbuf);
uint64_t rte_mbuf_get_ol_flags(struct rte_mbuf *mbuf);
uint16_t rte_mbuf_get_vlan_tci(struct rte_mbuf *mbuf);
uint32_t rte_mbuf_get_hash_rss(struct rte_mbuf *mbuf);
void rte_mbuf_set_ol_flags(struct rte_mbuf *mbuf, uint64_t flag);
struct rte_mbuf* rte_pktmbuf_alloc_stub(struct rte_mempool *mp);
int rte_pktmbuf_alloc_bulk_stub(struct rte_mempool *pool,
    struct rte_mbuf **mbufs, unsigned count);
void rte_pktmbuf_free_stub(struct rte_mbuf *m);

int rte_mempool_get_stub(struct rte_mempool *mp, void **obj_p);
void rte_mempool_put_bulk_stub(struct rte_mempool *mp, void *const *obj_table, 
    unsigned int n);
void rte_mempool_put_stub(struct rte_mempool *mp, void *obj);

unsigned int rte_ring_enqueue_burst_stub(struct rte_ring *r, void *const *obj_table,
    unsigned int n, unsigned int *free_space);
unsigned int rte_ring_dequeue_burst_stub(struct rte_ring *r, void **obj_table,
    unsigned int n, unsigned int *available);
unsigned int rte_ring_count_stub(const struct rte_ring *r);

void rte_spinlock_init_stub(rte_spinlock_t *sl);
void rte_spinlock_lock_stub(rte_spinlock_t *sl);
void rte_spinlock_unlock_stub(rte_spinlock_t *sl);
void rte_spinlock_trylock_stub(rte_spinlock_t *sl);

#endif