/*
 * Copyright (c) 2021-2022. Huawei Technologies Co., Ltd.
 * Description: ct_offload_privider
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * Create: 2021-07-09
 */
#ifndef CT_OFFLOAD_PROVIDER_H
#define CT_OFFLOAD_PROVIDER_H

#include "openvswitch/types.h"
#include "dp-packet.h"

#ifdef HAVE_HWOFF_AGENT
#define INVALID_CONN_ID  0

typedef uint32_t conn_id;
struct conn;
struct conntrack;
struct ct_dpif_entry;

enum {
    CONN_STATE_DELETE,
};

typedef struct {
    int (*ovs_ct_init_notify)(struct conntrack *ovs_ct);
    int (*complete_ct_info)(struct conn *conn, struct dp_packet *packet);
    int (*conn_state_notify)(struct conn *conn, int new_state);
    int (*get_ct_offload_info)(const struct conn *conn, struct ct_dpif_entry *entry);
    void (*update_conn_statistics)(struct conn *conn);
    volatile uint16_t cleaned;
    volatile uint16_t reserved[3];
} ct_offload_class;

#endif // HAVE_HWOFF_AGENT

#endif