#!/usr/bin/env python3
# coding=utf-8
# Copyright (C) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import subprocess
import node
import os

class Compute(node.Node):
    @property
    def index(self):
        return self._index

    @index.setter
    def index(self, index: int):
        if index != 0 and index != 1:
            raise ValueError("Incorrect compute index: %d" % index)
        self._index = index

    def set_chrony_conf(self):
        subprocess.run("cp -f ./chrony.conf /etc/".split(), check=True)

    def _get_ip(self):
        if self._index == 0:
            return super().compute1_ip
        if self._index == 1:
            return super().compute2_ip

    def install_neutron(self):
        super().install_neutron()
        subprocess.run("yum install -y openstack-neutron openstack-neutron-ml2 openstack-neutron-openvswitch ebtables patch".split(), check=True)
        self._rabbit_password = "123456"
        self._neutron_password = "123456"
        cont = []
        with open("/etc/neutron/neutron.conf", "r") as f:
            while True:
                line = f.readline()
                if line == None or line == '':
                    break
                cont.append(line)

        index1 = 0
        index2 = 0
        index3 = 0
        for i in range(len(cont)):
            if cont[i] == '[DEFAULT]\n':
                index1 = i + 1
        cont.insert(index1, "service_plugins = neutron.services.qos.qos_plugin.QoSPlugin\n"
                            "transport_url = rabbit://openstack:%s@controller\n"
                            "auth_strategy = keystone\n" % self._rabbit_password)

        for i in range(len(cont)):
            if cont[i] == '[oslo_concurrency]\n':
                index2 = i + 1
        cont.insert(index2, "lock_path = /var/lib/neutron/tmp\n")

        for i in range(len(cont)):
            if cont[i] == '[keystone_authtoken]\n':
                index3 = i + 1
        cont.insert(index3, "www_authenticate_uri = http://controller:5000\n"
                            "auth_url = http://controller:5000\n"
                            "memcached_servers = controller:11211\n"
                            "auth_type = password\n"
                            "project_domain_name = Default\n"
                            "user_domain_name = Default\n"
                            "project_name = service\n"
                            "username = neutron\n"
                            "password = %s\n" % self._neutron_password)

        with open("/etc/neutron/neutron.conf", "w") as f:
            f.writelines(cont)

        cont = []
        with open("/etc/neutron/metadata_agent.ini", "r") as f:
            while True:
                line = f.readline()
                if line == None or line == '':
                    break
                cont.append(line)
        index = 0
        for i in range(len(cont)):
            if cont[i] == '[DEFAULT]\n':
                index = i + 1
        cont.insert(index, "nova_metadata_host = controller\n"
                            "metadata_proxy_shared_secret = %s\n" % self._neutron_password)

        with open("/etc/neutron/metadata_agent.ini", "w") as f:
            f.writelines(cont)

        cont = []
        with open("/etc/neutron/l3_agent.ini", "r") as f:
            while True:
                line = f.readline()
                if line == None or line == '':
                    break
                cont.append(line)
        index = 0
        for i in range(len(cont)):
            if cont[i] == '[DEFAULT]\n':
                index = i + 1
        cont.insert(index, "interface_driver = openvswitch\n")

        with open("/etc/neutron/l3_agent.ini", "w") as f:
            f.writelines(cont)

        with open("/etc/neutron/plugins/ml2/openvswitch_agent.ini", "a") as f:
            agent = "[agent]\n" \
                    "tunnel_types = vxlan\n" \
                    "extensions = qos\n"

            ovs =   "[ovs]\n" \
                    "datapath_type = netdev\n" \
                    "tunnel_bridge = br-tun\n" \
                    "bridge_mappings = provider:br-ex\n" \
                    "local_ip = 9.88.17.%s\n" \
                    "of_connect_timeout = 60\n" % str(self._index + 4)

            securitygroup = "[securitygroup]\n" \
                            "enable_ipset = true\n" \
                            "enable_security_group = true\n" \
                            "firewall_driver = iptables_hybrid\n"

            ml2 = "[ml2]\n" \
                    "type_drivers = flat,vlan,vxlan\n" \
                    "tenant_network_types = vxlan\n" \
                    "mechanism_drivers = openvswitch\n" \
                    "extension_drivers = port_security,qos\n"

            ml2_type_flat = "[ml2_type_flat]\n" \
                            "flat_networks = provider\n"

            ml2_type_vlan = "[ml2_type_flat]\n" \
                            "network_vlan_ranges = provider\n"

            ml2_type_vxlan = "[ml2_type_vxlan]\n" \
                                "vni_ranges = 1:1000\n"

            f.writelines([agent, ovs, securitygroup, ml2, ml2_type_flat, ml2_type_vlan, ml2_type_vxlan])

        cont = []
        with open("/etc/sysctl.conf", "r") as f:
            while True:
                line = f.readline()
                if line is None or line == "":
                    break
                cont.append(line)

        for i in range(len(cont)):
            if "net.ipv4.ip_forward" in cont[i]:
                cont[i] = "net.ipv4.ip_forward=1\n"
            if "net.ipv4.conf.all.rp_filter" in cont[i]:
                cont[i] = "net.ipv4.conf.all.rp_filter=0\n"
            if "net.ipv4.conf.default.rp_filter" in cont[i]:
                cont[i] = "net.ipv4.conf.default.rp_filter=0\n"

        with open("/etc/sysctl.conf", "w") as f:
            f.writelines(cont)

        subprocess.run("sysctl -p".split(), check=True)
        subprocess.run("systemctl enable neutron-openvswitch-agent.service".split(), check=True)
        subprocess.run("systemctl start neutron-openvswitch-agent.service".split(), check=True)
        subprocess.run("ovs-vsctl add-br br-ex -- set bridge br-ex datapath_type=netdev".split(), check=True)

    def install_nova(self):
        subprocess.run("yum install openstack-nova-compute edk2-aarch64 libudev-devel libpciaccess-devel -y".split(), check=True)
        subprocess.run("yum update glibc -y".split(), check=True)

        subprocess.run("cp -f ./nova_compute.conf /etc/nova/nova.conf".split(), check=True)
        cont = []
        with open("/etc/nova/nova.conf", "r") as f:
            while True:
                line = f.readline()
                if line is None or line == "":
                    break
                cont.append(line)

        for i in range(len(cont)):
            if "transport_url = " in cont[i]:
                cont[i] = "transport_url = rabbit://openstack:123456@controller:5672/\n"

            if "my_ip = " in cont[i]:
                cont[i] = "my_ip = %s\n" % self._get_ip()

            if "password =" in cont[i]:
                cont[i] = "password = 123456\n"

            if "live_migration_inbound_addr=9.88.16.4" in cont[i]:
                cont[i] = "live_migration_inbound_addr=9.88.16.%s\n" % str(self.index + 4)

        with open("/etc/nova/nova.conf", "w") as f:
            f.writelines(cont)

        subprocess.run("mkdir -p /usr/share/AAVMF".split(), check=True)
        subprocess.run("chown nova:nova /usr/share/AAVMF".split(), check=True)

        subprocess.run("ln -s /usr/share/edk2/aarch64/QEMU_EFI-pflash.raw /usr/share/AAVMF/AAVMF_CODE.fd".split(), check=True)
        subprocess.run("ln -s /usr/share/edk2/aarch64/vars-template-pflash.raw /usr/share/AAVMF/AAVMF_VARS.fd".split(), check=True)
        subprocess.run("cp ./qemu.conf /etc/libvirt/qemu.conf".split(), check=True)

        subprocess.run("systemctl enable libvirtd.service openstack-nova-compute.service".split(), check=True)
        subprocess.run("systemctl start libvirtd.service openstack-nova-compute.service".split(), check=True)
        subprocess.run("virsh secret-define --file secret.xml".split(), check=True)

    def install_cinder(self):
        super().install_cinder()
        subprocess.run("yum install lvm2 device-mapper-persistent-data scsi-target-utils rpcbind nfs-utils python3-rbd ceph\
                        openstack-cinder-volume openstack-cinder-backup -y".split(), check=True)

        subprocess.run("mkdir -p /root/cinder/backup".split(), check=True)
        os.system("cat << EOF >> /etc/exports \
                    /root/cinder/backup %s(subtree_check,rw,sync,no_root_squash,no_all_squash) \
                    EOF" % self._get_ip())

        with open("/etc/cinder/nfs_shares", "w") as f:
            f.write("%s:/etc/cinder/nfs_shares" % self._get_ip())

        subprocess.run("cp -f ./compute_cinder.conf /etc/cinder/cinder.conf".split(), check=True)
        cont = []
        with open("/etc/cinder/cinder.conf", "r") as f:
            while True:
                line = f.readline()
                if line is None or line == "":
                    break
                cont.append(line)

        for i in range(len(cont)):
            if "my_ip = " in cont[i]:
                cont[i] = "my_ip = %s\n" % self._get_ip()

        with open("/etc/cinder/cinder.conf", "w") as f:
            f.writelines(cont)
        subprocess.run("systemctl enable openstack-cinder-volume.service openstack-cinder-backup.service".split(), check=True)
        subprocess.run("systemctl start openstack-cinder-volume.service openstack-cinder-backup.service".split(), check=True)

    def install_ceilmeter(self):
        subprocess.run("yum install openstack-ceilometer-compute -y".split(), check=True)
        subprocess.run("cp ./celimeter_compute.conf /etc/ceilometer/ceilometer.conf".split(), check=True)

        subprocess.run("systemctl enable openstack-ceilometer-compute.service".split(), check=True)
        subprocess.run("systemctl start openstack-ceilometer-compute.service".split(), check=True)

        subprocess.run("systemctl restart openstack-nova-compute.service".split(), check=True)

    def install_mgmt(self):
        subprocess.run("unzip DPU-Solution-dpak-tools-host-repo_1.0.0_aarch64.zip".split(), check=True)
        subprocess.run("rpm -ivh dpak-smi-host-repo-1.0.0-1-aarch64.rpm".split(), check=True)

    def install_ovs(self):
        subprocess.run("unzip DPU-Solution-dpak-runtime-host-repo_1.0.0_aarch64.zip".split(), check=True)
        subprocess.run("rpm -ivh dpak-libovs-host-repo-1.0.0-1-aarch64.rpm".split(), check=True)
        subprocess.run("rpm -e --nodeps dpdk-devel-19.11-17.oe1.aarch64".split(), check=True)
        subprocess.run("rpm -e --nodeps dpdk-19.11-17.oe1.aarch64".split(), check=True)
        subprocess.run("unzip dpak-devel-ref-host-repo_1.0.0_aarch64.zip".split(), check=True)
        subprocess.run("rpm -e --nodeps openvswitch-2.12.0-16.oe1.aarch64".split(), check=True)
        subprocess.run("rpm -e --nodeps openvswitch-help-2.12.0-16.oe1.aarch64".split(), check=True)
        subprocess.run("rpm -ivh dpak-devel-ref-host-repo-1.0.0-aarch64/network-acc/dpdk-21.11/dpdk-21.11-1.aarch64.rpm".split(), check=True)
        subprocess.run("rpm -ivh dpak-devel-ref-host-repo-1.0.0-aarch64/network-acc/dpdk-21.11/dpdk-devel-21.11-1.aarch64.rpm --nodeps --force".split(), check=True)
        subprocess.run("rpm -ivh dpak-devel-ref-host-repo-1.0.0-aarch64/network-acc/openvswitch-2.14.2/openvswitch-* --nodeps".split(), check=True)
        pf0_bdf = input("Please input pf0 bdf: ")
        subprocess.run("service openvswitch start".split())
        subprocess.run("ovs-vsctl --no-wait set Open_vSwitch . other_config:dpdk-init=true".split(), check=True)
        subprocess.run("ovs-vsctl --no-wait set Open_vSwitch . other_config:dpdk-socket-mem=\"8192\"".split(), check=True)
        subprocess.run(("ovs-vsctl --no-wait set Open_vSwitch . other_config:hwoff-pf-pci=0000:%s" % pf0_bdf).split(), check=True)
        subprocess.run("ovs-vsctl --no-wait set Open_vSwitch . other_config:hw-offload=true".split(), check=True)
        subprocess.run("ovs-vsctl --no-wait set Open_vSwitch . other_config:dpdk-extra=\"--iova-mode=pa\"".split(), check=True)
        subprocess.run("ovs-vsctl --no-wait set Open_vSwitch . other_config:dpdk-lcore-mask=0x8".split(), check=True)
        subprocess.run("ovs-vsctl --no-wait set Open_vSwitch . other_config:pmd-cpu-mask=0x8".split(), check=True)
        subprocess.run("service openvswitch restart".split(), check=True)
        subprocess.run("systemctl restart neutron-openvswitch-agent.service".split(), check=True)
        pf2_bdf = input("Please input pf2 bdf: ")
        subprocess.run("ovs-vsctl add-br br-dpdk -- set bridge br-dpdk datapath_type=netdev".split())
        subprocess.run(("ovs-vsctl add-port br-dpdk bond1 -- set interface bond1 type=dpdk options:dpdk-devargs=%s," \
                            "bond_name=bond1 options:n_rxq=2" % pf2_bdf).split(), check=True)
        sub_ip = "4" if self._index == 0 else "5"
        subprocess.run(("ifconfig br-dpdk 9.88.17.%s/24" % sub_ip).split(), check=True)

    def install_openstack_patch(self):
        subprocess.run("unzip dpak-devel-host-repo_1.0.0_aarch64.zip".split(), check=True)
        subprocess.run("cp dpak-devel-host-repo_1.0.0_aarch64/openstack-Train/nova-20.6.1/nova.patch /usr/lib/python3.7/site-packages/".split(), check=True)
        subprocess.run("cp dpak-devel-host-repo_1.0.0_aarch64/openstack-Train/os-vif-1.17.0/os-vif.patch /usr/lib/python3.7/site-packages/".split(), check=True)
        subprocess.run("cp dpak-devel-host-repo_1.0.0_aarch64/openstack-Train/neutron-15.3.4/neutron.patch /usr/lib/python3.7/site-packages/".split(), check=True)
        subprocess.run("cp dpak-devel-host-repo_1.0.0_aarch64/openstack-Train/ceilometer-13.1.2/ceilometer.patch /usr/lib/python3.7/site-packages/".split(), check=True)
        os.system("cd /usr/lib/python3.7/site-packages/ && patch -p4 < nova.patch")
        os.system("cd /usr/lib/python3.7/site-packages/ && patch -p4 < os-vif.patch")
        os.system("cd /usr/lib/python3.7/site-packages/ && patch -p4 < neutron.patch")
        os.system("cd /usr/lib/python3.7/site-packages/ && patch -p4 < ceilometer.patch")

        subprocess.run("mkdir -p /etc/ceilometer/rootwrap.d/".split(), check=True)
        subprocess.run("cp openvswitch-plugin.filters /etc/ceilometer/rootwrap.d/".split(), check=True)

        subprocess.run("systemctl restart openstack-nova-compute".split(), check=True)
        subprocess.run("systemctl restart neutron-openvswitch-agent".split(), check=True)
        subprocess.run("systemctl restart openstack-ceilometer-compute".split(), check=True)

    def install_hotliv(self):
        subprocess.run("rpm -ivh --force dpak-devel-ref-host-repo-1.0.0-aarch64/vpam/libvirt-6.9.0/dpak-libvirt-6.9.0-1.aarch64.rpm --nodeps".split(), check=True)
        subprocess.run("rpm -ivh --force dpak-devel-ref-host-repo-1.0.0-aarch64/vpam/qemu-5.0.0/dpak-qemu-5.0.0-1.aarch64.rpm --nodeps".split(), check=True)
        subprocess.run("rpm -ivh --force dpak-devel-ref-host-repo-1.0.0-aarch64/vpam/vfio-openEuler-20.03-LTS-SP1/dpak-vfio-4.19.90-2012.4.0.0053.oe1.aarch64.rpm --nodeps".split(), check=True)
        subprocess.run("rmmod vfio_pci".split())
        subprocess.run("rmmod vfio_virqfd".split())
        subprocess.run("rmmod vfio_iommu_type1".split())
        subprocess.run("rmmod vfio".split())

        subprocess.run("modprobe vfio".split(), check=True)
        subprocess.run("modprobe vfio_iommu_type1".split(), check=True)
        subprocess.run("modprobe vfio_virqfd".split(), check=True)
        subprocess.run("modprobe vfio_pci".split(), check=True)
        subprocess.run("modprobe mgmt_migration_hinic3".split(), check=True)

        subprocess.run("cp ./qemu.conf /etc/libvirt/qemu.conf".split(), check=True)
        subprocess.run("systemctl restart libvirtd".split(), check=True)
        subprocess.run("systemctl restart openstack-nova-compute".split(), check=True)

    def set_network(self):
        self._pf0 = input("please input pf0 network dev name (such as enp125s0f0): ")
        self._pf1 = input("please input pf1 network dev name (such as enp125s0f0): ")
        self._pf2 = input("please input pf2 network dev name (such as enp125s0f0): ")
        self._pf3 = input("please input pf3 network dev name (such as enp125s0f0): ")

        subprocess.run(("ip link set dev %s down" % self._pf0).split(), check=True)
        subprocess.run(("ip link set dev %s down" % self._pf1).split(), check=True)
        subprocess.run("ip link add bond0 type bond mode active-backup".split(), check=True)
        subprocess.run(("ip link set %s master bond0" % self._pf0).split(), check=True)
        subprocess.run(("ip link set %s master bond0" % self._pf1).split(), check=True)
        subprocess.run("ip link set dev bond0 up".split(), check=True)

        subprocess.run(("ip link set dev %s down" % self._pf2).split(), check=True)
        subprocess.run(("ip link set dev %s down" % self._pf3).split(), check=True)
        subprocess.run("ip link add bond1 type bond mode active-backup".split(), check=True)
        subprocess.run(("ip link set %s master bond1" % self._pf2).split(), check=True)
        subprocess.run(("ip link set %s master bond1" % self._pf3).split(), check=True)
        subprocess.run("ip link set dev bond1 up".split(), check=True)

        sub_ip = "4" if self._index == 0 else "5"
        os.system("echo \"8021q\" > /etc/modules-load.d/8021q.conf")
        subprocess.run("modprobe 8021q".split(), check=True)
        subprocess.run(("nmcli conn add type vlan con-name bond0.1011 dev bond0 id 1011 ipv4.method manual ipv4.address 9.88.14.%s/24 gw4 9.88.14.1 autoconnect yes" % str(self.index + 4)).split(), check=True)
        subprocess.run(("nmcli conn add type vlan con-name bond0.1012 dev bond0 id 1012 ipv4.method manual ipv4.address 9.88.15.%s/24 gw4 9.88.15.1 autoconnect yes" % str(self.index + 4)).split(), check=True)
        subprocess.run(("nmcli conn add type vlan con-name bond0.1013 dev bond0 id 1013 ipv4.method manual ipv4.address 9.88.16.%s/24 gw4 9.88.16.1 autoconnect yes" % str(self.index + 4)).split(), check=True)
        subprocess.run("hinicadm3 share_plane -i hinic0 -v 1011 -t 2 -s".split(), check=True)
        subprocess.run("hinicadm3 share_plane -i hinic0 -v 1012 -t 2 -s".split(), check=True)
        subprocess.run("hinicadm3 share_plane -i hinic0 -v 1013 -t 2 -s".split(), check=True)

        subprocess.run("ping 9.88.14.2 -c 4".split(), check=True)
        if self._index == 1:
            subprocess.run("ping 9.88.14.4 -c 4".split(), check=True)