/*
 * Copyright (c) 2021 Cloudbase Solutions Srl
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef HWOFF_INIT_FUNC_H
#define HWOFF_INIT_FUNC_H 1

#include "dpak_ovs.h"

typedef struct {
    int (*hwoff_agent_construct)(const struct smap *ovs_other_config, const char *pf_pci_addr_str, int pmd_nums,
        hwoff_rte_pktmbuf_init_cb cb_func);
    void (*hwoff_agent_destruct)(void *aux);
    int (*hwoff_rte_flow_query_count)(struct netdev *netdev, struct rte_flow *rte_flow, 
        struct rte_flow_query_count *query, struct rte_flow_error *error);
    struct rte_flow *(*hwoff_rte_flow_create)(struct netdev *netdev, const struct rte_flow_attr *attr,
        const struct rte_flow_item *items, const struct rte_flow_action *actions, 
        struct rte_flow_error *error);
    int (*hwoff_rte_flow_destroy)(struct netdev *netdev, struct rte_flow *rte_flow, 
        struct rte_flow_error *error);
    uint32_t (*hwoff_get_eth_vport_id)(struct netdev *netdev);
    bool (*hwoff_is_hiovs_netdev)(const struct netdev *netdev);
    bool (*hwoff_is_ethdev)(const struct netdev *netdev);
    bool (*hwoff_is_support_offload)(const struct netdev *netdev);
    struct rte_flow* (*hwoff_rte_flow_alloc)(ovs_u128 *ufid, void* flow_data);
    void (*hwoff_rte_flow_dealloc)(struct rte_flow *flow);
    void (*hwoff_rte_flow_deleted_set)(struct rte_flow *flow, bool flag);
    bool (*hwoff_rte_flow_deleted_get)(struct rte_flow *flow);
    int (*hwoff_global_add_vxlan_vtep)(uint32_t vxlan_dstip);
    int (*hwoff_global_del_vxlan_vtep)(uint32_t vxlan_dstip);
    uint16_t (*hwoff_tnl_get_src_port)(struct dp_packet *one_pkt);
    void (*hwoff_dp_hook_entry)(struct hwoff_dp_hook_arg *arg);
    int (*hwoff_set_module_log_level)(const char *module, uint32_t level);
    void (*hwoff_parse_ovs_other_config)(const struct smap *ovs_other_config);
    void (*hwoff_set_offload_state)(hwoff_offload_state_t offload);
    void (*hwoff_set_qos)(uint16_t port_id, const char *type, const struct smap *details);
    void (*hwoff_set_ingress_policing)(uint16_t port_id, uint32_t policer_rate, uint32_t policer_burst);
    int (*hwoff_parse_vf_extra_options)(uint16_t dpdk_port_id, const struct smap *port_config);
} hwoff_func;

hwoff_func* hwoff_get_funcs(void);
int hwoff_funcs_init(void);
#endif 
