#!/usr/bin/python
# -*- coding: UTF-8 -*-

import os
import re
import time
from openpyxl import load_workbook


def write_col_names():
    # 每列表头所占单元格列数，方便做单元格合并操作
    col_number = [11, 4, 5, 8, 5, 5, 5, 5, 2, 3, 2, 2, 4]
    col = 1
    for i in range(len(col_names)):
        # 第一行写表头信息
        worksheet.merge_cells(start_row=1, start_column=col, end_row=1, end_column=col + col_number[i] - 1)
        worksheet.cell(row=1, column=col, value=col_names[i])
        # 第二行写子表头信息, cpu中，后五个进程名信息不用写，带获取TOP数据后填充 列信息为[7,11]
        for j in range(len(col_sub_names[i])):
            if (col + j >= 7) and (col + j <= 11):
                continue
            worksheet.cell(row=2, column=col + j, value=col_sub_names[i][j])
        col += col_number[i]


def write_to_key_sheet(data_list, col_start):
    # 填充到负载均衡数据sheet
    for i, data in enumerate(data_list):
        this_cell = worksheet.cell(3, i + col_start)
        if type(data) == str:
            if data.__contains__("%"):
                data_list[i] = float(data.strip("%")) / 100
                this_cell.number_format = '0.00%'
            else:
                data_list[i] = float(data)
        worksheet.cell(3, i + col_start, data_list[i])


def write_mean_data_to_sheet(data_list, sheet, col_offset):
    # 在最大行往后3行写入数据
    row = sheet.max_row + 3
    # 先写Avg.
    sheet.cell(row, 1, "Avg.")
    # 往Avg.后一行写平均值
    row += 1
    for i, data in enumerate(data_list):
        sheet.cell(row, i + col_offset, data)

def check_sheet_exist(workbook, sheet):
    if sheet not in workbook.sheetnames:
        print("ERROR! There is no ", sheet, "data!")
        return -1
    return 0


def get_top_mean_list(workbook):
    sheet_name = "TOP"
    if check_sheet_exist(workbook, sheet_name) < 0:
        return
    # 获取“TOP”中的["mem_used", "cpu_user", "cpu_sys", "cpu_used"]平均值
    ws_top = workbook[sheet_name]

    # 平均值在最后一行，从第二列开始
    top_sum_list = [0, 0, 0, 0]
    # 从第二列开始读取数据
    col = 2
    while col <= ws_top.max_column:
        top_sum_list[(col + 2) % 4] += float(ws_top.cell(ws_top.max_row, col).value.strip("%"))
        col += 1
    top_mean_list = [str(data * 4 / (ws_top.max_column - 1))[0:6] + "%" for data in top_sum_list]
    return top_mean_list


def get_ps_info(workbook):
    sheet_name = "PS_MEAN"
    if check_sheet_exist(workbook, sheet_name) < 0:
        return

    ws_ps_mean = workbook[sheet_name]
    # 最大列往前2列，分别为进程平均CPU信息 [PS_NAME, %CPU]
    # 前两行是表头信息，进程数据信息从第三行开始
    row = 3
    col = ws_ps_mean.max_column - 1
    # 返回前五个进程信息[PS_NAME, %CPU]
    ps_cpu_mean_data_list = []
    for i in range(0, 5):
        ps_cpu_mean_data_list.append([ws_ps_mean.cell(row, col).value,
                                      str(ws_ps_mean.cell(row, col + 1).value)[0:6] + "%"])
        row += 1
    return ps_cpu_mean_data_list


def get_host_cpu_data():
    nmon_ws_sys_summ = nmon_workbook["SYS_SUMM"]
    for row in range(1, nmon_ws_sys_summ.max_row + 1):
        for col in range(1, nmon_ws_sys_summ.max_column + 1):
            if nmon_ws_sys_summ.cell(row, col).value == "Avg":
                # ["整机CPU", "整机usr", "整机sys"]
                return [str(100 - float(nmon_ws_sys_summ.cell(row, col + 4).value))[0:6] + "%",
                        str(float(nmon_ws_sys_summ.cell(row, col + 1).value))[0:6] + "%",
                        str(float(nmon_ws_sys_summ.cell(row, col + 2).value))[0:6] + "%"]


def fill_cpu_data(workbook, col_start):
    # 后续还会从get_top_mean_list中获取"mem_used数据"
    # global top_mean_list
    # 获取["整机CPU", "整机usr", "整机sys"]
    cpu_data = get_host_cpu_data()
    # # 获取"单云手机CPU(2Cores)", "单云手机usr", "单云手机sys"
    # top_mean_list = get_top_mean_list(workbook)
    # cpu_data.extend([top_mean_list[3], top_mean_list[1], top_mean_list[2]])
    # # 剩余5个子项，在sheet="PS"中获取 ["PS1", "PS2", "PS3", "PS4", "PS5"]
    # ps_cpu_mean_list = get_ps_info(workbook)
    # if not ps_cpu_mean_list:
    #     print("ERROR! No ps data!")
    #     return

    # # 将ps_name 写入替换列表命中的["PS1", "PS2", "PS3", "PS4", "PS5"]
    # for i in range(len(ps_cpu_mean_list)):
    #     worksheet.cell(2, i + 7, ps_cpu_mean_list[i][0])
    #     cpu_data.append(ps_cpu_mean_list[i][1])
    write_to_key_sheet(cpu_data, col_start)


def fill_cache_miss_data(workbook, col_start):
    sheet_name = "CACHE"
    if check_sheet_exist(workbook, sheet_name) < 0:
        return

    ws_cache = workbook[sheet_name]
    # ["L1-dcache-load-misses", "L1-icache-load-misses", "dTLB-load-misses", "iTLB-load-misses"] 在5-8列
    count = 0
    cache_data_sum_list = [0, 0, 0, 0]
    for row in range(2, ws_cache.max_row + 1):
        for col in range(5, 9):
            cache_data_sum_list[col - 5] += float(ws_cache.cell(row, col).value)
        count += 1
    if count == 0:
        print("ERROR: no cache miss  data!")
        return
    cache_miss_mean_list = [str(data / count)[0:6] + "%" for data in cache_data_sum_list]
    write_to_key_sheet(cache_miss_mean_list, col_start)


# 根据type获取type所在列
def get_col_num(sheet, type):
    # type在第一行
    for col in range(1, sheet.max_column + 1):
        if sheet.cell(1, col).value == type:
            return col
    return -1


def get_host_mem():
    nmon_ws_mem = nmon_workbook["MEM"]
    # 整机内存百分比计算：（memtotal - memfree - cached - buffers）/ memtotal
    mem_data_type = ["memtotal", "memfree", "cached", "buffers"]
    mem_data_col = [0, 0, 0, 0]
    for i in range(len(mem_data_type)):
        mem_data_col[i] = get_col_num(nmon_ws_mem, mem_data_type[i])
        if mem_data_col[i] == -1:
            print("ERROR: get MEM data failed!")
            return

    # mem_data_sum列表存储"memtotal" "memfree" "cached" "buffers"数据和
    mem_data_sum = [0, 0, 0, 0]

    if nmon_ws_mem.max_row <= 1:
        print("ERROR: no MEM data!")
        return
    # 数据从第2列开始，第一列为时间信息
    for row in range(2, nmon_ws_mem.max_row + 1):
        i = 0
        for col in mem_data_col:
            if not nmon_ws_mem.cell(row, col).value:
                break
            mem_data_sum[i] += float(nmon_ws_mem.cell(row, col).value)
            i += 1
    # mem_data_mean列表存储"memtotal" "memfree" "cached" "buffers"数据平均值
    mem_data_mean = [data_sum / (nmon_ws_mem.max_row - 1) for data_sum in mem_data_sum]

    return str((mem_data_mean[0] - mem_data_mean[1] - mem_data_mean[2] - mem_data_mean[3]) * 100 / mem_data_mean[0])[0:6] + "%"


def get_io_data(workbook):
    sheet_name = "CACHE"
    if check_sheet_exist(workbook, sheet_name) < 0:
        return

    ws_cache = workbook[sheet_name]
    # mem_access,mem_access_rd,mem_access_wr在CACHE的2-4列
    count = 0
    io_data_sum_list = [0, 0, 0]
    for row in range(2, ws_cache.max_row + 1):
        for col in range(2, 5):
            # 单位从k转化为M,需要除以1000000
            if ws_cache.cell(row, col).value == 0:
                io_data_sum_list[col - 2] = 0
            else:
                io_data_sum_list[col - 2] += float(ws_cache.cell(row, col).value) / 1000000
        count += 1
    if count == 0:
        print("ERROR! No cache data!")
        return
    io_mean_list = [data / count for data in io_data_sum_list]
    return io_mean_list


def fill_mem_data(workbook, col_start):
    # ["整机内存", "单云手机内存(6GB)", "总IOMbps", "读Mbps", "写Mbps"]
    # 获取整机内存 和 单云手机内存(6GB)数据
    mem_data_list = [get_host_mem(), 0, 0, 0, 0]
    # "总IOMbps", "读Mbps", "写Mbps"
    # io_data_list = get_io_data(workbook)
    # if not io_data_list:
    #     print("ERROR! No io data!")
    #     return
    # mem_data_list.extend(io_data_list)
    write_to_key_sheet(mem_data_list, col_start)


def fill_cpu_delay_data(workbook, col_start):
    sheet_name = "CPUDELAY"
    if check_sheet_exist(workbook, sheet_name) < 0:
        return

    ws_cpu_delay = workbook[sheet_name]
    cpu_dalay_data_list = []
    # CPUDELAY 的第二行1-4列
    for col in range(1, 9):
        cpu_dalay_data_list.append(ws_cpu_delay.cell(2, col).value)
    write_to_key_sheet(cpu_dalay_data_list, col_start)


def fill_gpu_data(workbook, col_start):
    sheet_name = "GPU"
    if check_sheet_exist(workbook, sheet_name) < 0:
        return

    ws_gpu = workbook[sheet_name]
    gpu_data_sum_list = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    count = 0
    for row in range(3, ws_gpu.max_row + 1):
        for col in range(2, 22):
            if ws_gpu.cell(row, col).value != None:
                gpu_data_sum_list[col - 2] += float(ws_gpu.cell(row, col).value)
        count += 1
    if count == 0:
        print("ERROR: no gpu data!")
        return
    gpu_data_mean_list = [data / count for data in gpu_data_sum_list]
    write_mean_data_to_sheet(gpu_data_mean_list, ws_gpu, col_offset=2)  # 从第二列开始写
    for i in range(len(gpu_data_mean_list)):
        if i in [0, 1, 2, 5, 6, 7, 10, 11, 12, 15, 16, 17]:
            gpu_data_mean_list[i] = str(gpu_data_mean_list[i])[0:6] + "%"
    write_to_key_sheet(gpu_data_mean_list, col_start)


def fill_net_io_data(col_start):
    nmon_ws_net = nmon_workbook["NET"]
    net_io_data_sum_list = [0, 0]
    count = 0
    # 网络IO读 和 网络IO写在最后两列
    col = nmon_ws_net.max_column - 1
    for row in range(2, nmon_ws_net.max_row + 1):
        if not nmon_ws_net.cell(row, col).value:
            break
        # 网络IO读
        net_io_data_sum_list[0] += float(nmon_ws_net.cell(row, col).value)
        # 网络IO写
        net_io_data_sum_list[1] -= float(nmon_ws_net.cell(row, col + 1).value)
        count += 1
    if count == 0:
        print("ERROR: no net io data!")
    net_io_data_mean_list = [data / count for data in net_io_data_sum_list]
    write_to_key_sheet(net_io_data_mean_list, col_start)


def fill_disk_io_data(col_start):
    nmon_ws_disk_summ = nmon_workbook["DISK_SUMM"]
    # 磁盘IO 磁盘读 和 网络写在"Avg."所在行 [Avg.  Disk Read KB/s	Disk Write KB/s	IO/sec]
    disk_data_list = [0, 0, 0]
    for row in range(2, nmon_ws_disk_summ.max_row + 1):
        if nmon_ws_disk_summ.cell(row, 1).value == "Avg.":
            disk_data_list[0] = nmon_ws_disk_summ.cell(row, 4).value
            disk_data_list[1] = nmon_ws_disk_summ.cell(row, 2).value
            disk_data_list[2] = nmon_ws_disk_summ.cell(row, 3).value
            break
    write_to_key_sheet(disk_data_list, col_start)


def fill_disk_and_netint_io(col_start):
    nmon_ws_disk_read = nmon_workbook["DISKREAD"]
    nmon_ws_disk_write = nmon_workbook["DISKWRITE"]
    disk_data_list = [0, 0, 0, 0]
    netint_list = ["nvme2c2n1", "nvme3c3n1", "nvme4c4n1", "nvme5c5n1", "nvme6c6n1", "nvme7c7n1", "nvme8c8n1",
                   "nvme9c9n1"]
    # 获取磁盘数据盘和netint 读数据
    for row in range(2, nmon_ws_disk_read.max_row + 1):
        if nmon_ws_disk_read.cell(row, 1).value == "Avg.":
            for col in range(2, nmon_ws_disk_read.max_column + 1):
                if nmon_ws_disk_read.cell(1, col).value == "nvme0n1" or nmon_ws_disk_read.cell(1,
                                                                                               col).value == "nvme10n1":
                    disk_data_list[0] += float(nmon_ws_disk_read.cell(row, col).value)
                elif nmon_ws_disk_read.cell(1, col).value in netint_list:
                    disk_data_list[2] += float(nmon_ws_disk_read.cell(row, col).value)
            break
    # 获取磁盘数据盘和netint 写数据
    for row in range(2, nmon_ws_disk_write.max_row + 1):
        if nmon_ws_disk_write.cell(row, 1).value == "Avg.":
            for col in range(2, nmon_ws_disk_write.max_column + 1):
                if nmon_ws_disk_write.cell(1, col).value == "nvme4n1" or nmon_ws_disk_write.cell(1,
                                                                                                 col).value == "nvme5n1":
                    disk_data_list[1] += float(nmon_ws_disk_write.cell(row, col).value)
                elif nmon_ws_disk_write.cell(1, col).value in netint_list:
                    disk_data_list[3] += float(nmon_ws_disk_write.cell(row, col).value)
            break
    write_to_key_sheet(disk_data_list, col_start)


def get_nmon_path(path):
    dirs = os.listdir(path)
    for dir in dirs:
        if re.findall("nmon", dir):
            for file in os.listdir(os.path.join(path, dir)):
                if re.findall("~$", file):
                    continue
                if re.findall("nmon.xlsx", file):
                    return os.path.join(os.path.join(path, dir), file)
    return None


def fill_netint_data(workbook, col_start=44):
    sheet_name = "NETINT"
    if check_sheet_exist(workbook, sheet_name) < 0:
        return

    ws_netint = workbook[sheet_name]
    # "Avg."数据在最后一行
    netint_sum_data = [0, 0, 0, 0]
    netint_mean_data = [0, 0, 0, 0]

    # 各编码卡["负载(LOAD)", "模型负载(MODEL_LOAD)", "内存(MEM)", "编码实例数(INST)"]的平均值在最后一行
    # 前三项求平均， 最后一项加和
    # 数据从第二列开始, 第一列为时间信息
    for col in range(2, ws_netint.max_column + 1):
        netint_sum_data[(col + len(netint_sum_data) + 2) % len(netint_sum_data)] += ws_netint.cell(ws_netint.max_row, col).value

    for i in range(len(netint_sum_data)):
        if i == len(netint_sum_data) - 1:
            netint_mean_data[i] = netint_sum_data[i]
        else:
            netint_card_number = (ws_netint.max_column - 1) / len(netint_sum_data)
            netint_mean_data[i] = str(netint_sum_data[i] / netint_card_number * 100) + "%"
    write_to_key_sheet(netint_mean_data, col_start)


def write(workbook, path):
    # 获取*nmon.xlsx路径
    nmon_path = get_nmon_path(path)
    print("nmon excel path: ", nmon_path, " -----> Data Processing")
    if not nmon_path:
        print("ERROR: There is no related *nmon.xlsx file! Skipped handling!")
        return

    global worksheet, col_names, col_sub_names, nmon_workbook
    # 创建sheet对象
    worksheet = workbook.create_sheet()
    worksheet.title = "云手机负载模型数据"

    # 写表头
    # [CPU(12列), Cache Miss(4列), 内存(5列), 访问时延(8列), GPU：renderD128(5列)， GPU：renderD129(5列), GPU：renderD130(5列)， GPU：renderD31(5列), 网络IO(2列), 磁盘IO(总)(3列), 磁盘IO(数据盘)(2列), 磁盘IO(NETINT编码卡)(2列), NETINT编码卡]
    col_names = ["CPU", "Cache Miss", "内存", "访存时延", "GPU：renderD128", "GPU：renderD129", "GPU：renderD130", "GPU：renderD131", "网络IO", "磁盘IO(总)", "磁盘IO(数据盘)",
                 "磁盘IO(NETINT编码卡)", "NETINT编码卡"]
    col_sub_names = [["整机CPU", "整机usr", "整机sys", "单云手机CPU(2Cores)", "单云手机usr", "单云手机sys",
                      "PS1", "PS2", "PS3", "PS4", "PS5"],
                     ["L1-dcache-load-misses", "L1-icache-load-misses", "dTLB-load-misses", "iTLB-load-misses"],
                     ["整机内存", "单云手机内存(6GB)", "总IOMbps", "读Mbps", "写Mbps"],
                     ["NUMA0->NUMA0(ns)", "NUMA0->NUMA1(ns)", "NUMA0->NUMA2(ns)", "NUMA0->NUMA3(ns)",
                      "NUMA0->NUMA4(ns)", "NUMA0->NUMA5(ns)", "NUMA0->NUMA6(ns)", "NUMA0->NUMA7(ns)"],
                     ["gpu", "vram", "gtt", "mclk(1GHZ)", "sclk(2.555GHZ)"],
                     ["gpu", "vram", "gtt", "mclk(1GHZ)", "sclk(2.555GHZ)"],
                     ["gpu", "vram", "gtt", "mclk(1GHZ)", "sclk(2.555GHZ)"],
                     ["gpu", "vram", "gtt", "mclk(1GHZ)", "sclk(2.555GHZ)"],
                     ["网络读(KB/s)", "网络写(KB/s)"],
                     ["磁盘IO(IO/s)", "磁盘读(KB/s)", "磁盘写(KB/s)"],
                     ["磁盘读(KB/s)", "磁盘写(KB/s)"],
                     ["磁盘读(KB/s)", "磁盘写(KB/s)"],
                     ["负载(LOAD)", "模型负载(MODEL_LOAD)", "内存(MEM)", "编码实例数(INST)"]
                     ]
    write_col_names()
    print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time())), "start to load", nmon_path, "!")
    nmon_workbook = load_workbook(nmon_path, data_only=True)
    print(time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(time.time())), nmon_path, "loaded")
    fill_cpu_data(workbook, col_start=1)  # 从第一列开始写入
    # fill_cache_miss_data(workbook, col_start=12)
    fill_mem_data(workbook, col_start=16)
    # fill_cpu_delay_data(workbook, col_start=21)
    fill_gpu_data(workbook, col_start=29)
    fill_net_io_data(col_start=49)
    fill_disk_io_data(col_start=51)
    fill_disk_and_netint_io(col_start=54)
    fill_netint_data(workbook, col_start=58)
