#!/usr/bin/python
# -*- coding: UTF-8 -*-

import openpyxl
from openpyxl.chart import LineChart


class BaseChartObj:
    """ Base class for excel chart """
    def __init__(self, title='', x_title='', y_title='', height=8, width=10):
        self.title = title
        self.x_title = x_title
        self.y_title = y_title
        self.height = height
        self.width = width


class LineChartObj(BaseChartObj):
    """ Line Chart """
    def set_up_chart(self, data, category):
        chart = LineChart()

        chart.title = self.title
        chart.x_axis.title = self.x_title
        chart.y_axis.title = self.y_title
        chart.height = self.height
        chart.width = self.width
        chart.add_data(data, titles_from_data=True)
        if category:
            chart.set_categories(category)
        return chart


def plot_gpu_data(sheet, data, name, category=None):
    # 创建曲线图
    obj = LineChartObj(name, 'Time', 'GPU usage', 9, 25)
    chart = obj.set_up_chart(data, category)

    # 添加图标到不同位置
    if name == 'renderD128':
        sheet.add_chart(chart, 'M1')
    elif name == 'renderD129':
        sheet.add_chart(chart, 'M22')


def plot_load_misses(sheet, data, category=None):
    obj = LineChartObj('Load Misses Status', 'Time', 'Misses percentage', 9, 25)
    chart = obj.set_up_chart(data, category)

    sheet.add_chart(chart, 'K1')


def plot_mem_access(sheet, data, category=None):
    obj = LineChartObj(title='Mem Access Status', x_title='Time', height=9, width=25)
    chart = obj.set_up_chart(data, category)

    sheet.add_chart(chart, 'K22')
