import csv
import datetime
import matplotlib.pyplot as plt
import os
import sys


def todouble(s):
    ans = 0
    if len(s.split(".")) == 1:
        for i in range(len(s)):
            ans = ans * 10 + int(s[i])
    else:
        s1, s2 = s.split(".")[0], s.split(".")[1]
        for i in range(len(s1)):
            ans = ans * 10 + int(s1[i])
        base = 0.1
        for i in range(len(s2)):
            ans += base * int(s2[i])
            base /= 10
    return ans


def parse_service(dirname, rootdir):
    ls = os.listdir(dirname)
    n = len(ls) + 1
    hfg = [[] for _ in range(n)]
    efg = [[] for _ in range(n)]
    hfps_x, hfps_y = [[] for _ in range(n)], [[] for _ in range(n)]
    efps_x, efps_y = [[] for _ in range(n)], [[] for _ in range(n)]
    ebps_x, ebps_y = [[] for _ in range(n)], [[] for _ in range(n)]
    for i in range(1, n):
        filename = os.path.join(dirname, "logcat_android_" + str(i) + ".log")
        with open(filename, encoding="utf-8") as file:
            line = file.readline()
            while line:
                data = line.strip()
                t = data[6:14]
                if "PERF-HWC-FRAMEGAP" in data:
                    tmp = data[data.find("[") + 1 : data.find("]")].split(",")
                    for j in range(len(tmp)):
                        hfg[i].append(int(tmp[j]))
                if "PERF-ENC-FRAMEGAP" in data:
                    tmp = data[data.find("[") + 1 : data.find("]")].split(",")
                    for j in range(len(tmp)):
                        efg[i].append(int(tmp[j]))
                if "PERF-HWC-FPS" in data:
                    hfps_x[i].append(datetime.datetime.strptime(t, "%H:%M:%S"))
                    hfps_y[i].append(todouble(data.split()[-1]))
                if "PERF-ENC-FPS" in data:
                    efps_x[i].append(datetime.datetime.strptime(t, "%H:%M:%S"))
                    efps_y[i].append(todouble(data.split()[-1]))
                if "PERF-ENC-BPS" in data:
                    ebps_x[i].append(datetime.datetime.strptime(t, "%H:%M:%S"))
                    ebps_y[i].append(int(data.split()[-1]))
                line = file.readline()
    plt.ylabel("frame gap")
    plt.ylim(0, 400)
    plt.title("The framegap of hardware composer in cloud side")
    for i in range(1, n):
        plt.plot(hfg[i])
    plt.savefig(os.path.join(rootdir, "PERF-HWC-FRAMEGAP.png"))
    plt.show()
    if os.path.exists(os.path.join(rootdir, "PERF-HWC-FRAMEGAP.csv")):
        os.remove(os.path.join(rootdir, "PERF-HWC-FRAMEGAP.csv"))
    table = open(os.path.join(rootdir, "PERF-HWC-FRAMEGAP.csv"), "a+", encoding="utf-8", newline="")
    csv_writer = csv.writer(table)
    csv_writer.writerow([f"Container", "Maximum", "Minimun", "Average"])
    for i in range(1, n):
        csv_writer.writerow([i, max(hfg[i]), min(hfg[i]), sum(hfg[i]) / len(hfg[i])])
    table.close()
    plt.ylabel("frame gap")
    plt.ylim(0, 400)
    plt.title("The framegap of encoder in cloud side")
    for i in range(1, n):
        plt.plot(efg[i])
    plt.savefig(os.path.join(rootdir, "PERF-ENC-FRAMEGAP.png"))
    plt.show()
    if os.path.exists(os.path.join(rootdir, "PERF-ENC-FRAMEGAP.csv")):
        os.remove(os.path.join(rootdir, "PERF-ENC-FRAMEGAP.csv"))
    table = open(os.path.join(rootdir, "PERF-ENC-FRAMEGAP.csv"), "a+", encoding="utf-8", newline="")
    csv_writer = csv.writer(table)
    csv_writer.writerow([f"Container", "Maximum", "Minimun", "Average"])
    for i in range(1, n):
        csv_writer.writerow([i, max(efg[i]), min(efg[i]), sum(efg[i]) / len(efg[i])])
    table.close()
    plt.xlabel("time")
    plt.ylabel("frame per second")
    plt.ylim(0, 35)
    plt.title("The frame rate of hardware composer in cloud side")
    for i in range(1, n):
        plt.plot(hfps_x[i], hfps_y[i])
    plt.savefig(os.path.join(rootdir, "PERF-HWC-FPS.png"))
    plt.show()
    if os.path.exists(os.path.join(rootdir, "PERF-HWC-FPS.csv")):
        os.remove(os.path.join(rootdir, "PERF-HWC-FPS.csv"))
    table = open(os.path.join(rootdir, "PERF-HWC-FPS.csv"), "a+", encoding="utf-8", newline="")
    csv_writer = csv.writer(table)
    csv_writer.writerow([f"Container", "Maximum", "Minimun", "Average"])
    for i in range(1, n):
        csv_writer.writerow([i, max(hfps_y[i]), min(hfps_y[i]), sum(hfps_y[i]) / len(hfps_y[i])])
    table.close()
    plt.xlabel("time")
    plt.ylabel("frame per second")
    plt.ylim(0, 35)
    plt.title("The frame rate of encoder in cloud side")
    for i in range(1, n):
        plt.plot(efps_x[i], efps_y[i])
    plt.savefig(os.path.join(rootdir, "PERF-ENC-FPS.png"))
    plt.show()
    if os.path.exists(os.path.join(rootdir, "PERF-ENC-FPS.csv")):
        os.remove(os.path.join(rootdir, "PERF-ENC-FPS.csv"))
    table = open(os.path.join(rootdir, "PERF-ENC-FPS.csv"), "a+", encoding="utf-8", newline="")
    csv_writer = csv.writer(table)
    csv_writer.writerow([f"Container", "Maximum", "Minimun", "Average"])
    for i in range(1, n):
        csv_writer.writerow([i, max(efps_y[i]), min(efps_y[i]), sum(efps_y[i]) / len(efps_y[i])])
    table.close()
    plt.xlabel("time")
    plt.ylabel("bit per second")
    plt.ylim(0, 1000000)
    plt.title("The bit rate of encoder in cloud side")
    for i in range(1, n):
        plt.plot(ebps_x[i], ebps_y[i])
    plt.savefig(os.path.join(rootdir, "PERF-ENC-BPS.png"))
    plt.show()
    if os.path.exists(os.path.join(rootdir, "PERF-ENC-BPS.csv")):
        os.remove(os.path.join(rootdir, "PERF-ENC-BPS.csv"))
    table = open(os.path.join(rootdir, "PERF-ENC-BPS.csv"), "a+", encoding="utf-8", newline="")
    csv_writer = csv.writer(table)
    csv_writer.writerow([f"Container", "Maximum", "Minimun", "Average"])
    for i in range(1, n):
        csv_writer.writerow([i, max(ebps_y[i]), min(ebps_y[i]), sum(ebps_y[i]) / len(ebps_y[i])])
    table.close()


def parse_client(dirname, rootdir):
    fps_x, fps_y = [], []
    n = 0
    log_dir = []
    for parent, dirnames, filenames in os.walk(dirname):
        if len(filenames) == 0:
            continue
        log_dir.append(parent)
        for filename in filenames:
            if filename[len(filename) - 8 : len(filename) - 4].isdigit():
                n += 1
    for j in range(n + 1):
        fps_x.append([])
        fps_y.append([])
    for dirname in log_dir:
        for filename in os.listdir(dirname):
            if filename[len(filename) - 8 : len(filename) - 4].isdigit():
                # docker id
                i = int(filename[len(filename) - 8 : len(filename) - 4]) - 8000
                with open(os.path.join(dirname, filename), encoding="utf-8") as file:
                    line = file.readline()
                    while line:
                        t = line.strip().split()[2]
                        data = line.strip().split()[-3]
                        fps_x[i].append(datetime.datetime.strptime(t, "%H:%M:%S"))
                        fps_y[i].append(int(data[len(data) - 2 : len(data)]))
                        line = file.readline()
    if os.path.exists(os.path.join(rootdir, "Receiving_FPS.csv")):
        os.remove(os.path.join(rootdir, "Receiving_FPS.csv"))
    table = open(os.path.join(rootdir, "Receiving_FPS.csv"), "a+", encoding="utf-8", newline="")
    csv_writer = csv.writer(table)
    csv_writer.writerow([f"Container", "Maximum FPS", "Minimum FPS", "Average FPS", "Propotion of FPS<27"])
    for i in range(1, n + 1):
        tmp = 0
        for j in range(len(fps_y[i])):
            if fps_y[i][j] < 27:
                tmp += 1
        csv_writer.writerow([i, max(fps_y[i]), min(fps_y[i]), sum(fps_y[i]) / len(fps_y[i]), tmp / len(fps_y[i])])
    table.close()
    plt.xlabel("time")
    plt.ylabel("frame per second")
    plt.ylim(0, 35)
    plt.title("The receiving frame rate in client side")
    for i in range(1, n + 1):
        plt.plot(fps_x[i], fps_y[i])
    plt.savefig(os.path.join(rootdir, "Receiving_FPS.png"))
    plt.show()


def parse_log(filename, rootdir):
    lag_x, lag_y = [], []
    dl_x, dl_y = [], []
    with open(filename, encoding="utf-8") as file:
        line = file.readline()
        while line:
            data = line.strip()
            t = data[6:18]
            if "LAG" in data and "FLAG" not in data:
                tmp = data.split()[-1]
                if int(tmp[0 : len(tmp) - 2]) >= 0:
                    lag_x.append(datetime.datetime.strptime(t, "%H:%M:%S.%f"))
                    lag_y.append(int(tmp[0 : len(tmp) - 2]))
            if "decode latency" in data:
                dl_x.append(datetime.datetime.strptime(t, "%H:%M:%S.%f"))
                dl_y.append(int(data.split()[-2]))
            line = file.readline()
    plt.xlabel("time")
    plt.ylabel("ms")
    plt.ylim(0, 1000)
    plt.title("LAG")
    plt.plot(lag_x, lag_y)
    plt.savefig(os.path.join(rootdir, "LAG.png"))
    plt.show()
    if os.path.exists(os.path.join(rootdir, "LAG.csv")):
        os.remove(os.path.join(rootdir, "LAG.csv"))
    table = open(os.path.join(rootdir, "LAG.csv"), "a+", encoding="utf-8", newline="")
    csv_writer = csv.writer(table)
    csv_writer.writerow([f"Maximum", "Minimun", "Average"])
    csv_writer.writerow([max(lag_y), min(lag_y), sum(lag_y) / len(lag_y)])
    table.close()
    plt.xlabel("time")
    plt.ylabel("ms")
    plt.ylim(0, 100)
    plt.title("decode latency")
    plt.plot(dl_x, dl_y)
    plt.savefig(os.path.join(rootdir, "decode_latency.png"))
    plt.show()
    if os.path.exists(os.path.join(rootdir, "decode_latency.csv")):
        os.remove(os.path.join(rootdir, "decode_latency.csv"))
    table = open(os.path.join(rootdir, "decode_latency.csv"), "a+", encoding="utf-8", newline="")
    csv_writer = csv.writer(table)
    csv_writer.writerow([f"Maximum", "Minimun", "Average"])
    csv_writer.writerow([max(dl_y), min(dl_y), sum(dl_y) / len(dl_y)])
    table.close()


if __name__ == "__main__":
    if len(sys.argv) == 1:
        rootdir = "."
    else:
        rootdir = sys.argv[1]
    if not os.path.exists(os.path.join(rootdir, "output")):
        os.mkdir(os.path.join(rootdir, "output"))
    for parent, dirnames, filenames in os.walk(rootdir):
        for dirname in dirnames:
            if "logcat" in dirname:
                parse_service(os.path.join(parent, dirname), os.path.join(rootdir, "output"))
            if dirname == "logs":
                parse_client(os.path.join(parent, dirname), os.path.join(rootdir, "output"))
        for filename in filenames:
            if filename == "client.log":
                parse_log(os.path.join(parent, filename), os.path.join(rootdir, "output"))
