#!/usr/bin/python
# -*- coding: UTF-8 -*-

import re
import sys
import os
import time

import get_render_data
import get_cache_data
import get_top_data
import get_mem_read_data
import get_mon_data
import write_key_data

from openpyxl import Workbook


if __name__ == '__main__':
    # 无额外参数使用默认log地址和保存文件名
    log_path = r'log' if len(sys.argv) < 2 else sys.argv[1]
    if not os.path.exists(log_path):
        print('Invalid log path, exiting')
        sys.exit()
    result = r'result.xlsx' if len(sys.argv) != 3 else sys.argv[2]
    if not result.endswith('.xlsx'):
        result = sys.argv[2] + '.xlsx'

    # Timer
    start_time = time.time()

    if os.path.isdir(log_path):
        print("# start to process data")
        print("-----------------------------------------------------------------------------------")
        # 创建excel对象
        workbook = Workbook()

        dirs = os.listdir(log_path)
        for dir in dirs:
            if re.findall("gpu", dir):
                # 处理gpu数据
                get_render_data.write(os.path.join(log_path, dir), workbook)
                print("gpu log path: ", dir, "-----> Data process completed.")
            elif re.findall("cache_mem", dir):
                # 处理cache数据
                get_cache_data.write(os.path.join(log_path, dir), workbook)
                print("cache_mem log path: ", dir, "-----> Data process completed.")
            # elif re.findall("top", dir):
            #     # 处理memory数据
            #     get_top_data.write_mem_and_cpu(os.path.join(log_path, dir), workbook)
            #     get_top_data.write_ps(os.path.join(log_path, dir), workbook)
            #     print("top log path: ", dir, "-----> Data process completed.")
            # elif re.findall("mem_rd", dir):
            #     # 处理mem_rd数据
            #     get_mem_read_data.write(os.path.join(log_path, dir), workbook)
            #     print("mem_rd log path: ", dir, "-----> Data process completed.")
            elif re.findall("rsrc_mon", dir):
                # 处理mon数据
                get_mon_data.write(os.path.join(log_path, dir), workbook)
                print("mon log path: ", dir, "-----> Data process completed.")

        # 提取主要数据，写入excel
        write_key_data.write(workbook, log_path)

        # 删除默认的Sheet
        worksheet = workbook["Sheet"]
        workbook.remove(worksheet)
        # 保存
        workbook.save(result)
        end_time = time.time()
        print("-----------------------------------------------------------------------------------")
        print(f"The processed data is stored in the {result}, took {end_time - start_time} seconds")
        print("DONE! ^V^")

    else:
        print("ERROR! There is no path of log! Copy the log file to the current directory first!")
