#!/usr/bin/python
# -*- coding: UTF-8 -*-

import re
import os
import pandas as pd
from openpyxl.chart import Reference

from plotting_module import plot_gpu_data


def get_time_from_data(data):
    times = []
    for i in range(len(data)):
        line = data.loc[i, 0]
        time = line.split(" ")[3]
        times.append(time)
    return times


def get_main_data_from_data(data, type):
    main_data = []
    for i in range(len(data)):
        line = data.loc[i, 0]
        strs = line.split(",")
        for s in strs:
            if re.findall(type, s):
                if type == "sclk" or type == "mclk":  # 取数值，去掉单位
                    main_data.append(s.split(" ")[3].strip("ghz"))
                else:
                    main_data.append(float(s.split(" ")[2].strip("%")))
    return main_data


def write_to_excel_by_row_number(data, row, offset):
    for i, element in enumerate(data):
        worksheet.cell(row, i + offset, element)


def write_to_excel_by_column_number(data, col, offset):
    for i, element in enumerate(data):
        worksheet.cell(i + offset, col, element)


def write(dir, workbook):
    # 创建sheet对象
    global worksheet
    worksheet = workbook.create_sheet("GPU", 0)
    # 合并单元格并写入["renderD128", "renderD129"] openpyxl行列从(1, 1)开始
    worksheet.merge_cells(start_row=1, start_column=2, end_row=1, end_column=6)
    worksheet.cell(row=1, column=2, value="renderD128")
    worksheet.merge_cells(start_row=1, start_column=7, end_row=1, end_column=11)
    worksheet.cell(row=1, column=7, value="renderD129")
    worksheet.merge_cells(start_row=1, start_column=12, end_row=1, end_column=16)
    worksheet.cell(row=1, column=12, value="renderD130")
    worksheet.merge_cells(start_row=1, start_column=17, end_row=1, end_column=21)
    worksheet.cell(row=1, column=17, value="renderD131")
    # 定义列名
    col_names = ["time", "gpu(%)", "vram(%)", "gtt(%)", "mclk(1GHZ)","sclk(2.555GHZ)", "gpu(%)", "vram(%)", "gtt(%)",
                 "mclk(1GHZ)", "sclk(2.555GHZ)", "gpu(%)", "vram(%)", "gtt(%)", "mclk(1GHZ)","sclk(2.555GHZ)", "gpu(%)", "vram(%)", "gtt(%)",
                 "mclk(1GHZ)", "sclk(2.555GHZ)"]
    # 在第二行从第一列开始写入列名
    write_to_excel_by_row_number(col_names, 2, 1)
    # 需要获取的数据类型
    types = ["gpu", "vram", "gtt", "mclk", "sclk"]
    row_offset = 3  # 行偏移量为3(列名占用)， column从1算起
    # 写入数据
    files = os.listdir(dir)
    for file in files:
        if re.findall("renderD128", file):
            data = pd.read_table(os.path.join(dir, file), header=None)
            data_len = len(data)
            # 先写时间一列
            times = get_time_from_data(data)
            # 将times写入第A(1)列，行偏移量为3(列名占用)
            write_to_excel_by_column_number(times, 1, row_offset)
            # 获取["gpu", "sclk", "vram", "gtt", "mclk"]数据
            col_start = 2  # 从第B(2)列开始写入数据
            for i, type in enumerate(types):
                write_to_excel_by_column_number(get_main_data_from_data(data, type), i + col_start, row_offset)
            # 获取renderD128的GPU数据并执行绘图操作
            gpu_data = Reference(worksheet, min_col= col_start, min_row= row_offset - 1,
                                            max_col= col_start, max_row= row_offset + data_len - 1)
            time_category = Reference(worksheet, min_col= 1, min_row= row_offset - 1,
                                                 max_col= 1, max_row= row_offset + data_len - 1)
            plot_gpu_data(worksheet, gpu_data, "renderD128", time_category)
        elif re.findall("renderD129", file):
            data = pd.read_table(os.path.join(dir, file), header=None)
            data_len = len(data)
            # 从第G(7)列开始写入数据
            col_start = 7
            for i, type in enumerate(types):
                write_to_excel_by_column_number(get_main_data_from_data(data, type), i + col_start, row_offset)
            # 获取renderD129的GPU数据并执行绘图操作
            gpu_data = Reference(worksheet, min_col= col_start, min_row= row_offset - 1,
                                            max_col= col_start, max_row= row_offset + data_len - 1)
            time_category = Reference(worksheet, min_col= 1, min_row= row_offset - 1,
                                                 max_col= 1, max_row= row_offset + data_len - 1)
            plot_gpu_data(worksheet, gpu_data, "renderD129", time_category)
        elif re.findall("renderD130", file):
            data = pd.read_table(os.path.join(dir, file), header=None)
            data_len = len(data)
            # 从第L(12)列开始写入数据
            col_start = 12
            for i, type in enumerate(types):
                write_to_excel_by_column_number(get_main_data_from_data(data, type), i + col_start, row_offset)
            # 获取renderD130的GPU数据并执行绘图操作
            gpu_data = Reference(worksheet, min_col= col_start, min_row= row_offset - 1,
                                            max_col= col_start, max_row= row_offset + data_len - 1)
            time_category = Reference(worksheet, min_col= 1, min_row= row_offset - 1,
                                                 max_col= 1, max_row= row_offset + data_len - 1)
            plot_gpu_data(worksheet, gpu_data, "renderD130", time_category)
        elif re.findall("renderD131", file):
            data = pd.read_table(os.path.join(dir, file), header=None)
            data_len = len(data)
            # 从第Q(17)列开始写入数据
            col_start = 17
            for i, type in enumerate(types):
                write_to_excel_by_column_number(get_main_data_from_data(data, type), i + col_start, row_offset)
            # 获取renderD131的GPU数据并执行绘图操作
            gpu_data = Reference(worksheet, min_col= col_start, min_row= row_offset - 1,
                                            max_col= col_start, max_row= row_offset + data_len - 1)
            time_category = Reference(worksheet, min_col= 1, min_row= row_offset - 1,
                                                 max_col= 1, max_row= row_offset + data_len - 1)
            plot_gpu_data(worksheet, gpu_data, "renderD131", time_category)
