#!/usr/bin/python
# -*- coding: UTF-8 -*-

import os


def get_data_dict(dir):
    data_dict = {}  # "/dev/nvme0" [LOAD, MODEL_LOAD, MEM, INST, 出现次数]
    time_list = []
    # 从txt中读取数据
    files = os.listdir(dir)
    for file in files:
        with open(os.path.join(dir, file), "r", encoding="utf-8") as fd:
            # 记录跳过的decoder数据行数
            line_count = 0
            for line in fd.readlines():
                if line_count >= 0:
                    line_count -= 1
                    continue
                line = list(filter(None, line.strip().split(" ")))
                # 获取时间
                if len(line) >= 6 and line[5] == 'up':
                    time_list.append(line[3])
                if len(line) >= 2 and line[1] == 'decoders:':
                    # 遇到decoders数据， 跳过下方n行decoders数据
                    line_count = int(line[2])
                    continue
                if line[0] == 'L':
                    # 整体偏移量增加 1
                    line = line[1:len(line)]
                if line[0].isdigit() == False:
                    continue
                if line[5] not in data_dict:
                    data_dict[line[5]] = []
                data_dict[line[5]].append(line[1:5])
    return data_dict, time_list


def write_data_to_this_sheet_by_row_and_col(sheet, row, col, data):
    # 处理时间列（第一列）
    if col == 1:
        sheet.cell(row, col, data)
    # 处理数据列
    else:
        # 前三项是百分数, 最后一项是int类型
        if (col - 1) % 4 == 0:
            sheet.cell(row, col, int(data))
        else:
            this_cell = sheet.cell(row, col)
            this_cell.number_format = '0.00%'
            sheet.cell(row, col, float(data) / 100)


def write_mean_data_to_this_sheet(sheet, mean_data, start_col):
    # 在最大行往后3行写入数据
    row = sheet.max_row + 3
    # 先写Avg.
    sheet.cell(row, start_col, "Avg.")
    # 往Avg.后一行写平均值
    row += 1
    for i, data in enumerate(mean_data):
        write_data_to_this_sheet_by_row_and_col(sheet, row, i + start_col, data)


def write(dir, workbook):
    # 创建sheet对象
    worksheet = workbook.create_sheet("NETINT")
    # 获取数据
    data_dict, time_list = get_data_dict(dir)
    # 获取列名
    col_names = list(data_dict.keys())
    col_sub_names = ["负载(LOAD)", "模型负载(MODEL_LOAD)", "内存(MEM)", "编码实例数(INST)"]
    # 从第二列开始， 第一列写入时间信息
    col = 2
    # [LOAD, MODEL_LOAD, MEM, INST] 共四个信息
    col_offset = 4
    # 从第三行开始写入数据信息，前两行是表头信息
    row_offset = 3
    # 存储平均值
    mean_data = []
    # 按key写入数据
    for col_name in col_names:
        # 第一行写入列名信息
        worksheet.merge_cells(start_row=1, start_column=col, end_row=1, end_column=col + col_offset - 1)
        worksheet.cell(1, col, col_name)
        data_list = data_dict[col_name]
        # 第二行第一列写入时间信息
        worksheet.cell(2, 1, "时间(TIME)")
        for i, sub_name in enumerate(col_sub_names):
            # 第二行写 [LOAD, MODEL_LOAD, MEM, INST]
            worksheet.cell(2, col + i, sub_name)
            # 从第三行开始写入["负载(LOAD)", "模型负载(MODEL_LOAD)", "内存(MEM)", "编码实例数(INST)"]数据信息
            # 求当前列之和
            this_col_sum = 0
            for row in range(row_offset, len(data_list) + row_offset):
                write_data_to_this_sheet_by_row_and_col(worksheet, row, col + i, data_list[row - row_offset][i])
                this_col_sum += float(data_list[row - row_offset][i])
            # 将当前列的平均值存到mean_data
            mean_data.append(this_col_sum / len(data_dict[col_name]))
        col += col_offset

    # 从第三行开始,在第一行写入时间数据
    for i, time in enumerate(time_list):
        write_data_to_this_sheet_by_row_and_col(worksheet, i + 3, 1, time)

    # 最后从第二列开始写入平均数据
    write_mean_data_to_this_sheet(worksheet, mean_data, 2)
