#!/usr/bin/python
# -*- coding: UTF-8 -*-

import os


def write(dir, workbook):
    # 创建sheet对象
    worksheet = workbook.create_sheet()
    worksheet.title = "CPUDELAY"

    # 列偏移量为1
    col_offset = 1
    # 写入列名
    numa_num = 4
    for i in range(numa_num):
        # 第一行写字段名
        worksheet.cell(1, i + col_offset, f'NUMA0->NUMA{i}(ms)')

    # 行偏移量为2 (第1行表头 + 行列计数从1开始)
    row_offset = 2

    files = os.listdir(dir)
    for file in files:
        with open(os.path.join(dir, file), 'r', encoding='utf-8') as f:
            lines = f.readlines()
            # 获取标识，numa_id为偏移量
            numa_id = int(lines[0].split(' ')[4])
            i = -1
            # 直接从尾部读起，长度不为2时则为最后一行有效数据
            while (len(lines[i].strip().split(' ')) != 2):
                i -= 1
            # 根据id偏移量写入对应单元格 若无数据则不写入
            worksheet.cell(row_offset, col_offset + numa_id, lines[i].strip().split(' ')[1])
