#!/usr/bin/python
# -*- coding: UTF-8 -*-

import os
import time
import pandas as pd
import openpyxl
from openpyxl.chart import Reference

from plotting_module import plot_load_misses
from plotting_module import plot_mem_access


def get_time(start_time, time_offset):
    if not start_time:
        return time_offset
    timestamp = time.mktime(time.strptime(start_time.strip())) + float(time_offset)
    return time.strftime("%H:%M:%S", time.localtime(timestamp))


def get_data_list(data, colnames):
    data_list = []
    sub_list = []

    time_offset = 0
    start_time = ""
    for i in range(len(data)):
        line = data.loc[i, 0]
        strs = line.split(" ")
        while "" in strs:
            strs.remove("")
        # 获取开始时间
        if strs[0] == '#':
            if len(strs) > 2 and strs[1] == "started":
                for i in range(3, len(strs)):
                    start_time += strs[i] + " "
            continue
        # 每个time对应"mem_access", "mem_access_rd", "mem_access_wr", "L1-dcache-load-misses", "L1-icache-load-misses",
        # "dTLB-load-misses", "iTLB-load-misses"
        # 开始读取新的一组数据
        if time_offset != strs[0]:
            # 将前一组数据信息保存好
            if time_offset != 0:
                data_list.append(sub_list)
            # 获取到起始行
            time_offset = strs[0]
            # 重置当前list
            sub_list = []
            sub_list.append(get_time(start_time, time_offset))

        if strs[2] in colnames:
            if strs[2] == "L1-dcache-load-misses" or strs[2] == "L1-icache-load-misses" or strs[2] == "dTLB-load-misses" or strs[2] == "iTLB-load-misses":
                # 处理鲲鹏服务器上没有mem_access_rd与mem_access_wr的情况，直接在相应位置置0处理
                if strs[2] == "L1-dcache-load-misses" and len(sub_list) < 3:
                    sub_list.append("0,0")  # mem_access_rd
                    sub_list.append("0,0")  # mem_access_wr
                sub_list.append(strs[4])
            else:
                sub_list.append(strs[1])
    data_list.append(sub_list)
    return data_list


def write(dir, workbook):
    # 创建sheet对象
    worksheet = workbook.create_sheet("CACHE", 1)
    # 匹配名
    match_names = ["time", "mem_access", "mem_access_rd", "mem_access_wr", "L1-dcache-load-misses",
                 "L1-icache-load-misses", "dTLB-load-misses", "iTLB-load-misses"]
    # 定义列名
    col_names = ["time", "mem_access", "mem_access_rd", "mem_access_wr", "L1-dcache-load-misses(%)",
                 "L1-icache-load-misses(%)", "dTLB-load-misses(%)", "iTLB-load-misses(%)"]

    # 写入列名
    for i, col_name in enumerate(col_names):
        worksheet.cell(1, i + 1, col_name)
    # 之后数据行偏移量为2
    row_offset = 2
    if len(os.listdir(dir)) == 0:
        print("Error! no cache data!")
        return
    # 从txt中读取数据
    data = pd.read_table(os.path.join(dir, os.listdir(dir)[0]), header=None)
    # 获取datalist ["time", "L1-dcache-load-misses", "L1-icache-load-misses", "dTLB-load-misses", "iTLB-load-misses"]数据
    data_list = get_data_list(data, match_names)

    for i in range(len(data_list)):
        for j in range(len(data_list[0])):
            # 时间数据先处理
            if j == 0:
                worksheet.cell(i + row_offset, j + 1, data_list[i][j])
            else:
                # 因便于制图，数据提前处理成浮点格式
                if data_list[i][j][-1] == '%':
                    worksheet.cell(i + row_offset, j + 1, float(data_list[i][j][:-1]))
                else:
                    worksheet.cell(i + row_offset, j + 1, float(data_list[i][j].replace(',', '')))
    
    time_category = Reference(worksheet, min_col= 1, min_row= 2,
                                         max_col= 1, max_row= 1 + len(data_list))

    # 画load misses的趋势图
    load_misses_data = Reference(worksheet, min_col= 5, min_row= 1,
                                            max_col= 8, max_row= 1 + len(data_list))
    plot_load_misses(worksheet, load_misses_data, time_category)

    # 画mem_access的趋势图
    mem_access_data = Reference(worksheet, min_col= 2, min_row= 1,
                                           max_col= 4, max_row= 1 + len(data_list))
    plot_mem_access(worksheet, mem_access_data, time_category)
