#!/bin/bash

PREFIX=$1
DIR_WORK=$(pwd)
SUFFIX=`date +%Y%m%d%H%M%S`
GSID="${PREFIX}"
GSUFFIX=""
GTIMEOUT=0
GTIME_DELAY_SEC=0

DOCKER_GPU_DIR=""
PERF_CACHE_MEM_DIR=""
PERF_MEM_DIR=""
PERF_CACHE_DIR=""
DOCKER_TOP_DATA_DIR=""
NMON_WORK_DIR=""
DELAY_STAT_DIR=""
LOG_CORE_DIR=""
NI_RSRC_MON_DIR=""
ANDROID_LOGCAT_DIR=""

FLAG_DOCKER_GPU=0
FLAG_PERF_CACHE_MEM=0
FLAG_PERF_CACHE=0
FLAG_PERF_MEM=0
FLAG_ANDROID_TOP=0
FLAG_NMON=0
FLAG_DELAY_STAT=0
FLAG_SYSCONFIG=0
FLAG_RSRC_MON=0
FLAG_ANDROID_LOGCAT=0

CPU_VENDOR_ID=$(lscpu | grep "Vendor ID" | awk -F ':' '{print $2}'|awk '{gsub(/^\s+|\s+$/, "");print}')
function task_build_dirname()
{
	local DIR=$1
	if [ ! -z "${GSID}" ]; then
		DIR=${GSID}_${DIR}
	fi
	if [ ! -z "${GSUFFIX}" ]; then
			DIR=${DIR}_${GSUFFIX}
	else
			DIR=${DIR}_${localNow}
	fi
	echo "${DIR}"	
}

function get_log_core()
{
	[ -z ${LOG_CORE_DIR} ] || [ -d ${LOG_CORE_DIR} ] || echo "DIR not exist:${LOG_CORE_DIR}"
	[ -z ${LOG_CORE_DIR} ] && echo "DIR Empty:${LOG_CORE_DIR}" && return 1		
	echo "enter get_log_core: ${LOG_CORE_DIR},time:$(date +%Y%m%d%H%M%S)"	
	mkdir ${LOG_CORE_DIR}/kernel_config
	mkdir ${LOG_CORE_DIR}/${PREFIX}_perf_record_${SUFFIX}

	if true; then
		timeout 8 iostat -d 2 3 > ${LOG_CORE_DIR}/iostat.txt
		for i in $(seq 8)
		do
			echo "===================" >> ${LOG_CORE_DIR}/proc_diskstats.txt
			cat /proc/diskstats >> ${LOG_CORE_DIR}/proc_diskstats.txt
			sleep 1
		done

		### baisc hardware config
		#################################

		echo "cmd:dmidecode -t bios" 2>&1 | tee -a log.txt
		dmidecode -t bios > ${LOG_CORE_DIR}/dmidecode_bios.txt


		echo "cmd:dmidecode -t system" 2>&1 | tee -a log.txt
		dmidecode -t system > ${LOG_CORE_DIR}/dmidecode_system.txt


		echo "cmd:dmidecode -t baseboard" 2>&1 | tee -a log.txt
		dmidecode -t baseboard > $LOG_CORE_DIR/dmidecode_baseboard.txt

		echo "cmd:dmidecode -t chassis" 2>&1 | tee -a log.txt
		dmidecode -t chassis > ${LOG_CORE_DIR}/dmidecode_chassis.txt

		echo "cmd:dmidecode -t processor" 2>&1 | tee -a log.txt
		dmidecode -t processor > $LOG_CORE_DIR/dmidecode_processor.txt


		echo "cmd:dmidecode -t memory" 2>&1 | tee -a log.txt
		dmidecode -t memory > ${LOG_CORE_DIR}/dmidecode_memory.txt


		echo "cmd:dmidecode -t cache" 2>&1 | tee -a log.txt
		dmidecode -t cache > ${LOG_CORE_DIR}/dmidecode_cache.txt

		echo "cmd:dmidecode -t connector" 2>&1 | tee -a log.txt
		dmidecode -t connector > $LOG_CORE_DIR/dmidecode_connector.txt

		echo "cmd:dmidecode -t slot" 2>&1 | tee -a log.txt
		dmidecode -t slot > ${LOG_CORE_DIR}/dmidecode_slot.txt

		echo "cmd:lshw" 2>&1 | tee -a log.txt
		lshw > ${LOG_CORE_DIR}/lshw.txt

		echo "cmd:copy kernel config" 2>&1 | tee -a log.txt
		cp /boot/config-* ${LOG_CORE_DIR}/kernel_config/ -ar

		for i in $(lsmod |  awk '{ if ( NR > 1) {print $1}}')
		do
			modinfo $i > ${LOG_CORE_DIR}/mod_$i.txt 2>&1
		done

		echo "cmd:cat flesystems" 2>&1 | tee -a log.txt
		cat /proc/filesystems > ${LOG_CORE_DIR}/proc_filesystems.txt 

		echo "cmd:mount"
		mount > ${LOG_CORE_DIR}/mounts.txt

		find /dev/ -print0  | xargs  -0 ls -al > ${LOG_CORE_DIR}/dev_trees.txt

		### system software info
		################################
		echo "cmd:uname,os-relese,sysctl,ulmit,getconf,ldd,cmdline" 2>&1 | tee -a log.txt
		echo "\n=== Kernel VERSION ===" >> ${LOG_CORE_DIR}/system_basic.txt
		uname -a >> ${LOG_CORE_DIR}/system_basic.txt 2>&1

		echo -e "\n=== OS VERSION ===" >> ${LOG_CORE_DIR}/system_basic.txt
		cat /etc/os-release >> ${LOG_CORE_DIR}/system_basic.txt 2>&1

		echo -e "\n=== PAGE SIZE ===" >> ${LOG_CORE_DIR}/system_basic.txt
		getconf -a | grep PAGE >> ${LOG_CORE_DIR}/system_basic.txt

		echo -e "\n=== sysctl ===" >> ${LOG_CORE_DIR}/system_basic.txt
		sysctl -a  >> ${LOG_CORE_DIR}/system_basic.txt 2>&1

		echo -e "\n=== ulimit ===" >> ${LOG_CORE_DIR}/system_basic.txt
		ulimit -a >> ${LOG_CORE_DIR}/system_basic.txt 2>&1

		echo -e "\n=== getconf ===" >> ${LOG_CORE_DIR}/system_basic.txt
		getconf -a >> ${LOG_CORE_DIR}/system_basic.txt 2>&1

		echo -e "\n=== ldd version ===" >> ${LOG_CORE_DIR}/system_basic.txt
		ldd --version >> ${LOG_CORE_DIR}/system_basic.txt 2>&1

		echo -e "\n=== cmdline ===" >> ${LOG_CORE_DIR}/system_basic.txt
		cat /proc/cmdline >> ${LOG_CORE_DIR}/system_basic.txt 2>&1

		for i in $(seq 7);do cat /proc/interrupts > ${LOG_CORE_DIR}/interrupts_0${i}.txt; sleep 1;done;


		cat /proc/cmdline > ${LOG_CORE_DIR}/cmdline.txt
		lspci -vv > ${LOG_CORE_DIR}/lspci_vv.txt
		dmesg > ${LOG_CORE_DIR}/dmesg_vv.txt


		numactl -H > ${LOG_CORE_DIR}/numactl_vv.txt
		echo -e "\ncat /sys/kernel/mm/transparent_hugepage/enabled"  >> ${LOG_CORE_DIR}/sys_kernel_mm.txt
		cat /sys/kernel/mm/transparent_hugepage/enabled  >> ${LOG_CORE_DIR}/sys_kernel_mm.txt

		echo -e "\ncat /proc/sys/vm/min_free_kbytes" >> ${LOG_CORE_DIR}/sys_vm.txt
		cat /proc/sys/vm/min_free_kbytes >> ${LOG_CORE_DIR}/sys_vm.txt

		echo -e "\ncat /proc/sys/vm/lowmem_reserve_ratio" >> ${LOG_CORE_DIR}/sys_vm.txt
		cat /proc/sys/vm/lowmem_reserve_ratio >> ${LOG_CORE_DIR}/sys_vm.txt

		cat /proc/vmstat > ${LOG_CORE_DIR}/vmstat.txt
		cat /proc/meminfo > ${LOG_CORE_DIR}/meminfo.txt
		cat /proc/zoneinfo > ${LOG_CORE_DIR}/zoneinfo.txt

		cat /proc/slabinfo > ${LOG_CORE_DIR}/slabinfo_vv.txt
		cat /proc/pagetypeinfo > ${LOG_CORE_DIR}/pagetypeinfo.txt

		# cp /proc/sys ${LOG_CORE_DIR}/proc_sys -ar

		### contain version
		#####################################
		docker --version > ${LOG_CORE_DIR}/docker_version.txt

		top -b -d 1 -n 2 > ${LOG_CORE_DIR}/top_summary.txt
		top -1 -b  -d 1 -n 2 >  ${LOG_CORE_DIR}/top_data.txt
		fdisk -l > ${LOG_CORE_DIR}/fdisk_data.txt
	fi
	echo "exit get_log_core: ${LOG_CORE_DIR},time:$(date +%Y%m%d%H%M%S)"
}

function task_init()
{
	echo "task_init:$@"
	PREFIX=$1
	GSID="${PREFIX}"	
	[ -e log ] || mkdir log

	local localNow=$(date +%Y%m%d%H%M%S)
	NMON=$(pidof nmon)
	echo "find pid:$NMON"
	[ ! -z $NMON ] && echo "exit" && exit 0

	local DIR=""
	if [ $FLAG_SYSCONFIG == 1 ]; then
		DIR=$(task_build_dirname "log_core")
		mkdir -p ${DIR}
		LOG_CORE_DIR=${DIR}
	fi

	if [ $FLAG_DOCKER_GPU == 1 ]; then
		if ! radeontop -v | grep -q "RadeonTop"; then
			echo "radeontop not find!!!" 
			exit 1
		fi

		DIR=$(task_build_dirname "log_docker_gpu")
		mkdir -p ${DIR}
		DOCKER_GPU_DIR=${DIR}
	fi

	if [ $FLAG_PERF_CACHE_MEM == 1 ] || [ $FLAG_PERF_MEM == 1 ] || [ $FLAG_PERF_CACHE == 1 ] ; then
		if ! perf --version | grep -q "perf version"; then
			echo "perf not find!!!"
			exit 1
		fi
		if [ $FLAG_PERF_CACHE_MEM == 1 ]; then
			DIR=$(task_build_dirname "log_perf_cache_mem")
			mkdir -p ${DIR}
			PERF_CACHE_MEM_DIR=${DIR}
		fi
		if [ $FLAG_PERF_MEM == 1 ]; then
			DIR=$(task_build_dirname "log_perf_mem")
			mkdir -p ${DIR}
			PERF_MEM_DIR=${DIR}
		fi
		if [ $FLAG_PERF_CACHE == 1 ]; then
			DIR=$(task_build_dirname "log_perf_cache")
			mkdir -p ${DIR}
			PERF_CACHE_DIR=${DIR}
		fi				
	fi

	if [ $FLAG_ANDROID_TOP == 1 ]; then
		DIR=$(task_build_dirname "log_top_docker")
		mkdir -p ${DIR}
		DOCKER_TOP_DATA_DIR=${DIR}
	fi

	if [ $FLAG_NMON == 1 ]; then
		DIR=$(task_build_dirname "log_nmon")
		mkdir -p log/${DIR}
		NMON_WORK_DIR=$(pwd)/log/${DIR}
	fi

	if [ $FLAG_DELAY_STAT == 1 ]; then
		DIR=$(task_build_dirname "log_lat_mem_rd")
		mkdir -p ${DIR}
		DELAY_STAT_DIR=${DIR}
	fi

	if [ $FLAG_RSRC_MON == 1 ]; then
		DIR=$(task_build_dirname "log_ni_rsrc_mon")
		mkdir -p ${DIR}
		NI_RSRC_MON_DIR=${DIR}
	fi

	if [ $FLAG_ANDROID_LOGCAT == 1 ]; then
		DIR=$(task_build_dirname "log_android_logcat")
		mkdir -p ${DIR}
		ANDROID_LOGCAT_DIR=${DIR}
	fi
		
	return 0
}

function task_finish()
{
	[ ! -z ${LOG_CORE_DIR} ] && [ -d ${LOG_CORE_DIR} ] && mv ${LOG_CORE_DIR} ./log/
	[ ! -z ${DOCKER_GPU_DIR} ] && [ -d ${DOCKER_GPU_DIR} ] && mv ${DOCKER_GPU_DIR} ./log/
	[ ! -z ${PERF_CACHE_MEM_DIR} ] && [ -d ${PERF_CACHE_MEM_DIR} ] && mv ${PERF_CACHE_MEM_DIR} ./log/
	[ ! -z ${PERF_CACHE_DIR} ] && [ -d ${PERF_CACHE_DIR} ] && mv ${PERF_CACHE_DIR} ./log/
	[ ! -z ${PERF_MEM_DIR} ] && [ -d ${PERF_MEM_DIR} ] && mv ${PERF_MEM_DIR} ./log/
	[ ! -z ${DOCKER_TOP_DATA_DIR} ] && [ -d ${DOCKER_TOP_DATA_DIR} ] && mv ${DOCKER_TOP_DATA_DIR} ./log/
	[ ! -z ${DELAY_STAT_DIR} ] && [ -d ${DELAY_STAT_DIR} ] && mv ${DELAY_STAT_DIR} ./log/
	[ ! -z ${NI_RSRC_MON_DIR} ] && [ -d ${NI_RSRC_MON_DIR} ] && mv ${NI_RSRC_MON_DIR} ./log/
	[ ! -z ${ANDROID_LOGCAT_DIR} ] && [ -d $ANDROID_LOGCAT_DIR ] && mv ${ANDROID_LOGCAT_DIR} ./log/
}

function task_get_gpu()
{
	[ -z ${DOCKER_GPU_DIR} ] || [ -d ${DOCKER_GPU_DIR} ] || echo "DIR not exist:${DOCKER_GPU_DIR}"
	[ -z ${DOCKER_GPU_DIR} ] && echo "DIR Empty:${DOCKER_GPU_DIR}" && return 1		
	echo "enter task_get_gpu:${DOCKER_GPU_DIR},time:$(date +%Y%m%d%H%M%S)"
	local delay_sec=$((GTIME_DELAY_SEC * 1))
	for renderIDX in $(ls /dev/dri/renderD* )
	do
		echo "${GTIMEOUT} radeontop -p $renderIDX -i ${delay_sec} -d ${DOCKER_GPU_DIR}/$(basename ${renderIDX})_$(date +%Y%m%d%H%M%S).log &"
		timeout ${GTIMEOUT} radeontop -p $renderIDX -i ${delay_sec} -d ${DOCKER_GPU_DIR}/$(basename ${renderIDX})_$(date +%Y%m%d%H%M%S).log &
	done
	echo "exit task_get_gpu:${DOCKER_GPU_DIR},time:$(date +%Y%m%d%H%M%S)"
}

function task_get_perf_cache_mem()
{
	[ -z ${PERF_CACHE_MEM_DIR} ] || [ -d ${PERF_CACHE_MEM_DIR} ] || echo "DIR not exist:${PERF_CACHE_MEM_DIR}"
	[ -z ${PERF_CACHE_MEM_DIR} ] && echo "DIR Empty:${PERF_CACHE_MEM_DIR}" && return 1		
	echo "enter task_get_perf_cache_mem:${PERF_CACHE_MEM_DIR},time:$(date +%Y%m%d%H%M%S)"
	local delay_msec=$(( GTIME_DELAY_SEC * 1000 ))
	echo "CPU_VENDOR_ID: ${CPU_VENDOR_ID}"
	if [ "${CPU_VENDOR_ID}" = "0x48" ]; then 
		timeout ${GTIMEOUT} perf stat -e mem_access,branch-misses,bus-cycles,cache-misses,cache-references,cpu-cycles,instructions,stalled-cycles-backend,stalled-cycles-frontend,alignment-faults,bpf-output,context-switches,cpu-clock,cpu-migrations,dummy,emulation-faults,major-faults,minor-faults,page-faults,task-clock,L1-dcache-load-misses,L1-dcache-loads,L1-icache-load-misses,L1-icache-loads,branch-load-misses,branch-loads,dTLB-load-misses,dTLB-loads,iTLB-load-misses,iTLB-loads -I ${delay_msec} -o ${PERF_CACHE_MEM_DIR}/perf_cache_mem_$(date +%Y%m%d%H%M%S).txt &
	else
		timeout ${GTIMEOUT} perf stat -e mem_access,mem_access_rd,mem_access_wr,unaligned_ld_spec,unaligned_ldst_spec,unaligned_st_spec,branch-misses,bus-cycles,cache-misses,cache-references,cpu-cycles,instructions,stalled-cycles-backend,stalled-cycles-frontend,alignment-faults,bpf-output,context-switches,cpu-clock,cpu-migrations,dummy,emulation-faults,major-faults,minor-faults,page-faults,task-clock,L1-dcache-load-misses,L1-dcache-loads,L1-icache-load-misses,L1-icache-loads,branch-load-misses,branch-loads,dTLB-load-misses,dTLB-loads,iTLB-load-misses,iTLB-loads -I ${delay_msec} -o ${PERF_CACHE_MEM_DIR}/perf_cache_mem_$(date +%Y%m%d%H%M%S).txt &
	fi
	echo "exit task_get_perf_cache_mem:${PERF_CACHE_MEM_DIR},time:$(date +%Y%m%d%H%M%S)"
}

function task_get_perf_cache()
{
	[ -z ${PERF_CACHE_DIR} ] || [ -d ${PERF_CACHE_DIR} ] || echo "DIR not exist:${PERF_CACHE_DIR}"
	[ -z ${PERF_CACHE_DIR} ] && echo "DIR Empty:${PERF_CACHE_DIR}" && return 1	
	echo "enter task_get_perf_cache:${PERF_CACHE_DIR},time:$(date +%Y%m%d%H%M%S)"
	local delay_msec=$(( GTIME_DELAY_SEC * 1000 ))
	timeout ${GTIMEOUT} perf stat -e branch-misses,bus-cycles,cache-misses,cache-references,cpu-cycles,instructions,stalled-cycles-backend,stalled-cycles-frontend,alignment-faults,bpf-output,context-switches,cpu-clock,cpu-migrations,dummy,emulation-faults,major-faults,minor-faults,page-faults,task-clock,L1-dcache-load-misses,L1-dcache-loads,L1-icache-load-misses,L1-icache-loads,branch-load-misses,branch-loads,dTLB-load-misses,dTLB-loads,iTLB-load-misses,iTLB-loads -I ${delay_msec} -o ${PERF_CACHE_DIR}/perf_cache_$(date +%Y%m%d%H%M%S).txt &
	echo "exit task_get_perf_cache:${PERF_CACHE_DIR},time:$(date +%Y%m%d%H%M%S)"
}

function task_get_perf_mem()
{
	[ -z ${PERF_MEM_DIR} ] || [ -d ${PERF_MEM_DIR} ] || echo "DIR not exist:${PERF_MEM_DIR}"
	[ -z ${PERF_MEM_DIR} ] && echo "DIR Empty:${PERF_MEM_DIR}" && return 1	
	echo "enter task_get_perf_mem:${PERF_MEM_DIR},time:$(date +%Y%m%d%H%M%S)"
	local delay_msec=$(( GTIME_DELAY_SEC * 1000 ))
	timeout ${GTIMEOUT} perf stat -e mem_access,mem_access_rd,mem_access_wr,unaligned_ld_spec,unaligned_ldst_spec,unaligned_st_spec -I ${delay_msec}  -o ${PERF_MEM_DIR}/perf_mem_$(date +%Y%m%d%H%M%S).txt &
	echo "exit task_get_perf_mem:${PERF_MEM_DIR},time:$(date +%Y%m%d%H%M%S)"
}

function task_get_docker_top_data()
{
	[ -z ${DOCKER_TOP_DATA_DIR} ] || [ -d ${DOCKER_TOP_DATA_DIR} ] || echo "DIR not exist:${DOCKER_TOP_DATA_DIR}"
	[ -z ${DOCKER_TOP_DATA_DIR} ] && echo "DIR Empty:${DOCKER_TOP_DATA_DIR}" && return 1	
	echo "enter task_get_docker_top_data:${DOCKER_TOP_DATA_DIR},time:$(date +%Y%m%d%H%M%S)"
	local delay_sec=$(( GTIME_DELAY_SEC * 1 ))
	local contain_name_prefix=android
	for name in $(docker ps --format "table {{.Names}}" | grep -v "NAMES" | grep ${contain_name_prefix}_ ); 
	do
		timeout ${GTIMEOUT}  docker exec -i ${name} /bin/sh -c "export TOPTS=1;/toybox top -b  -d  ${delay_sec}" > ${DOCKER_TOP_DATA_DIR}/top_data_${name}_$(date +%Y%m%d%H%M%S).txt &
	done
	wait
	for i in $(seq 0  2)
	do
		TOPLIST=$(pidof top)
		echo "top pids:${TOPLIST}"
		if [ ! -z "${TOPLIST}" ]; then
			kill  -s SIGINT ${TOPLIST}
		fi
	done
	echo "exit task_get_docker_top_data:${DOCKER_TOP_DATA_DIR},time:$(date +%Y%m%d%H%M%S)"
}

function task_get_docker_top_data_ex()
{
	[ -z ${DOCKER_TOP_DATA_DIR} ] || [ -d ${DOCKER_TOP_DATA_DIR} ] || echo "DIR not exist:${DOCKER_TOP_DATA_DIR}"
	[ -z ${DOCKER_TOP_DATA_DIR} ] && echo "DIR Empty:${DOCKER_TOP_DATA_DIR}" && return 1	
	echo "enter task_get_docker_top_data:${DOCKER_TOP_DATA_DIR},time:$(date +%Y%m%d%H%M%S)"
	local delay_sec=$(( GTIME_DELAY_SEC * 1 ))
	local contain_name_prefix=android
	for name in $(docker ps --format "table {{.Names}}" | grep -v "NAMES" | grep ${contain_name_prefix}_ ); 
	do
		docker exec -itd ${name}  /gettop.sh ${GTIMEOUT} ${delay_sec}
	done
	sleep $(( GTIMEOUT  + 5))
	for name in $(docker ps --format "table {{.Names}}" | grep -v "NAMES" | grep ${contain_name_prefix}_ );
	do
		docker cp ${name}:/data/top_data.txt ${DOCKER_TOP_DATA_DIR}/top_data_${name}_$(date +%Y%m%d%H%M%S).txt
	done
	echo "exit task_get_docker_top_data:${DOCKER_TOP_DATA_DIR},time:$(date +%Y%m%d%H%M%S)"
}


function task_get_android_logcat()
{
	[ -z ${ANDROID_LOGCAT_DIR} ] || [ -d ${ANDROID_LOGCAT_DIR} ] || echo "DIR not exist:${ANDROID_LOGCAT_DIR}"
	[ -z ${ANDROID_LOGCAT_DIR} ] && echo "DIR Empty:${ANDROID_LOGCAT_DIR}" && return 1	
	echo "enter task_get_android_logcat:${ANDROID_LOGCAT_DIR},time:$(date +%Y%m%d%H%M%S)"
	local delay_sec=$(( GTIME_DELAY_SEC * 1 ))
	local start_index=-1
	local end_index=-1
	local segments=( )
	local segcnt=0

	local contain_name_prefix=android
	segments=( $(echo "${mod_android_logcat_pset}" | awk '/-/{for (i=$1; i<=$2; i++)printf "%s%s",i,ORS;next} 1' ORS=' ' RS=, FS=-) )
	echo "range:${segments[*]}"
	for name in $(docker ps --format "table {{.Names}}" | grep -v "NAMES" | grep ${contain_name_prefix}_ )
	do
			idx=$(echo ${name} | awk -F '_' '{print $2}')
			segcnt=${#segments[@]}
			find=0
			for ((i=0; i < segcnt; i=i+1))
			do
				if [ ${segments[i]} -eq $idx ]; then
					find=1
					break
				fi
			done
			if [ $segcnt == 0 ]; then
				find=1
			fi
			if [ $find == 0 ]; then
				continue;
			fi

			if [ ! -z "${mod_android_logcat_pgrep}" ]; then
				echo "timeout ${GTIMEOUT} docker exec  ${name}  logcat | grep -E \""${mod_android_logcat_pgrep}"\" >  ${ANDROID_LOGCAT_DIR}/logcat_${name}.log &"
				timeout ${GTIMEOUT} docker exec  ${name}  logcat | grep -E "${mod_android_logcat_pgrep}" >  ${ANDROID_LOGCAT_DIR}/logcat_${name}.log &
			else
				echo "timeout ${GTIMEOUT} docker exec  ${name}  logcat >  ${ANDROID_LOGCAT_DIR}/logcat_${name}.log &"
				timeout ${GTIMEOUT} docker exec  ${name}  logcat >  ${ANDROID_LOGCAT_DIR}/logcat_${name}.log &
			fi 
	done
	wait
	for i in $(seq 0  2)
	do
		TOPLIST=$(pidof logcat)
		echo "top pids:${TOPLIST}"
		if [ ! -z "${TOPLIST}" ]; then
			kill  -s SIGINT ${TOPLIST}
		fi
	done
	echo "exit task_get_android_logcat:${ANDROID_LOGCAT_DIR},time:$(date +%Y%m%d%H%M%S)"	
}

function task_get_nmon()
{
	[ -z ${NMON_WORK_DIR} ] || [ -d ${NMON_WORK_DIR} ] || echo "DIR not exist:${NMON_WORK_DIR}"
	[ -z ${NMON_WORK_DIR} ] && echo "DIR Empty:${NMON_WORK_DIR}" && return 1
	echo "enter task_get_nmon: ${NMON_WORK_DIR},time:$(date +%Y%m%d%H%M%S)"
	local delay_sec=$(( GTIME_DELAY_SEC * 1 ))
	if [ $delay_sec -eq 1 ]; then
            delay_sec=2
	fi
	local cnt=$(( GTIMEOUT / $delay_sec ))
	local access_cnt=0
	nmon -f -m ${NMON_WORK_DIR} -s ${delay_sec} -c ${cnt}
	while true 
	do
		PID=$(pidof nmon)
		if [ -z "$PID" ]; then
			echo  "nmon exit!!!"
			break
		fi
		if [ $access_cnt == 0 ]; then
			access_cnt=1
			echo "nmon still active!!"
		fi
		sleep 1
	done
	echo "exit task_get_nmon:${NMON_WORK_DIR},time:$(date +%Y%m%d%H%M%S)"
}

function task_get_encoder()
{
	[ -z ${NI_RSRC_MON_DIR} ] || [ -d ${NI_RSRC_MON_DIR} ] || echo "DIR not exist:${NI_RSRC_MON_DIR}"
	[ -z ${NI_RSRC_MON_DIR} ] && echo "DIR Empty:${NI_RSRC_MON_DIR}" && return 1	
	echo "enter ni_rsrc_mon:${NI_RSRC_MON_DIR},time:$(date +%Y%m%d%H%M%S)"
	local filetime=$(date +%Y%m%d%H%M%S)
	for ((i=0; i < GTIMEOUT; i=i+GTIME_DELAY_SEC))
	do
		ni_rsrc_mon_logan >> ${NI_RSRC_MON_DIR}/ni_rsrc_mon_${filetime}.txt
		sleep ${GTIME_DELAY_SEC}
	done
	echo "exit ni_rsrc_mon:time:${NI_RSRC_MON_DIR}, time:$(date +%Y%m%d%H%M%S)"
}

function task_get_delay_stat()
{
	[ -z ${DELAY_STAT_DIR} ] || [ -d ${DELAY_STAT_DIR} ] || echo "DIR not exist:${DELAY_STAT_DIR}"
	[ -z ${DELAY_STAT_DIR} ] && echo "DIR Empty:${DELAY_STAT_DIR}" && return 1	
	echo "enter task_get_delay_stat:${DELAY_STAT_DIR},time:$(date +%Y%m%d%H%M%S)"
	local filetime=$(date +%Y%m%d%H%M%S)
	echo "numactl -C 0 -m 0 lat_mem_rd -P 1 -W 5 -N 5 -t 1024M 1024" >> ${DELAY_STAT_DIR}/delay_numa0_${filetime}.txt
	time numactl -C 0 -m 0 lat_mem_rd -P 1 -W 5 -N 5 -t 1024M 1024 2>&1 | tee -a ${DELAY_STAT_DIR}/delay_numa0_${filetime}.txt

	filetime=$(date +%Y%m%d%H%M%S)
	echo "numactl -C 0 -m 1 lat_mem_rd -P 1 -W 5 -N 5 -t 1024M 1024" >> ${DELAY_STAT_DIR}/delay_numa1_${filetime}.txt
	time numactl -C 0 -m 1 lat_mem_rd -P 1 -W 5 -N 5 -t 1024M 1024 2>&1 | tee -a ${DELAY_STAT_DIR}/delay_numa1_${filetime}.txt

	filetime=$(date +%Y%m%d%H%M%S)
	echo "numactl -C 0 -m 2 lat_mem_rd -P 1 -W 5 -N 5 -t 1024M 1024" >> ${DELAY_STAT_DIR}/delay_numa2_${filetime}.txt
	time numactl -C 0 -m 2 lat_mem_rd -P 1 -W 5 -N 5 -t 1024M 1024 2>&1 | tee -a  ${DELAY_STAT_DIR}/delay_numa2_${filetime}.txt

	filetime=$(date +%Y%m%d%H%M%S)
	echo "numactl -C 0 -m 3 lat_mem_rd -P 1 -W 5 -N 5 -t 1024M 1024" >> ${DELAY_STAT_DIR}/delay_numa3_${filetime}.txt
	time  numactl -C 0 -m 3 lat_mem_rd -P 1 -W 5 -N 5 -t 1024M 1024 2>&1 | tee -a ${DELAY_STAT_DIR}/delay_numa3_${filetime}.txt
}

function show_help()
{
	echo "usage:native_get_perf_data.sh [all|sysconfig|mem_bw|cache_miss|mem_bw_cache_miss|mem_delay|gpu|android_top|android_logcat|nmon|encoder|help] [prefix]"
}

function get_options()
{
	local action=$1
	local FLAG_ALL=0
	case $action in
		all)
			FLAG_ALL=1
			;;
		sysconfig)
			FLAG_SYSCONFIG=1
			;;
		mem_bw)
			FLAG_PERF_MEM=1
			;;	
		cache_miss)
			FLAG_PERF_CACHE=1
			;;
		mem_bw_cache_miss)
			FLAG_PERF_CACHE_MEM=1
			;;
		mem_delay)
			FLAG_DELAY_STAT=1
			;;
		gpu)
			FLAG_DOCKER_GPU=1
			;;	
		android_top)
			FLAG_ANDROID_TOP=1
			;;
		android_logcat)
			FLAG_ANDROID_LOGCAT=1
			;;
		nmon)
			FLAG_NMON=1	
			;;
		encoder)
			FLAG_RSRC_MON=1
			;;	
		-h|help) show_help; exit 0 ;;
		*) show_help; exit 0 ;;
	esac

	while read line
	do
		### trim blank char
		newline=$(echo "${line}")
		if [ "X${newline}" == "X" ]; then
		    echo "Line Igore:'${newline}'"
		    continue;
		fi

		if [ ${newline:0:1} == "#" ]; then
		   echo "Line Igore:'${newline}'"
		   continue;
		fi
		key=$(echo $line |awk -F= '{print $1}')
		val=$(echo $line |awk -F= '{print $2}')
		if [ "X${key}" != "X" ]; then
		eval "$key=\"${val}\""
		fi
	done < native_get_perf.cfg
	echo "mod_android_logcat_pset:$mod_android_logcat_pset"
	echo "mod_android_logcat_pgrep:$mod_android_logcat_pgrep"
	
	GTIMEOUT=$collect_total_time
	GTIME_DELAY_SEC=$collect_interval_time
	[ $mod_sysconfig == 1 -a $FLAG_ALL == 1 ] && FLAG_SYSCONFIG=1
	[ $mod_mem_bw == 1 -a $FLAG_ALL == 1 ] &&  FLAG_PERF_MEM=1
	[ $mod_cache_miss == 1 -a $FLAG_ALL == 1 ] &&  FLAG_PERF_CACHE=1
	[ $mod_mem_bw_cache_miss == 1 -a $FLAG_ALL == 1 ] &&  FLAG_PERF_CACHE_MEM=1
	[ $mod_mem_delay == 1 -a $FLAG_ALL == 1 ] &&  FLAG_DELAY_STAT=1
	[ $mod_gpu == 1 -a $FLAG_ALL == 1  ] &&  FLAG_DOCKER_GPU=1
	[ $mod_android_top == 1 -a $FLAG_ALL == 1 ] &&  FLAG_ANDROID_TOP=1
	[ $mod_android_logcat == 1 -a $FLAG_ALL == 1 ] &&  FLAG_ANDROID_LOGCAT=1
	[ $mod_nmon == 1 -a $FLAG_ALL == 1 ] &&  FLAG_NMON=1
	[ $mod_encoder == 1 -a $FLAG_ALL == 1 ] &&  FLAG_RSRC_MON=1
	
	[ $FLAG_PERF_CACHE_MEM == 1 ] && FLAG_PERF_CACHE=0
	[ $FLAG_PERF_CACHE_MEM == 1 ] && FLAG_PERF_MEM=0
	return 0
}

function do_main()
{
	echo "param:$@"
	echo "begin task:gpu,perf mem_cache,docker_top data, time:$(date +%Y%m%d%H%M%S)"
	task_init "$@"

	[ $FLAG_SYSCONFIG == 1 ] && get_log_core
	[ $FLAG_RSRC_MON == 1 ] && task_get_encoder &
	[ $FLAG_DOCKER_GPU == 1 ] && task_get_gpu
	[ $FLAG_PERF_CACHE_MEM == 1 ] && task_get_perf_cache_mem
	[ $FLAG_PERF_CACHE == 1 ] && task_get_perf_cache
	[ $FLAG_PERF_MEM == 1 ] && task_get_perf_mem
	[ $FLAG_ANDROID_TOP == 1 ] && task_get_docker_top_data_ex  &
	[ $FLAG_ANDROID_LOGCAT == 1 ] &&  task_get_android_logcat  &
	echo "begin wait task:gpu,perf mem_cache,docker_top data, time:$(date +%Y%m%d%H%M%S)"
	wait
	echo "finish task:gpu,perf mem_cache,docker_top data, time:$(date +%Y%m%d%H%M%S)"

	[ $FLAG_NMON == 1 ] && task_get_nmon
	[ $FLAG_DELAY_STAT == 1 ] && task_get_delay_stat
	task_finish
	echo "collect all success!!!, time:$(date +%Y%m%d%H%M%S)"
}

ACTION=$1;shift
get_options ${ACTION}
do_main "$@"
