#!/bin/bash

# ******************************************************************************** #
# Copyright Kbox Technologies Co., Ltd. 2020-2022. All rights reserved.
# File Name: create-package.sh
# Description: android镜像打tar包.
# Usage: create-package.sh
# ******************************************************************************** #

set -ex

system=$1
vulkan_dir=$2
destdir=$PWD

if [ -z "$system" ]; then
    echo "Usage: $0 <system image>"
    exit 1
fi

workdir=$(mktemp -d)
rootfs=$workdir/rootfs

mkdir -p "$rootfs"

mkdir "$workdir"/system
sudo mount -o loop,ro "$system" "$workdir"/system
sudo cp -ar "$workdir"/system/* "$rootfs"/
sudo umount "$workdir"/system

sudo cp -ar "$rootfs"/system/apex/* "$rootfs"/apex/
sudo rm -rf "$rootfs"/system/apex

artdir=$(sudo find "$rootfs"/apex -name com.android.art"*" | head -n 1)
if [ -d ${artdir} ];then
    sudo cp -anr "$artdir"/lib64/* "$rootfs"/system/lib64
    sudo cp -anr "$artdir"/lib/* "$rootfs"/system/lib
    sudo mv "$artdir" "$rootfs"/apex/com.android.art
fi

sudo cp -anr "$rootfs"/apex/com.android.adbd/lib64/libadbconnection_client.so "$rootfs"/system/lib64
sudo cp -anr "$rootfs"/apex/com.android.adbd/lib/libadbconnection_client.so "$rootfs"/system/lib

# Copy external vulkan drivers
#64bit
if [ -d ${vulkan_dir} ];then
    sudo cp -rf "$vulkan_dir"/system/lib64/libdrm.so "$rootfs"/system/lib64
    sudo cp -rf "$vulkan_dir"/system/vendor/lib64/libdrm_amdgpu.so.1 "$rootfs"/system/vendor/lib64
    sudo cp -rf "$vulkan_dir"/system/vendor/lib64/libLLVM-12.so "$rootfs"/system/vendor/lib64
    sudo cp -rf "$vulkan_dir"/system/vendor/lib64/hw/vulkan.radv.so "$rootfs"/system/vendor/lib64/hw
    #32bit
    sudo cp -rf "$vulkan_dir"/system/lib/libdrm.so "$rootfs"/system/lib
    sudo cp -rf "$vulkan_dir"/system/vendor/lib/libdrm_amdgpu.so.1 "$rootfs"/system/vendor/lib
    sudo cp -rf "$vulkan_dir"/system/vendor/lib/libLLVM-12.so "$rootfs"/system/vendor/lib
    sudo cp -rf "$vulkan_dir"/system/vendor/lib/hw/vulkan.radv.so "$rootfs"/system/vendor/lib/hw
else
    echo "cannot find external vulkan driver"
fi

# FIXME
sudo chmod +x "$rootfs"/kbox-init.sh

if [ -e android.tar ]; then
    DATE=$(date +%F_%R)
    SAVETO=android-old-$DATE.tar

    echo "#########################################################"
    echo "# WARNING: Old android.tar still exists.                 "
    echo "#          Moving it to $SAVETO.                         "
    echo "#########################################################"

    mv android.tar "$SAVETO"
fi

#sudo mksquashfs $rootfs $destdir/android.tar -comp xz -no-xattrs
cd "$rootfs"
sudo tar --numeric-owner -cf "$destdir"/android.tar ./
sudo chown "$USER":"$USER" "$destdir"/android.tar

cd "$destdir"
sudo rm -rf "$workdir"
