#!/bin/bash
#******************************************************************************
# Copyright (C), 2021-2021, Huawei Tech. Co., Ltd.
# File : fusionstorage_disk_usage.sh
# 1.Collecting disks usage for FusionStorage
#
#  History       :
#  1.Date        : 2021/07/23
#    Modification: Created file
#******************************************************************************

PERSISTENCE_LAYER_PATH="/opt/dfv/persistence_layer"
NODE_TYPE_MDC=0
DEST_MID_MDC=8
MDC_URL_STR="mdc_url"

dest_id_ip=""
dest_port=""
storage_ip_addr=""

DSWARE_INSIGHT_TOOL="/opt/dfv/persistence_layer/agent/tool/dsware_insight"
export LD_LIBRARY_PATH=/opt/dfv/oam/oam-p/tools/kmc/lib:/opt/dfv/persistence_layer/agent/lib:$LD_LIBRARY_PATH

#*****************************************************************************
# Prototype    : check_storage_env
# Description  : Check the FusionStorage Environment
# Parameter:
#   input:  NA
#   output: NA
# Return Value : NA
#
#  History        :
#  1.Date         : 2021/07/23
#    Modification : Created function
#
#*****************************************************************************
function check_storage_env()
{
    if [ ! -e "${PERSISTENCE_LAYER_PATH}" ];then
        return 1
    fi

    # dsware_insight --help
    # Usage: dsware_insight [node_type] [dest_id] [dest_ip] [dest_port] [dest_mid] [command_type] [ parameter ... ].
    if [ -z "$(${DSWARE_INSIGHT_TOOL} -h 2>/dev/null)" ]; then
        return 1
    fi

    return 0
}

#*****************************************************************************
# Prototype    : get_storage_base_info
# Description  : Get disk of FusionStorage basic info
# Parameter:
#   input:  NA
#   output: NA
# Return Value : NA
#
#  History        :
#  1.Date         : 2021/07/23
#    Modification : Created function
#
#*****************************************************************************
function get_storage_base_info()
{
    local mdc_url_content
    local ip_str

    mdc_url_content=$(grep "${MDC_URL_STR}" "${PERSISTENCE_LAYER_PATH}"/*/conf/*.c*f* 2>/dev/null)
    if [ $? -ne 0 ]; then
        return 1
    fi

    # example:0:1:130.28.47.36@130.28.47.36:10530
    ip_str=$(echo "${mdc_url_content}" | grep @ | awk -F= '{print $2}' | head -n1 | awk -F, '{print $1}')

    # the value of dest_id_ip: 1 130.28.47.36
    dest_id_ip=$(echo ${ip_str} | awk -F@ '{print $1}'| awk -F: '{if($3){print $2,$3}else {print $1,$2}}')

    # the value of dest_port: 10530
    dest_port=$(echo ${ip_str} | awk -F@ '{print $2}' | awk -F: '{print $2}')
    if [[ -z "${dest_id_ip}" ]] || [[ -z "${dest_port}" ]]; then
        return 1
    fi

    return 0
}

#*****************************************************************************
# Prototype    : get_storage_ip
# Description  : Get storage ip
# Parameter:
#   input:  NA
#   output: NA
# Return Value : NA
#
#  History        :
#  1.Date         : 2021/07/23
#    Modification : Created function
#
#*****************************************************************************
function get_storage_ip()
{
    local storage_info
    local storage_ip_list
    local intel_ip

    storage_info=$(${DSWARE_INSIGHT_TOOL} ${NODE_TYPE_MDC} ${dest_id_ip} ${dest_port} ${DEST_MID_MDC} 101 0  2>/dev/null | grep -v " STORAGE IP_0")
    storage_ip_list=$(echo "${storage_info}" | awk -F'|' '{if($14)m[$14]+=1}END{for(k in m){print k,m[k]} }'|sort|uniq|awk '{print $1}'| sort -n -k2)
    if [ -z "${storage_ip_list}" ]; then
        return 1
    fi

    intel_ip=$(ip addr show  2>/dev/null | grep "inet ")

    for ip in ${storage_ip_list[@]}; do
        ret=$(echo "${intel_ip}" | grep -w ${ip})
        if [ $? -eq 0 ]; then
            storage_ip_addr=${ip}
            break;
        fi
    done

    if [ -z "${storage_ip_addr}" ]; then
        return 1
    fi

    return 0
}

#*****************************************************************************
# Prototype    : get_storage_usage
# Description  : Get storage disk usage
# Parameter:
#   input:  NA
#   output: NA
# Return Value : NA
#
#  History        :
#  1.Date         : 2021/07/23
#    Modification : Created function
#
#*****************************************************************************
function get_storage_usage()
{
    local dsware_list_info
    local dsware_list_total
    local dsware_list_use
    local total=0
    local total_size_GB=0
    local use=0
    local use_size_GB=0 
    local usage=0

    dsware_list_info=$(${DSWARE_INSIGHT_TOOL} ${NODE_TYPE_MDC} ${dest_id_ip} ${dest_port} ${DEST_MID_MDC} 168 0 2>/dev/null | grep ${storage_ip_addr})

    dsware_list_total=$(echo "${dsware_list_info}" | awk -F'|' '{print $12}' | awk '{print $1}')
    for sub_total in ${dsware_list_total[@]}; do
        total=$(expr ${total} + ${sub_total})
    done

    total_size_GB=$(awk 'BEGIN{printf "%.2f",('${total}'/1024)}' 2>/dev/null)
    if [[ ${total_size_GB} == "0.00" ]] || [[ ${total} == "0" ]]; then
        return 1
    fi
    echo "TotalCapacity:${total_size_GB}"

    dsware_list_use=$(echo "${dsware_list_info}" | awk -F'|' '{print $13}' | awk '{print $1}')
    for sub_use in ${dsware_list_use[@]}; do
        use=$(expr ${use} + ${sub_use})
    done

    use_size_GB=$(awk 'BEGIN{printf "%.2f",('${use}'/1024)}' 2>/dev/null)
    echo "UsedCapacity:${use_size_GB}"

    usage=$(awk 'BEGIN{printf "%.2f",('${use_size_GB}'*100/'${total_size_GB}')}' 2>/dev/null)
    echo "Usage:${usage}"

    return 0
}

check_storage_env
if [ $? -ne 0 ]; then
    exit 0
fi

get_storage_base_info
if [ $? -ne 0 ]; then
    exit 1
fi

get_storage_ip
if [ $? -ne 0 ]; then
    exit 1
fi

get_storage_usage
if [ $? -ne 0 ]; then
    exit 1
fi
