#!/bin/bash
# chkconfig: - 95 15
#******************************************************************************
# Copyright (C), 2020, Huawei Tech. Co., Ltd.
# File : bob.sh
# 1.Implement bob service.
#
#  History       :
#  1.Date        : 2020/11/25
#    Modification: Add description
#******************************************************************************

LOCAL_DIR="/opt/huawei/ibma"
DIR_NAME="ibma"
BOB_PATH="${LOCAL_DIR}/bin/bob"
BOB_CMD_PATH="${LOCAL_DIR}/bin/bobCmd"
LOG_FILE="${LOCAL_DIR}/log/bob.log"

LOG_DIR="${LOCAL_DIR}/log"
BOB_LOG_PATH="${LOG_DIR}/bob.log"

ibma_syslog=false
SYSLOG_TAG="iBMA boblog"
LOG_TYPE_ARRAY=(auth cron daemon kernel mail syslog lpr)
SYSLOG_TYPE=user

LOG_LEVEL=1
LOG_STDOUT=1
LOG_LEVEL_HINT=4

if [ ! -d "${LOG_DIR}" ]; then
      mkdir -p ${LOG_DIR}
      # Set directory permissions=640
      chmod 640 ${LOG_DIR}
fi

if [ ! -e "${BOB_PATH}" ]; then
    touch "${BOB_PATH}"
    if [ $? -ne 0 ]; then
        echo "creat ${BOB_PATH} fail."
    fi
fi

#*****************************************************************************
# Prototype    : read_from_file
# Description  : read item value of a section in configuration file.
# Parameter:
#   input:  $1 file name,  $2 section,  $3 item
#   output: value
# Return Value : NA
#
#  History        :
#  1.Date         : 2018/05/04
#    Modification : Created function
#
#*****************************************************************************
function read_from_file()
{
    local ini_file="$1"
    local section="$2"
    local item="$3"
    local value

    value=$(awk -F '=' '/\['$section'\]/{a=1}a==1&&$1~/'$item'/{print $2;exit}' $ini_file)

    echo "${value}" | sed -e 's/[\r\n]//g'
}

#*****************************************************************************
# Prototype    : get_syslogConfig
# Description  : get syslog configuration information.
# Parameter:
#   input:  NA
#   output: NA
# Return Value : NA
#
#  History        :
#  1.Date         : 2018/05/04
#    Modification : Created function
#
#*****************************************************************************
function get_syslog_config()
{
    # update ibma_syslog
    local ibma_ini="$(pwd)/config/iBMA.ini"
    if [ -f "${ibma_ini}" ]; then
        ibma_syslog=$(read_from_file ${ibma_ini} "iBMA_System" "iBMA_syslog")
    fi

    # syslog type
    local syslog_ini="$(pwd)/config/syslog.ini"
    if [ -f "${syslog_ini}" ]; then
        local syslog_type_tmp=$(read_from_file ${syslog_ini} "iBMA_syslog" "type")
        if [[ "${LOG_TYPE_ARRAY[@]}" =~ "$syslog_type_tmp" ]] ; then
            SYSLOG_TYPE=${syslog_type_tmp}
        fi
    fi
}

function log()
{
    # 3 arguments, or with a 'HIDE'.
    if [ 3 == $# -a 4 == $# -a "HIDE" != "$4" ] ; then
        echo "Log error, invalid parameters."
        return ;
    fi

    # log to file and syslog.
    if [ $1 -ge ${LOG_LEVEL} ]; then
        echo "[ $(date) ] $2 $3" 2> /dev/null >> "${BOB_LOG_PATH}"

        # log to syslog.
        if [ "true" == "${ibma_syslog}" ]; then
            if [ $1 -eq 0 ]; then
                logger -t ${SYSLOG_TAG} -p ${SYSLOG_TYPE}.debug "$2" "$3" 2> /dev/null
            elif [ $1 -eq 1 ]; then
                logger -t ${SYSLOG_TAG} -p ${SYSLOG_TYPE}.info "$2" "$3" 2> /dev/null
            elif [ $1 -eq 2 ]; then
                logger -t ${SYSLOG_TAG} -p ${SYSLOG_TYPE}.warn "$2" "$3" 2> /dev/null
            elif [ $1 -eq 3 ]; then
                logger -t ${SYSLOG_TAG} -p ${SYSLOG_TYPE}.error "$2" "$3" 2> /dev/null
            fi
        fi
    fi

    # log to stdout.
    if [ $# -eq 3 ]; then
        if [ $1 -eq ${LOG_LEVEL_HINT} ]; then
            echo -e ${COLOR_RED}"$3"${COLOR_NORMAL}
        elif [ $1 -ge ${LOG_STDOUT} ]; then
            echo "$3"
        fi
    fi
}

# get syslog configuration information.
get_syslog_config

shopt  -s  expand_aliases
# alias log function with log level.
alias LOG_DEBUG='log 0 "[SERVICE DEBUG] "'
alias LOG_INFO='log 1 "[SERVICE INFO] "'
alias LOG_WARN='log 2 "[SERVICE WARN] "'
alias LOG_ERROR='log 3 "[SERVICE ERROR] "'
alias LOG_HINT='log 4 "[SERVICE HINT] "'

function bob_start()
{
    ps -c |grep -w "${BOB_PATH}" |grep -v grep -q
    if [ $? -eq 0 ]; then
        echo "bob service is already running"
        return 0
    fi

    ${BOB_PATH} & > /dev/null

    timeout=0
    while [ $timeout -lt 60 ]; do
        sleep 0.5
        ps -ef |grep -w "${BOB_PATH}" |grep -v grep -q
        if [ $? -eq 0 ]; then
            LOG_INFO "bob service start successfully."
            return 0
        fi
        let timeout++
    done

    LOG_ERROR "Failed to start bob service."
    return 1
}

function bob_stop()
{
    PID=$(ps -ef | grep -w "${BOB_PATH}" | grep -v grep | awk '{print $2}')
    if [  -z "${PID}" ]; then
        echo "bob service is not running"
        return 0
    fi

    kill -2 ${PID} > /dev/null

    timeout=0
    while [ $timeout -lt 60 ]; do
        sleep 0.5
        ps -ef |grep -w "${BOB_PATH}" |grep -v grep -q
        if [ $? -ne 0 ]; then
            LOG_INFO "bob service stop successfully."
            return 0
        fi
        let timeout++
    done

    LOG_ERROR "Failed to stop bob service."
    return 1
}

case "$1" in
    start)
        bob_start
        exit $?
    ;;

    stop)
        bob_stop
        exit $?
    ;;

    restart)
        bob_stop
        if [ $? -ne 0 ]; then
            LOG_ERROR "Failed to restart bob service."
            exit 1
        fi
        bob_start
        if [ $? -ne 0 ]; then
            LOG_ERROR "Failed to restart bob service."
            exit 1
        fi
        exit 0
    ;;

    status)
        ps -ef |grep -w "${BOB_PATH}" |grep -v grep -q
        if [ $? -eq 0 ] ;then
            echo "status bob service is running."
            exit 0
        else
            echo "status bob service is not running."
            exit 3
        fi
    ;;

esac

