#!/bin/bash
#******************************************************************************
# Copyright (C), 2015-2017, Huawei Tech. Co., Ltd.
# File : uninstall.sh
# 1.uninstall iBMA2.0 software
#
#  History       :
#  1.Date        : 2016/12/26
#    Modification: Created file
#******************************************************************************

if [ -L ${0} ]; then
    REALFILE=$(readlink ${0})
else
    REALFILE=${0}
fi

CUR_DIR=$(dirname ${REALFILE})
cd ${CUR_DIR}
cd ..

# Paths to programs
ECHO=/bin/echo
OLD_BMA_DIR=$(pwd)
SERVICE_NAME=iBMA
BMA_DIR=/opt/huawei
DIR_NAME=ibma
SRRVICE_EXIST=false
SILENT_MODE=false
UNINSTALL_DRIVER=false
SERVICE_SCRIPT=/etc/init.d/${SERVICE_NAME}
IBMA_REBOOT_NEEDED=false

NETWORK_SETUP_TOOL="${OLD_BMA_DIR}/bin/manager"

OS_SUPPROT_SYSTEMCTL=false
SYSTEMCTL_SERVICE=iBMA.service

BOBSERVICE_NAME=bob
BOBSYSTEMCTL_SERVICE=bob.service
BOBSERVICE_SCRIPT=/etc/init.d/${BOBSERVICE_NAME}
BOBSRRVICE_EXIST=false
#BOBSERVICE_RUNNING=true

IBMACLI_LINK_PATH=/usr/bin/ibmacli
SYSTEMD_DIR='/usr/lib/systemd/system/'
if [ ! -e "${SYSTEMD_DIR}" ]; then
    # Ubuntu systemctl services save in the follow directory
    SYSTEMD_DIR='/lib/systemd/system/'
fi
SYSTEMD_EXEC_DIR='/etc/systemd/system/multi-user.target.wants/'

source "${OLD_BMA_DIR}/lib/Linux/log.sh"

#*****************************************************************************
# Prototype    : stop_ibma_service
# Description  : try to stop iBMA service if it's running.
# Parameter:
#   input: NA
#   output: NA
# Return Value : NA
#
#  History        :
#  1.Date         : 2016/12/26
#    Modification : Created function
#  2.Date         : 2019/08/10
#    Modification : Stop all network service
#  3.Date         : 2019/09/20
#    Modification : Only stop service when manager exists.
#*****************************************************************************
function stop_ibma_service()
{
    local res

    service_running=false
    BMA_SH_PATH="${BMA_DIR}/ibma/iBMA.sh"
    # "/etc/init.d/iBMA" is the default path
    if [ -r "${SERVICE_SCRIPT}" ] && [ -r "${BMA_SH_PATH}" ] ; then
        SRRVICE_EXIST=true
        service_running=true
        # get running status.
        ${BMA_SH_PATH} status  >& /dev/null || service_running=false
    elif [ -r "${SYSTEMD_DIR}/${SYSTEMCTL_SERVICE}" ] && [ -r "${BMA_SH_PATH}" ] ; then
        SRRVICE_EXIST=true
        # get running status.
        service_running=true

        ${BMA_SH_PATH} status  >& /dev/null || service_running=false
    fi

    if [ false != ${service_running} ]; then
        LOG_INFO "${SERVICE_NAME} service is running. Stop it first."
        LOG_ERROR "Failed to uninstall ${SERVICE_NAME} software."
        exit 3
    fi

    BOBSERVICE_RUNNING=false
    BOB_SH_PATH="${BMA_DIR}/ibma/bob.sh"
    # "/etc/init.d/bob" is the default path
    if [ -r "${BOBSERVICE_SCRIPT}" ] && [ -r "${BOB_SH_PATH}" ] ; then
        BOBSRRVICE_EXIST=true
        BOBSERVICE_RUNNING=true
        # get running status.
        ${BOB_SH_PATH} status  >& /dev/null || BOBSERVICE_RUNNING=false
    elif [ -r "${SYSTEMD_DIR}/${BOBSYSTEMCTL_SERVICE}" ] && [ -r "${BOB_SH_PATH}" ] ; then
        BOBSRRVICE_EXIST=true
        # get running status.
        BOBSERVICE_RUNNING=true

        ${BOB_SH_PATH} status  >& /dev/null || BOBSERVICE_RUNNING=false
    fi

    if [ false != ${BOBSERVICE_RUNNING} ]; then
        LOG_INFO "${BOBSERVICE_NAME} service is running. Stop it first."
        LOG_ERROR "Failed to uninstall ${BOBSERVICE_NAME} software."
        exit 3
    fi

    if [ -x ${NETWORK_SETUP_TOOL} ]; then
        res=$(${NETWORK_SETUP_TOOL} stop all 2>&1)
        LOG_INFO "stop all network service: ${res}, code: $?" "HIDE"
    fi

    if [ -e "/sys/module/cdev_veth_drv" ]; then
        res=$(rmmod cdev_veth_drv 2>&1)
        LOG_INFO "remove cdev_veth_drv: ${res}, code: $?" "HIDE"
    fi
}

#*****************************************************************************
# Prototype    : remove_ibma_files
# Description  : remove iBMA files.
# Parameter:
#   input: NA
#   output: NA
# Return Value : NA
#
#  History        :
#  1.Date         : 2016/12/26
#    Modification : Created function
#
#*****************************************************************************
function remove_ibma_files()
{
    LOG_INFO "Delete ${SERVICE_NAME} directory."

    if [ false != $SRRVICE_EXIST ]; then
        LOG_INFO "Delete service script."
        if [ -r "${SERVICE_SCRIPT}" ]; then
            res1=$(chkconfig --del ${SERVICE_NAME} 2>&1) || \
            res2=$(update-rc.d -f ${SERVICE_NAME} remove 2>&1)
            if [ $? -ne 0 ]; then
                LOG_INFO "Failed to unregister ${SERVICE_NAME} service, ignored."
                LOG_INFO "res1=S{res1}" "HIDE"
                LOG_INFO "res2=S{res2}" "HIDE"
            fi
            rm -f "${SERVICE_SCRIPT}"
        else
            if [ -e "${SYSTEMD_DIR}${SYSTEMCTL_SERVICE}" ]; then
                res=$(systemctl disable ${SYSTEMCTL_SERVICE} 2>/dev/null)
                if [ 0 != $? ] ; then
                    LOG_ERROR "Systemctl disable ${SYSTEMCTL_SERVICE} failed, return ${res}."
                fi

                # remove old systemctl script.
                res=$(rm -rf  "${SYSTEMD_DIR}${SYSTEMCTL_SERVICE}" 2>/dev/null)
            fi

            if [ -e "${SYSTEMD_EXEC_DIR}${SYSTEMCTL_SERVICE}" ]; then
                res=$(rm -f  "${SYSTEMD_EXEC_DIR}${SYSTEMCTL_SERVICE}" 2> /dev/null)
            fi

            res=$(systemctl daemon-reload 2>&1)
            if [ 0 != $? ] ; then
                LOG_ERROR "Systemctl daemon-reload failed, return ${res}."
                exit 1
            fi
        fi
    fi

    if [ false != $BOBSRRVICE_EXIST ]; then
        LOG_INFO "Delete bob service script."
        if [ -r "${BOBSERVICE_SCRIPT}" ]; then
            res1=$(chkconfig --del ${BOBSERVICE_NAME} 2>&1) || \
            res2=$(update-rc.d -f ${BOBSERVICE_NAME} remove 2>&1)
            if [ $? -ne 0 ]; then
                LOG_INFO "Failed to unregister ${BOBSERVICE_NAME} service, ignored."
                LOG_INFO "res1=S{res1}" "HIDE"
                LOG_INFO "res2=S{res2}" "HIDE"
            fi
            rm -f "${BOBSERVICE_SCRIPT}"
        else
            if [ -e "${SYSTEMD_DIR}${BOBSYSTEMCTL_SERVICE}" ]; then
                # remove old systemctl script.
                res=$(rm -rf  "${SYSTEMD_DIR}${BOBSYSTEMCTL_SERVICE}" 2>/dev/null)
            fi

            if [ -e "${SYSTEMD_EXEC_DIR}${BOBSYSTEMCTL_SERVICE}" ]; then
                res=$(rm -f  "${SYSTEMD_EXEC_DIR}${BOBSYSTEMCTL_SERVICE}" 2> /dev/null)
            fi

            res=$(systemctl daemon-reload 2>&1)
            if [ 0 != $? ] ; then
                LOG_ERROR "Systemctl daemon-reload failed, return ${res}."
                exit 1
            fi
        fi
    fi
}

#*****************************************************************************
# Prototype    : del_default_user
# Description  : Delete the ibma user if it was created by iBMA.
# Parameter:
#   input:  NA.
#   output: NA
# Return Value : NA
#
#  History        :
#  1.Date         : 2019/4/25
#    Modification : Created function
#  2.Date         : 2019/9/11
#    Modification : Optimize the method to check whether iBMA is upgrading
#
#*****************************************************************************
function del_default_user()
{
    local ibma_default_user_name="ibma"
    local ibma_user_desc="This is an ibma user"
    local user_file="/etc/passwd"

    # not deleted ibma user when uninstalling rpm via "install.sh -u"
    # otherwise degrading to the old version will fail
    # When install.sh is encrypted into binary, it is unreliable to determine
    # whether the upgrade is in progress by the existence of the process.
    # Only during the upgrade, the backup directory will be created before uninstalling the old rpm.
    ps -ef 2>/dev/null | grep -w "install.sh -u" | grep -v grep -q
    if [ $? -eq 0 ] || [ -d "${BMA_DIR}/${DIR_NAME}/log/backup" ]; then
        LOG_INFO "Not need to delete ${ibma_default_user_name} user when iBMA upgrade." "HIDE"
        return 0
    fi

    id "${ibma_default_user_name}" 2>/dev/null | grep "(${ibma_default_user_name})" -q
    if [ $? -ne 0 ]; then
        LOG_INFO "${ibma_default_user_name} user not exists." "HIDE"
        return 0
    fi

    # Check if the ibma user was created by iBMA
    cat "${user_file}" |grep -w "${ibma_user_desc}" -q
    if [ $? -ne 0 ]; then
        LOG_INFO "${ibma_default_user_name} user already exists, but it was not created by iBMA." "HIDE"
        return 0
    fi

    # Delete ibma user
    ret=$(userdel -r "${ibma_default_user_name}" 2>&1)
    if [ $? -ne 0 ]; then
        LOG_ERROR "Failed to delete ${ibma_default_user_name} user."
        LOG_ERROR "Error info:${ret}"
        return 1
    fi

    LOG_INFO "Delete ${ibma_default_user_name} user successfully." "HIDE"
    return 0
}

#*****************************************************************************
# Prototype    : del_real_log_path
# Description  : Delete the real log path.
# Parameter:
#   input:  NA.
#   output: NA
# Return Value : NA
#
#  History        :
#  1.Date         : 2019/07/19
#    Modification : Created function
#
#*****************************************************************************
function del_real_log_path()
{
    local log_path="${BMA_DIR}/${DIR_NAME}/log"
    local real_path=$(realpath ${log_path})
    if [ "${real_path}" != "${log_path}" ]; then
        [ -d "${real_path}" ] && rm -rf ${real_path}
    fi
}

# check service.
stop_ibma_service

# remove link file /usr/bin/ibmacli
rm -f "${IBMACLI_LINK_PATH}"

# remove the real log path 
del_real_log_path

# remove iBMA dir, and try to remove installation path.
remove_ibma_files

if [ -d "${BMA_DIR}/${DIR_NAME}/config/socket_crt" ]; then
    rm -rf "${BMA_DIR}/${DIR_NAME}/config/socket_crt"
fi

if [ -d "${BMA_DIR}/${DIR_NAME}/config/https_crt" ]; then
    rm -rf "${BMA_DIR}/${DIR_NAME}/config/https_crt"
fi

if [ -d "${BMA_DIR}/${DIR_NAME}/config/socket_crt" ]; then
    rm -rf "${BMA_DIR}/${DIR_NAME}/config/socket_crt"
fi

if [ -d "${BMA_DIR}/${DIR_NAME}/config/https_crt" ]; then
    rm -rf "${BMA_DIR}/${DIR_NAME}/config/https_crt"
fi

# delete ibma user if it was created by install script before uninstall rpm
# not delete ibma user when upgrade rpm, upgrade:$1=1, uninstall:$1=0
if [ "1" != "$1" ]; then
    del_default_user
fi

# log uninstall successfully.
LOG_INFO "${SERVICE_NAME} uninstalled successfully."

exit 0
