/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query.maker;

import com.alibaba.druid.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.join.aggregations.ChildrenAggregationBuilder;
import org.elasticsearch.join.aggregations.JoinAggregationBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregatorBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ExtendedStatsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.PercentileRanksAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ScriptedMetricAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.StatsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketSelectorPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.MovFnPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ChildrenType;
import org.nlpcn.es4sql.parse.NestedType;
import org.nlpcn.es4sql.query.maker.QueryMaker;

public class AggMaker {
    private Map<String, KVValue> groupMap = new HashMap<String, KVValue>();
    private static final String TIME_FARMAT = "yyyy-MM-dd HH:mm:ss";

    public AggregationBuilder makeGroupAgg(Field field, Select select) throws SqlParseException {
        MethodField methodField;
        AggregationBuilder aggsBuilder = null;
        if (field instanceof MethodField && field.getName().equals("script")) {
            methodField = (MethodField)field;
            TermsAggregationBuilder termsBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)methodField.getAlias()).script(new Script(methodField.getParams().get((int)1).value.toString()));
            this.groupMap.put(methodField.getAlias(), new KVValue("KEY", termsBuilder));
            aggsBuilder = termsBuilder;
        } else if (field instanceof MethodField) {
            methodField = (MethodField)field;
            if (methodField.getName().equals("filter")) {
                Map<String, Object> paramsAsMap = methodField.getParamsAsMap();
                Where where = (Where)paramsAsMap.get("where");
                return AggregationBuilders.filter((String)paramsAsMap.get("alias").toString(), (QueryBuilder)QueryMaker.explan(where));
            }
            if ("filters".equals(methodField.getName())) {
                Map<String, Object> paramsAsMap = methodField.getParamsAsMap();
                ArrayList<FiltersAggregator.KeyedFilter> filters = new ArrayList<FiltersAggregator.KeyedFilter>();
                List filterFields = (List)paramsAsMap.get("filters");
                for (Field f : filterFields) {
                    Map<String, Object> params = ((MethodField)f).getParamsAsMap();
                    filters.add(new FiltersAggregator.KeyedFilter(params.get("alias").toString(), (QueryBuilder)QueryMaker.explan((Where)params.get("where"))));
                }
                FiltersAggregationBuilder filtersAggBuilder = AggregationBuilders.filters((String)paramsAsMap.get("alias").toString(), (FiltersAggregator.KeyedFilter[])filters.toArray(new FiltersAggregator.KeyedFilter[0]));
                Object otherBucketKey = paramsAsMap.get("otherBucketKey");
                if (Objects.nonNull(otherBucketKey)) {
                    filtersAggBuilder.otherBucketKey(otherBucketKey.toString());
                }
                return filtersAggBuilder;
            }
            aggsBuilder = this.makeRangeGroup(methodField);
        } else {
            TermsAggregationBuilder termsBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)field.getName()).field(field.getName());
            this.groupMap.put(field.getName(), new KVValue("KEY", termsBuilder));
            aggsBuilder = termsBuilder;
        }
        String having = select.getHaving();
        if (!StringUtils.isEmpty((String)having)) {
            String kvRegex = "\\s*(?<key>[^><=!\\s&|]+)\\s*(?<oprator>>=|>|<=|<|==|!=)\\s*(?<value>[^><=!\\s&|]+)\\s*";
            ArrayList<String> havingFields = new ArrayList<String>();
            Pattern pattern = Pattern.compile(kvRegex);
            Matcher matcher = pattern.matcher(having);
            while (matcher.find()) {
                havingFields.add(matcher.group("key"));
            }
            HashMap<String, String> bucketsPathsMap = new HashMap<String, String>();
            for (String key : havingFields) {
                bucketsPathsMap.put(key, key);
                having = having.replace(key, "params." + key);
            }
            having = having.replace("AND", "&&").replace("OR", "||").replace("\\n", " ");
            Script script = new Script(having);
            BucketSelectorPipelineAggregationBuilder bs = PipelineAggregatorBuilders.bucketSelector((String)"having", bucketsPathsMap, (Script)script);
            aggsBuilder.subAggregation((PipelineAggregationBuilder)bs);
        }
        return aggsBuilder;
    }

    public MovFnPipelineAggregationBuilder makeMovingFieldAgg(MethodField field, AggregationBuilder parent) throws SqlParseException {
        this.groupMap.put(field.getAlias(), new KVValue("FIELD", parent));
        String bucketPath = field.getParams().get((int)0).value.toString();
        int window = Integer.parseInt(field.getParams().get((int)1).value.toString());
        field.setAlias(this.fixAlias(field.getAlias()));
        switch (field.getName().toUpperCase()) {
            case "MOVINGAVG": {
                MovFnPipelineAggregationBuilder mvAvg = PipelineAggregatorBuilders.movingFunction((String)field.getAlias(), (Script)new Script("MovingFunctions.unweightedAvg(values)"), (String)bucketPath, (int)window);
                return mvAvg;
            }
            case "ROLLINGSTD": {
                MovFnPipelineAggregationBuilder stdDev = PipelineAggregatorBuilders.movingFunction((String)field.getAlias(), (Script)new Script("MovingFunctions.stdDev(values, MovingFunctions.unweightedAvg(values))"), (String)bucketPath, (int)window);
                return stdDev;
            }
        }
        return null;
    }

    public AggregationBuilder makeFieldAgg(MethodField field, AggregationBuilder parent) throws SqlParseException {
        this.groupMap.put(field.getAlias(), new KVValue("FIELD", parent));
        field.setAlias(this.fixAlias(field.getAlias()));
        switch (field.getName().toUpperCase()) {
            case "SUM": {
                SumAggregationBuilder builder = AggregationBuilders.sum((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "MAX": {
                MaxAggregationBuilder builder = AggregationBuilders.max((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "MIN": {
                MinAggregationBuilder builder = AggregationBuilders.min((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "AVG": {
                AvgAggregationBuilder builder = AggregationBuilders.avg((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "STATS": {
                StatsAggregationBuilder builder = AggregationBuilders.stats((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "EXTENDED_STATS": {
                ExtendedStatsAggregationBuilder builder = AggregationBuilders.extendedStats((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "PERCENTILES": {
                PercentilesAggregationBuilder builder = AggregationBuilders.percentiles((String)field.getAlias());
                this.addSpecificPercentiles(builder, field.getParams());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "PERCENTILE_RANKS": {
                double[] rankVals = this.getSpecificPercentileRankVals(field.getParams());
                PercentileRanksAggregationBuilder builder = AggregationBuilders.percentileRanks((String)field.getAlias(), (double[])rankVals);
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "TOPHITS": {
                return this.makeTopHitsAgg(field);
            }
            case "SCRIPTED_METRIC": {
                return this.scriptedMetric(field);
            }
            case "COUNT": {
                this.groupMap.put(field.getAlias(), new KVValue("COUNT", parent));
                return this.addFieldToAgg(field, this.makeCountAgg(field));
            }
        }
        throw new SqlParseException("the agg function not to define !");
    }

    private void addSpecificPercentiles(PercentilesAggregationBuilder percentilesBuilder, List<KVValue> params) {
        ArrayList<Double> percentiles = new ArrayList<Double>();
        for (KVValue kValue : params) {
            if (kValue.value.getClass().equals(BigDecimal.class)) {
                BigDecimal percentile = (BigDecimal)kValue.value;
                percentiles.add(percentile.doubleValue());
                continue;
            }
            if (!(kValue.value instanceof Integer)) continue;
            percentiles.add(((Integer)kValue.value).doubleValue());
        }
        if (percentiles.size() > 0) {
            double[] percentilesArr = new double[percentiles.size()];
            int i = 0;
            for (Double percentile : percentiles) {
                percentilesArr[i] = percentile;
                ++i;
            }
            percentilesBuilder.percentiles(percentilesArr);
        }
    }

    private double[] getSpecificPercentileRankVals(List<KVValue> params) {
        ArrayList<Double> rankVals = new ArrayList<Double>();
        for (KVValue kValue : params) {
            if (kValue.value.getClass().equals(BigDecimal.class)) {
                BigDecimal percentile = (BigDecimal)kValue.value;
                rankVals.add(percentile.doubleValue());
                continue;
            }
            if (!(kValue.value instanceof Integer)) continue;
            rankVals.add(((Integer)kValue.value).doubleValue());
        }
        double[] _rankVals = new double[rankVals.size()];
        for (int i = 0; i < rankVals.size(); ++i) {
            _rankVals[i] = (Double)rankVals.get(i);
        }
        return _rankVals;
    }

    private String fixAlias(String alias) {
        return alias.replaceAll("\\[", "(").replaceAll("\\]", ")");
    }

    private AggregationBuilder addFieldToAgg(MethodField field, ValuesSourceAggregationBuilder builder) {
        KVValue kvValue = field.getParams().get(0);
        if (kvValue.key != null && kvValue.key.equals("script")) {
            if (kvValue.value instanceof MethodField) {
                return builder.script(new Script(((MethodField)kvValue.value).getParams().get(1).toString()));
            }
            return builder.script(new Script(kvValue.value.toString()));
        }
        if (kvValue.key != null && kvValue.value.toString().trim().startsWith("def")) {
            return builder.script(new Script(kvValue.value.toString()));
        }
        if (kvValue.key != null && (kvValue.key.equals("nested") || kvValue.key.equals("reverse_nested"))) {
            NestedAggregationBuilder nestedBuilder;
            NestedType nestedType = (NestedType)kvValue.value;
            builder.field(nestedType.field);
            String nestedAggName = nestedType.field + "@NESTED";
            if (nestedType.isReverse()) {
                if (nestedType.path != null && nestedType.path.startsWith("~")) {
                    String realPath = nestedType.path.substring(1);
                    NestedAggregationBuilder nestedBuilder2 = AggregationBuilders.nested((String)nestedAggName, (String)realPath);
                    nestedBuilder2 = nestedBuilder2.subAggregation((AggregationBuilder)builder);
                    return AggregationBuilders.reverseNested((String)(nestedAggName + "_REVERSED")).subAggregation((AggregationBuilder)nestedBuilder2);
                }
                ReverseNestedAggregationBuilder reverseNestedAggregationBuilder = AggregationBuilders.reverseNested((String)nestedAggName);
                if (nestedType.path != null) {
                    reverseNestedAggregationBuilder.path(nestedType.path);
                }
                nestedBuilder = reverseNestedAggregationBuilder;
            } else {
                nestedBuilder = AggregationBuilders.nested((String)nestedAggName, (String)nestedType.path);
            }
            return nestedBuilder.subAggregation((AggregationBuilder)builder);
        }
        if (kvValue.key != null && kvValue.key.equals("children")) {
            ChildrenType childrenType = (ChildrenType)kvValue.value;
            builder.field(childrenType.field);
            String childrenAggName = childrenType.field + "@CHILDREN";
            ChildrenAggregationBuilder childrenBuilder = JoinAggregationBuilders.children((String)childrenAggName, (String)childrenType.childType);
            return childrenBuilder;
        }
        return builder.field(kvValue.toString());
    }

    private AggregationBuilder makeRangeGroup(MethodField field) throws SqlParseException {
        switch (field.getName().toLowerCase()) {
            case "range": {
                return this.rangeBuilder(field);
            }
            case "date_histogram": 
            case "dhg": {
                return this.dateHistogram(field);
            }
            case "date_range": {
                return this.dateRange(field);
            }
            case "month": {
                return this.dateRange(field);
            }
            case "histogram": 
            case "hg": {
                return this.histogram(field);
            }
            case "geohash_grid": {
                return this.geohashGrid(field);
            }
            case "geo_bounds": {
                return this.geoBounds(field);
            }
            case "terms": {
                return this.termsAgg(field);
            }
            case "significant_text": {
                return this.significantTextAgg(field);
            }
        }
        throw new SqlParseException("can define this method " + field);
    }

    private AggregationBuilder geoBounds(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        GeoBoundsAggregationBuilder boundsBuilder = AggregationBuilders.geoBounds((String)aggName);
        String value = null;
        block13: for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "field": {
                    boundsBuilder.field(value);
                    continue block13;
                }
                case "wrap_longitude": {
                    boundsBuilder.wrapLongitude(Boolean.getBoolean(value));
                    continue block13;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block13;
                }
            }
            throw new SqlParseException("geo_bounds err or not define field " + kv.toString());
        }
        return boundsBuilder;
    }

    /*
     * Unable to fully structure code
     */
    private AggregationBuilder termsAgg(MethodField field) throws SqlParseException {
        aggName = this.gettAggNameFromParamsOrAlias(field);
        terms = AggregationBuilders.terms((String)aggName);
        value = null;
        include = null;
        exclude = null;
        block58: for (KVValue kv : field.getParams()) {
            if (kv.value.toString().contains("doc[")) {
                script = kv.value + "; return " + kv.key;
                terms.script(new Script(script));
                continue;
            }
            value = kv.value.toString();
            var9_9 = kv.key.toLowerCase();
            var10_10 = -1;
            switch (var9_9.hashCode()) {
                case 97427706: {
                    if (!var9_9.equals("field")) break;
                    var10_10 = 0;
                    break;
                }
                case 3530753: {
                    if (!var9_9.equals("size")) break;
                    var10_10 = 1;
                    break;
                }
                case -1816624190: {
                    if (!var9_9.equals("shard_size")) break;
                    var10_10 = 2;
                    break;
                }
                case 1767297435: {
                    if (!var9_9.equals("min_doc_count")) break;
                    var10_10 = 3;
                    break;
                }
                case 1069449574: {
                    if (!var9_9.equals("missing")) break;
                    var10_10 = 4;
                    break;
                }
                case 106006350: {
                    if (!var9_9.equals("order")) break;
                    var10_10 = 5;
                    break;
                }
                case 92902992: {
                    if (!var9_9.equals("alias")) break;
                    var10_10 = 6;
                    break;
                }
                case -1048944393: {
                    if (!var9_9.equals("nested")) break;
                    var10_10 = 7;
                    break;
                }
                case -1161467660: {
                    if (!var9_9.equals("reverse_nested")) break;
                    var10_10 = 8;
                    break;
                }
                case 1659526655: {
                    if (!var9_9.equals("children")) break;
                    var10_10 = 9;
                    break;
                }
                case -1470776498: {
                    if (!var9_9.equals("execution_hint")) break;
                    var10_10 = 10;
                    break;
                }
                case 1942574248: {
                    if (!var9_9.equals("include")) break;
                    var10_10 = 11;
                    break;
                }
                case -1321148966: {
                    if (!var9_9.equals("exclude")) break;
                    var10_10 = 12;
                }
            }
            switch (var10_10) {
                case 0: {
                    terms.field(value);
                    break;
                }
                case 1: {
                    terms.size(Integer.parseInt(value));
                    break;
                }
                case 2: {
                    terms.shardSize(Integer.parseInt(value));
                    break;
                }
                case 3: {
                    terms.minDocCount((long)Integer.parseInt(value));
                    break;
                }
                case 4: {
                    terms.missing((Object)value);
                    break;
                }
                case 5: {
                    if ("asc".equalsIgnoreCase(value)) {
                        terms.order(BucketOrder.key((boolean)true));
                        break;
                    }
                    if ("desc".equalsIgnoreCase(value)) {
                        terms.order(BucketOrder.key((boolean)false));
                        break;
                    }
                    orderElements = new ArrayList<BucketOrder>();
                    try {
                        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, value);
                        var13_16 = null;
                        try {
                            currentToken = parser.nextToken();
                            if (currentToken == XContentParser.Token.START_OBJECT) {
                                orderElements.add(InternalOrder.Parser.parseOrderParam((XContentParser)parser));
                            } else if (currentToken == XContentParser.Token.START_ARRAY) {
                                currentToken = parser.nextToken();
                                while (currentToken != XContentParser.Token.END_ARRAY) {
                                    if (currentToken != XContentParser.Token.START_OBJECT) {
                                        throw new ParsingException(parser.getTokenLocation(), "Invalid token in order array", new Object[0]);
                                    }
                                    orderElements.add(InternalOrder.Parser.parseOrderParam((XContentParser)parser));
                                    currentToken = parser.nextToken();
                                }
                            }
                        }
                        catch (Throwable var14_23) {
                            var13_16 = var14_23;
                            throw var14_23;
                        }
                        finally {
                            if (parser != null) {
                                if (var13_16 != null) {
                                    try {
                                        parser.close();
                                    }
                                    catch (Throwable var14_22) {
                                        var13_16.addSuppressed(var14_22);
                                    }
                                } else {
                                    parser.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new SqlParseException("couldn't parse order: " + e.getMessage());
                    }
                    terms.order(orderElements);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: {
                    terms.executionHint(value);
                    break;
                }
                case 11: {
                    try {
                        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, value);
                        var12_14 = null;
                        parser.nextToken();
                        include = IncludeExclude.parseInclude((XContentParser)parser);
                        if (parser == null) continue block58;
                        if (var12_14 == null) ** GOTO lbl158
                        try {
                            parser.close();
                        }
                        catch (Throwable var13_17) {
                            var12_14.addSuppressed(var13_17);
                        }
                        continue block58;
lbl158:
                        // 1 sources

                        parser.close();
                        ** break;
                        catch (Throwable var13_18) {
                            try {
                                var12_14 = var13_18;
                                throw var13_18;
                            }
                            catch (Throwable var17_26) {
                                if (parser != null) {
                                    if (var12_14 != null) {
                                        try {
                                            parser.close();
                                        }
                                        catch (Throwable var18_27) {
                                            var12_14.addSuppressed(var18_27);
                                        }
                                    } else {
                                        parser.close();
                                    }
                                }
                                throw var17_26;
lbl175:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new SqlParseException("parse include[" + value + "] error: " + e.getMessage());
                    }
                }
                case 12: {
                    try {
                        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, value);
                        var12_14 = null;
                        parser.nextToken();
                        exclude = IncludeExclude.parseExclude((XContentParser)parser);
                        if (parser == null) continue block58;
                        if (var12_14 == null) ** GOTO lbl194
                        try {
                            parser.close();
                        }
                        catch (Throwable var13_19) {
                            var12_14.addSuppressed(var13_19);
                        }
                        continue block58;
lbl194:
                        // 1 sources

                        parser.close();
                        ** break;
                        catch (Throwable var13_20) {
                            try {
                                var12_14 = var13_20;
                                throw var13_20;
                            }
                            catch (Throwable var19_28) {
                                if (parser != null) {
                                    if (var12_14 != null) {
                                        try {
                                            parser.close();
                                        }
                                        catch (Throwable var20_29) {
                                            var12_14.addSuppressed(var20_29);
                                        }
                                    } else {
                                        parser.close();
                                    }
                                }
                                throw var19_28;
lbl211:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new SqlParseException("parse exclude[" + value + "] error: " + e.getMessage());
                    }
                }
                default: {
                    throw new SqlParseException("terms aggregation err or not define field " + kv.toString());
                }
            }
        }
        terms.includeExclude(IncludeExclude.merge(include, exclude));
        return terms;
    }

    /*
     * Unable to fully structure code
     */
    private AggregationBuilder significantTextAgg(MethodField field) throws SqlParseException {
        aggName = this.gettAggNameFromParamsOrAlias(field);
        significantText = AggregationBuilders.significantText((String)aggName, null);
        include = null;
        exclude = null;
        block41: for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            var9_9 = kv.key.toLowerCase();
            var10_10 = -1;
            switch (var9_9.hashCode()) {
                case 97427706: {
                    if (!var9_9.equals("field")) break;
                    var10_10 = 0;
                    break;
                }
                case 3530753: {
                    if (!var9_9.equals("size")) break;
                    var10_10 = 1;
                    break;
                }
                case -1816624190: {
                    if (!var9_9.equals("shard_size")) break;
                    var10_10 = 2;
                    break;
                }
                case 1767297435: {
                    if (!var9_9.equals("min_doc_count")) break;
                    var10_10 = 3;
                    break;
                }
                case 1942574248: {
                    if (!var9_9.equals("include")) break;
                    var10_10 = 4;
                    break;
                }
                case -1321148966: {
                    if (!var9_9.equals("exclude")) break;
                    var10_10 = 5;
                    break;
                }
                case 92902992: {
                    if (!var9_9.equals("alias")) break;
                    var10_10 = 6;
                    break;
                }
                case -1048944393: {
                    if (!var9_9.equals("nested")) break;
                    var10_10 = 7;
                    break;
                }
                case -1161467660: {
                    if (!var9_9.equals("reverse_nested")) break;
                    var10_10 = 8;
                    break;
                }
                case 1659526655: {
                    if (!var9_9.equals("children")) break;
                    var10_10 = 9;
                }
            }
            switch (var10_10) {
                case 0: {
                    significantText.fieldName(value);
                    break;
                }
                case 1: {
                    significantText.size(Integer.parseInt(value));
                    break;
                }
                case 2: {
                    significantText.shardSize(Integer.parseInt(value));
                    break;
                }
                case 3: {
                    significantText.minDocCount((long)Integer.parseInt(value));
                    break;
                }
                case 4: {
                    try {
                        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, value);
                        var12_14 = null;
                        parser.nextToken();
                        include = IncludeExclude.parseInclude((XContentParser)parser);
                        if (parser == null) continue block41;
                        if (var12_14 == null) ** GOTO lbl82
                        try {
                            parser.close();
                        }
                        catch (Throwable var13_16) {
                            var12_14.addSuppressed(var13_16);
                        }
                        continue block41;
lbl82:
                        // 1 sources

                        parser.close();
                        ** break;
                        catch (Throwable var13_17) {
                            try {
                                var12_14 = var13_17;
                                throw var13_17;
                            }
                            catch (Throwable var14_20) {
                                if (parser != null) {
                                    if (var12_14 != null) {
                                        try {
                                            parser.close();
                                        }
                                        catch (Throwable var15_21) {
                                            var12_14.addSuppressed(var15_21);
                                        }
                                    } else {
                                        parser.close();
                                    }
                                }
                                throw var14_20;
lbl99:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new SqlParseException("parse include[" + value + "] error: " + e.getMessage());
                    }
                }
                case 5: {
                    try {
                        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, value);
                        var12_14 = null;
                        parser.nextToken();
                        exclude = IncludeExclude.parseExclude((XContentParser)parser);
                        if (parser == null) continue block41;
                        if (var12_14 == null) ** GOTO lbl118
                        try {
                            parser.close();
                        }
                        catch (Throwable var13_18) {
                            var12_14.addSuppressed(var13_18);
                        }
                        continue block41;
lbl118:
                        // 1 sources

                        parser.close();
                        ** break;
                        catch (Throwable var13_19) {
                            try {
                                var12_14 = var13_19;
                                throw var13_19;
                            }
                            catch (Throwable var16_22) {
                                if (parser != null) {
                                    if (var12_14 != null) {
                                        try {
                                            parser.close();
                                        }
                                        catch (Throwable var17_23) {
                                            var12_14.addSuppressed(var17_23);
                                        }
                                    } else {
                                        parser.close();
                                    }
                                }
                                throw var16_22;
lbl135:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new SqlParseException("parse exclude[" + value + "] error: " + e.getMessage());
                    }
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    throw new SqlParseException("significant_text aggregation err or not define field " + kv.toString());
                }
            }
        }
        significantText.includeExclude(IncludeExclude.merge(include, exclude));
        return significantText;
    }

    private AbstractAggregationBuilder scriptedMetric(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        ScriptedMetricAggregationBuilder scriptedMetricBuilder = AggregationBuilders.scriptedMetric((String)aggName);
        Map<String, Object> scriptedMetricParams = field.getParamsAsMap();
        if (!(scriptedMetricParams.containsKey("map_script") || scriptedMetricParams.containsKey("map_script_id") || scriptedMetricParams.containsKey("map_script_file"))) {
            throw new SqlParseException("scripted metric parameters must contain map_script/map_script_id/map_script_file parameter");
        }
        HashMap<String, Object> scriptAdditionalParams = new HashMap<String, Object>();
        HashMap<String, Object> reduceScriptAdditionalParams = new HashMap<String, Object>();
        block25: for (Map.Entry<String, Object> param : scriptedMetricParams.entrySet()) {
            String paramValue = param.getValue().toString();
            if (param.getKey().startsWith("@")) {
                if (param.getKey().startsWith("@reduce_")) {
                    reduceScriptAdditionalParams.put(param.getKey().replace("@reduce_", ""), param.getValue());
                    continue;
                }
                scriptAdditionalParams.put(param.getKey().replace("@", ""), param.getValue());
                continue;
            }
            switch (param.getKey().toLowerCase()) {
                case "map_script": {
                    scriptedMetricBuilder.mapScript(new Script(paramValue));
                    continue block25;
                }
                case "map_script_id": {
                    scriptedMetricBuilder.mapScript(new Script(ScriptType.STORED, "painless", paramValue, new HashMap()));
                    continue block25;
                }
                case "init_script": {
                    scriptedMetricBuilder.initScript(new Script(paramValue));
                    continue block25;
                }
                case "init_script_id": {
                    scriptedMetricBuilder.initScript(new Script(ScriptType.STORED, "painless", paramValue, new HashMap()));
                    continue block25;
                }
                case "combine_script": {
                    scriptedMetricBuilder.combineScript(new Script(paramValue));
                    continue block25;
                }
                case "combine_script_id": {
                    scriptedMetricBuilder.combineScript(new Script(ScriptType.STORED, "painless", paramValue, new HashMap()));
                    continue block25;
                }
                case "reduce_script": {
                    scriptedMetricBuilder.reduceScript(new Script(ScriptType.INLINE, "painless", paramValue, reduceScriptAdditionalParams));
                    continue block25;
                }
                case "reduce_script_id": {
                    scriptedMetricBuilder.reduceScript(new Script(ScriptType.STORED, "painless", paramValue, reduceScriptAdditionalParams));
                    continue block25;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block25;
                }
            }
            throw new SqlParseException("scripted_metric err or not define field " + param.getKey());
        }
        if (scriptAdditionalParams.size() > 0) {
            scriptAdditionalParams.put("_agg", new HashMap());
            scriptedMetricBuilder.params(scriptAdditionalParams);
        }
        return scriptedMetricBuilder;
    }

    private AggregationBuilder geohashGrid(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        GeoHashGridAggregationBuilder geoHashGrid = AggregationBuilders.geohashGrid((String)aggName);
        String value = null;
        block17: for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "precision": {
                    geoHashGrid.precision(Integer.parseInt(value));
                    continue block17;
                }
                case "field": {
                    geoHashGrid.field(value);
                    continue block17;
                }
                case "size": {
                    geoHashGrid.size(Integer.parseInt(value));
                    continue block17;
                }
                case "shard_size": {
                    geoHashGrid.shardSize(Integer.parseInt(value));
                    continue block17;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block17;
                }
            }
            throw new SqlParseException("geohash grid err or not define field " + kv.toString());
        }
        return geoHashGrid;
    }

    private ValuesSourceAggregationBuilder dateRange(MethodField field) {
        String alias = this.gettAggNameFromParamsOrAlias(field);
        DateRangeAggregationBuilder dateRange = (DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)alias).format(TIME_FARMAT);
        String value = null;
        ArrayList<String> ranges = new ArrayList<String>();
        for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            if ("field".equals(kv.key)) {
                dateRange.field(value);
                continue;
            }
            if ("format".equals(kv.key)) {
                dateRange.format(value);
                continue;
            }
            if ("time_zone".equals(kv.key)) {
                dateRange.timeZone((ZoneId)ZoneOffset.of(value));
                continue;
            }
            if ("from".equals(kv.key)) {
                dateRange.addUnboundedFrom(kv.value.toString());
                continue;
            }
            if ("to".equals(kv.key)) {
                dateRange.addUnboundedTo(kv.value.toString());
                continue;
            }
            if ("alias".equals(kv.key) || "nested".equals(kv.key) || "children".equals(kv.key)) continue;
            ranges.add(value);
        }
        for (int i = 1; i < ranges.size(); ++i) {
            dateRange.addRange((String)ranges.get(i - 1), (String)ranges.get(i));
        }
        return dateRange;
    }

    /*
     * Unable to fully structure code
     */
    private DateHistogramAggregationBuilder dateHistogram(MethodField field) throws SqlParseException {
        alias = this.gettAggNameFromParamsOrAlias(field);
        dateHistogram = (DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)alias).format("yyyy-MM-dd HH:mm:ss");
        value = null;
        block40: for (KVValue kv : field.getParams()) {
            if (kv.value.toString().contains("doc[")) {
                script = kv.value + "; return " + kv.key;
                dateHistogram.script(new Script(script));
                continue;
            }
            value = kv.value.toString();
            var7_7 = kv.key.toLowerCase();
            var8_8 = -1;
            switch (var7_7.hashCode()) {
                case 570418373: {
                    if (!var7_7.equals("interval")) break;
                    var8_8 = 0;
                    break;
                }
                case -2022055770: {
                    if (!var7_7.equals("calendar_interval")) break;
                    var8_8 = 1;
                    break;
                }
                case -1078898384: {
                    if (!var7_7.equals("fixed_interval")) break;
                    var8_8 = 2;
                    break;
                }
                case 97427706: {
                    if (!var7_7.equals("field")) break;
                    var8_8 = 3;
                    break;
                }
                case -1268779017: {
                    if (!var7_7.equals("format")) break;
                    var8_8 = 4;
                    break;
                }
                case 36848094: {
                    if (!var7_7.equals("time_zone")) break;
                    var8_8 = 5;
                    break;
                }
                case 1767297435: {
                    if (!var7_7.equals("min_doc_count")) break;
                    var8_8 = 6;
                    break;
                }
                case 106006350: {
                    if (!var7_7.equals("order")) break;
                    var8_8 = 7;
                    break;
                }
                case 954524795: {
                    if (!var7_7.equals("extended_bounds")) break;
                    var8_8 = 8;
                    break;
                }
                case -1019779949: {
                    if (!var7_7.equals("offset")) break;
                    var8_8 = 9;
                    break;
                }
                case 92902992: {
                    if (!var7_7.equals("alias")) break;
                    var8_8 = 10;
                    break;
                }
                case -1048944393: {
                    if (!var7_7.equals("nested")) break;
                    var8_8 = 11;
                    break;
                }
                case -1161467660: {
                    if (!var7_7.equals("reverse_nested")) break;
                    var8_8 = 12;
                    break;
                }
                case 1659526655: {
                    if (!var7_7.equals("children")) break;
                    var8_8 = 13;
                }
            }
            switch (var8_8) {
                case 0: {
                    dateHistogram.dateHistogramInterval(new DateHistogramInterval(kv.value.toString()));
                    continue block40;
                }
                case 1: {
                    dateHistogram.calendarInterval(new DateHistogramInterval(kv.value.toString()));
                    continue block40;
                }
                case 2: {
                    dateHistogram.fixedInterval(new DateHistogramInterval(kv.value.toString()));
                    continue block40;
                }
                case 3: {
                    dateHistogram.field(value);
                    continue block40;
                }
                case 4: {
                    dateHistogram.format(value);
                    continue block40;
                }
                case 5: {
                    dateHistogram.timeZone((ZoneId)ZoneOffset.of(value));
                    continue block40;
                }
                case 6: {
                    dateHistogram.minDocCount(Long.parseLong(value));
                    continue block40;
                }
                case 7: {
                    dateHistogram.order("desc".equalsIgnoreCase(value) != false ? BucketOrder.key((boolean)false) : BucketOrder.key((boolean)true));
                    continue block40;
                }
                case 8: {
                    extendedBounds = null;
                    try {
                        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, value);
                        var11_12 = null;
                        try {
                            extendedBounds = (LongBounds)LongBounds.PARSER.parse(parser, null);
                        }
                        catch (Throwable var12_14) {
                            var11_12 = var12_14;
                            throw var12_14;
                        }
                        finally {
                            if (parser != null) {
                                if (var11_12 != null) {
                                    try {
                                        parser.close();
                                    }
                                    catch (Throwable var12_13) {
                                        var11_12.addSuppressed(var12_13);
                                    }
                                } else {
                                    parser.close();
                                }
                            }
                        }
                    }
                    catch (IOException ex) {
                        indexList = new LinkedList<Integer>();
                        index = -1;
                        while ((index = value.indexOf(58, index + 1)) != -1) {
                            indexList.add(index);
                        }
                        if (indexList.isEmpty()) ** GOTO lbl134
                        index = (Integer)indexList.get(indexList.size() / 2);
                        extendedBounds = new LongBounds(value.substring(0, index), value.substring(index + 1));
                    }
lbl134:
                    // 3 sources

                    if (extendedBounds == null) continue block40;
                    dateHistogram.extendedBounds(extendedBounds);
                    continue block40;
                }
                case 9: {
                    dateHistogram.offset(value);
                    continue block40;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    continue block40;
                }
            }
            throw new SqlParseException("date range err or not define field " + kv.toString());
        }
        return dateHistogram;
    }

    private String gettAggNameFromParamsOrAlias(MethodField field) {
        String alias = field.getAlias();
        for (KVValue kv : field.getParams()) {
            if (kv.key == null || !kv.key.equals("alias")) continue;
            alias = kv.value.toString();
        }
        return alias;
    }

    private HistogramAggregationBuilder histogram(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        HistogramAggregationBuilder histogram = AggregationBuilders.histogram((String)aggName);
        String value = null;
        block30: for (KVValue kv : field.getParams()) {
            if (kv.value.toString().contains("doc[")) {
                String script = kv.value + "; return " + kv.key;
                histogram.script(new Script(script));
                continue;
            }
            value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "interval": {
                    histogram.interval((double)Long.parseLong(value.replace("'", "")));
                    continue block30;
                }
                case "field": {
                    histogram.field(value);
                    continue block30;
                }
                case "min_doc_count": {
                    histogram.minDocCount(Long.parseLong(value));
                    continue block30;
                }
                case "extended_bounds": {
                    String[] bounds = value.split(":");
                    if (bounds.length != 2) continue block30;
                    histogram.extendedBounds(Double.parseDouble(bounds[0]), Double.parseDouble(bounds[1]));
                    continue block30;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block30;
                }
                case "order": {
                    BucketOrder order = null;
                    switch (value) {
                        case "key_desc": {
                            order = BucketOrder.key((boolean)false);
                            break;
                        }
                        case "count_asc": {
                            order = BucketOrder.count((boolean)true);
                            break;
                        }
                        case "count_desc": {
                            order = BucketOrder.count((boolean)false);
                            break;
                        }
                        default: {
                            order = BucketOrder.key((boolean)true);
                        }
                    }
                    histogram.order(order);
                    continue block30;
                }
            }
            throw new SqlParseException("histogram err or not define field " + kv.toString());
        }
        return histogram;
    }

    private RangeAggregationBuilder rangeBuilder(MethodField field) {
        LinkedList params = field.getParams().stream().filter(kv -> !"alias".equals(kv.key)).collect(Collectors.toCollection(LinkedList::new));
        KVValue param = (KVValue)Objects.requireNonNull(params.poll());
        String fieldName = param.value instanceof NestedType ? ((NestedType)param.value).field : param.toString();
        double[] ds = Util.KV2DoubleArr(params);
        RangeAggregationBuilder range = (RangeAggregationBuilder)AggregationBuilders.range((String)field.getAlias()).field(fieldName);
        for (int i = 1; i < ds.length; ++i) {
            range.addRange(ds[i - 1], ds[i]);
        }
        return range;
    }

    private ValuesSourceAggregationBuilder makeCountAgg(MethodField field) {
        if ("DISTINCT".equals(field.getOption())) {
            if (field.getParams().size() == 1) {
                String fieldValue = field.getParams().get((int)0).value.toString();
                if (fieldValue.contains("def") && fieldValue.contains("return") || fieldValue.contains("doc[")) {
                    return AggregationBuilders.cardinality((String)field.getAlias());
                }
                return AggregationBuilders.cardinality((String)field.getAlias()).field(field.getParams().get((int)0).value.toString());
            }
            Integer precision_threshold = (Integer)field.getParams().get((int)1).value;
            return AggregationBuilders.cardinality((String)field.getAlias()).precisionThreshold((long)precision_threshold.intValue()).field(field.getParams().get((int)0).value.toString());
        }
        String fieldName = field.getParams().get((int)0).value.toString();
        if ("*".equals(fieldName)) {
            KVValue kvValue = new KVValue(null, "_index");
            field.getParams().set(0, kvValue);
            return AggregationBuilders.count((String)field.getAlias()).field(kvValue.toString());
        }
        String fieldValue = field.getParams().get((int)0).value.toString();
        if (fieldValue.contains("def") && fieldValue.contains("return") || fieldValue.contains("doc[")) {
            return AggregationBuilders.count((String)field.getAlias());
        }
        return AggregationBuilders.count((String)field.getAlias()).field(fieldName);
    }

    private AbstractAggregationBuilder makeTopHitsAgg(MethodField field) {
        String alias = this.gettAggNameFromParamsOrAlias(field);
        TopHitsAggregationBuilder topHits = AggregationBuilders.topHits((String)alias);
        List<KVValue> params = field.getParams();
        String[] include = null;
        String[] exclude = null;
        block17: for (KVValue kv : params) {
            switch (kv.key) {
                case "from": {
                    topHits.from(((Integer)kv.value).intValue());
                    continue block17;
                }
                case "size": {
                    topHits.size(((Integer)kv.value).intValue());
                    continue block17;
                }
                case "include": {
                    include = kv.value.toString().split(",");
                    continue block17;
                }
                case "exclude": {
                    exclude = kv.value.toString().split(",");
                    continue block17;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block17;
                }
            }
            topHits.sort(kv.key, SortOrder.valueOf((String)kv.value.toString().toUpperCase()));
        }
        if (include != null || exclude != null) {
            topHits.fetchSource(include, exclude);
        }
        return topHits;
    }

    public Map<String, KVValue> getGroupMap() {
        return this.groupMap;
    }
}

