/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExtractExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlMatchAgainstExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlUserName;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;
import java.util.List;
import org.nlpcn.es4sql.parse.ElasticLexer;
import org.nlpcn.es4sql.parse.ElasticSqlSelectParser;
import org.nlpcn.es4sql.parse.SQLOdbcExpr;
import org.nlpcn.es4sql.parse.SQLParensIdentifierExpr;

public class ElasticSqlExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public ElasticSqlExprParser(Lexer lexer) {
        super(lexer, "mysql");
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    public ElasticSqlExprParser(String sql) {
        this((Lexer)new ElasticLexer(sql));
        this.lexer.nextToken();
    }

    public void parseHints(List hints) {
        while (this.lexer.token() == Token.HINT) {
            SQLCommentHint hint = new SQLCommentHint(this.lexer.stringVal());
            if (this.lexer.getCommentCount() > 0) {
                hint.addBeforeComment(this.lexer.readAndResetComments());
            }
            hints.add(hint);
            this.lexer.nextToken();
        }
    }

    public SQLExpr primary() {
        if (this.lexer.token() == Token.LBRACE) {
            this.lexer.nextToken();
            boolean foundRBrace = false;
            if (this.lexer.stringVal().equals("ts")) {
                String current = this.lexer.stringVal();
                do {
                    if (current.equals(Token.RBRACE.name())) {
                        foundRBrace = true;
                        break;
                    }
                    this.lexer.nextToken();
                    current = this.lexer.token().name();
                } while (!foundRBrace && !current.trim().equals(""));
                if (foundRBrace) {
                    SQLOdbcExpr sdle = new SQLOdbcExpr(this.lexer.stringVal());
                    this.accept(Token.RBRACE);
                    return sdle;
                }
                throw new ParserException("Error. Unable to find closing RBRACE");
            }
            throw new ParserException("Error. Unable to parse ODBC Literal Timestamp");
        }
        if (this.lexer.token() == Token.LBRACKET) {
            StringBuilder identifier = new StringBuilder();
            this.lexer.nextToken();
            String prefix = "";
            while (this.lexer.token() != Token.RBRACKET) {
                if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.INDEX && this.lexer.token() != Token.LITERAL_CHARS) {
                    throw new ParserException("All items between Brackets should be identifiers , got:" + this.lexer.token());
                }
                identifier.append(prefix);
                identifier.append(this.lexer.stringVal());
                prefix = " ";
                this.lexer.nextToken();
            }
            this.accept(Token.RBRACKET);
            return new SQLIdentifierExpr(identifier.toString());
        }
        if (this.lexer.token() == Token.NOT) {
            SQLNotExpr sqlExpr;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EXISTS) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                sqlExpr = new SQLExistsExpr(this.createSelectParser().select(), true);
                this.accept(Token.RPAREN);
            } else {
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLExpr notTarget = this.expr();
                    this.accept(Token.RPAREN);
                    SQLNotExpr sqlExpr2 = new SQLNotExpr(notTarget);
                    return this.primaryRest((SQLExpr)sqlExpr2);
                }
                SQLExpr restExpr = this.relational();
                sqlExpr = new SQLNotExpr(restExpr);
            }
            return sqlExpr;
        }
        boolean parenWrapped = this.lexer.token() == Token.LPAREN;
        Object expr = this.primary2();
        if (parenWrapped && expr instanceof SQLIdentifierExpr) {
            expr = new SQLParensIdentifierExpr((SQLIdentifierExpr)expr);
        }
        return expr;
    }

    public SQLExpr primary2() {
        Token tok = this.lexer.token();
        if (this.lexer.identifierEquals(FnvHash.Constants.OUTFILE)) {
            this.lexer.nextToken();
            SQLExpr file = this.primary();
            MySqlOutFileExpr expr = new MySqlOutFileExpr(file);
            return this.primaryRest((SQLExpr)expr);
        }
        switch (tok) {
            case VARIANT: {
                SQLVariantRefExpr varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                if (varRefExpr.getName().equalsIgnoreCase("@@global")) {
                    this.accept(Token.DOT);
                    varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal(), true);
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                }
                return this.primaryRest((SQLExpr)varRefExpr);
            }
            case VALUES: {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LPAREN) {
                    throw new ParserException("syntax error, illegal values clause. " + this.lexer.info());
                }
                return this.methodRest((SQLExpr)new SQLIdentifierExpr("VALUES"), true);
            }
            case BINARY: {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COMMA || this.lexer.token() == Token.SEMI || this.lexer.token() == Token.EOF) {
                    return new SQLIdentifierExpr("BINARY");
                }
                SQLUnaryExpr binaryExpr = new SQLUnaryExpr(SQLUnaryOperator.BINARY, this.expr());
                return this.primaryRest((SQLExpr)binaryExpr);
            }
        }
        return super.primary();
    }

    public final SQLExpr primaryRest(SQLExpr expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                String ident = identExpr.getName();
                if (ident.equalsIgnoreCase("x")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr = new SQLHexExpr(charValue);
                    return this.primaryRest(expr);
                }
                if (ident.startsWith("_")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    MySqlCharExpr mysqlCharExpr = new MySqlCharExpr(charValue);
                    mysqlCharExpr.setCharset(identExpr.getName());
                    if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                        this.lexer.nextToken();
                        String collate = this.lexer.stringVal();
                        mysqlCharExpr.setCollate(collate);
                        this.accept(Token.IDENTIFIER);
                    }
                    expr = mysqlCharExpr;
                    return this.primaryRest(expr);
                }
            } else if (expr instanceof SQLCharExpr) {
                String text2 = ((SQLCharExpr)expr).getText();
                do {
                    String chars = this.lexer.stringVal();
                    text2 = text2 + chars;
                    this.lexer.nextToken();
                } while (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS);
                expr = new SQLCharExpr(text2);
            } else if (expr instanceof SQLVariantRefExpr) {
                SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("CONCAT");
                concat.addArgument(expr);
                concat.addArgument(this.primary());
                expr = concat;
                return this.primaryRest(expr);
            }
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            if (expr instanceof SQLHexExpr) {
                if ("USING".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("syntax error, illegal hex. " + this.lexer.info());
                    }
                    String charSet = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr.getAttributes().put("USING", charSet);
                    return this.primaryRest(expr);
                }
            } else {
                if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.EQ) {
                        this.lexer.nextToken();
                    }
                    if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.LITERAL_CHARS) {
                        throw new ParserException("syntax error. " + this.lexer.info());
                    }
                    String collate = this.lexer.stringVal();
                    this.lexer.nextToken();
                    SQLBinaryOpExpr binaryExpr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.COLLATE, (SQLExpr)new SQLIdentifierExpr(collate), "mysql");
                    expr = binaryExpr;
                    return this.primaryRest(expr);
                }
                if (expr instanceof SQLVariantRefExpr && this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.LITERAL_CHARS) {
                        throw new ParserException("syntax error. " + this.lexer.info());
                    }
                    String collate = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr.putAttribute("COLLATE", (Object)collate);
                    return this.primaryRest(expr);
                }
            }
        }
        if (this.lexer.token() == Token.VARIANT && "@".equals(this.lexer.stringVal())) {
            return this.userNameRest(expr);
        }
        if (expr instanceof SQLMethodInvokeExpr && this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            expr = this.bracketRest(expr);
            return this.primaryRest(expr);
        }
        if (this.lexer.token() == Token.ERROR) {
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        return super.primaryRest(expr);
    }

    protected SQLExpr bracketRest(SQLExpr expr) {
        if (this.lexer.token() != Token.LITERAL_INT) {
            throw new ParserException("error : " + this.lexer.stringVal());
        }
        Number index = this.lexer.integerValue();
        this.lexer.nextToken();
        if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)expr;
            methodInvokeExpr.getParameters().add(new SQLIntegerExpr(index));
        }
        this.lexer.nextToken();
        expr = this.primaryRest(expr);
        return expr;
    }

    public SQLName userName() {
        SQLName name = this.name();
        if (this.lexer.token() == Token.LPAREN && name.hashCode64() == FnvHash.Constants.CURRENT_USER) {
            this.lexer.nextToken();
            this.accept(Token.RPAREN);
            return name;
        }
        return (SQLName)this.userNameRest((SQLExpr)name);
    }

    private SQLExpr userNameRest(SQLExpr expr) {
        if (this.lexer.token() != Token.VARIANT || !this.lexer.stringVal().startsWith("@")) {
            return expr;
        }
        MySqlUserName userName = new MySqlUserName();
        if (expr instanceof SQLCharExpr) {
            userName.setUserName(((SQLCharExpr)expr).toString());
        } else {
            userName.setUserName(((SQLIdentifierExpr)expr).getName());
        }
        String strVal = this.lexer.stringVal();
        this.lexer.nextToken();
        if (strVal.length() > 1) {
            userName.setHost(strVal.substring(1));
            return userName;
        }
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            userName.setHost("'" + this.lexer.stringVal() + "'");
        } else {
            userName.setHost(this.lexer.stringVal());
        }
        this.lexer.nextToken();
        if (this.lexer.token() == Token.IDENTIFIED) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.PASSWORD)) {
                    this.lexer.reset(mark);
                } else {
                    userName.setIdentifiedBy(this.lexer.stringVal());
                    this.lexer.nextToken();
                }
            } else {
                this.lexer.reset(mark);
            }
        }
        return userName;
    }

    protected SQLExpr parsePosition() {
        SQLExpr subStr = this.primary();
        this.accept(Token.IN);
        SQLExpr str = this.expr();
        this.accept(Token.RPAREN);
        SQLMethodInvokeExpr locate = new SQLMethodInvokeExpr("LOCATE");
        locate.addParameter(subStr);
        locate.addParameter(str);
        return this.primaryRest((SQLExpr)locate);
    }

    protected SQLExpr parseExtract() {
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        String unitVal = this.lexer.stringVal();
        SQLIntervalUnit unit = SQLIntervalUnit.valueOf((String)unitVal.toUpperCase());
        this.lexer.nextToken();
        this.accept(Token.FROM);
        SQLExpr value = this.expr();
        MySqlExtractExpr extract = new MySqlExtractExpr();
        extract.setValue(value);
        extract.setUnit(unit);
        this.accept(Token.RPAREN);
        MySqlExtractExpr expr = extract;
        return this.primaryRest((SQLExpr)expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SQLExpr parseMatch() {
        MySqlMatchAgainstExpr matchAgainstExpr = new MySqlMatchAgainstExpr();
        if (this.lexer.token() == Token.RPAREN) {
            this.lexer.nextToken();
        } else {
            this.exprList(matchAgainstExpr.getColumns(), (SQLObject)matchAgainstExpr);
            this.accept(Token.RPAREN);
        }
        this.acceptIdentifier("AGAINST");
        this.accept(Token.LPAREN);
        SQLExpr against = this.primary();
        matchAgainstExpr.setAgainst(against);
        if (this.lexer.token() == Token.IN) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.NATURAL)) {
                this.lexer.nextToken();
                this.acceptIdentifier("LANGUAGE");
                this.acceptIdentifier("MODE");
                if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("QUERY");
                    this.acceptIdentifier("EXPANSION");
                    matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_NATURAL_LANGUAGE_MODE_WITH_QUERY_EXPANSION);
                } else {
                    matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_NATURAL_LANGUAGE_MODE);
                }
            } else {
                if (!this.lexer.identifierEquals(FnvHash.Constants.BOOLEAN)) throw new ParserException("syntax error. " + this.lexer.info());
                this.lexer.nextToken();
                this.acceptIdentifier("MODE");
                matchAgainstExpr.setSearchModifier(MySqlMatchAgainstExpr.SearchModifier.IN_BOOLEAN_MODE);
            }
        } else if (this.lexer.token() == Token.WITH) {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        this.accept(Token.RPAREN);
        return this.primaryRest((SQLExpr)matchAgainstExpr);
    }

    public SQLSelectParser createSelectParser() {
        return new ElasticSqlSelectParser(this);
    }

    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("INTERVAL");
            if (this.lexer.token() != Token.RPAREN) {
                this.exprList(methodInvokeExpr.getParameters(), (SQLObject)methodInvokeExpr);
            }
            this.accept(Token.RPAREN);
            if (methodInvokeExpr.getParameters().size() == 1 && this.lexer.token() == Token.IDENTIFIER) {
                SQLExpr value = (SQLExpr)methodInvokeExpr.getParameters().get(0);
                String unit = this.lexer.stringVal();
                this.lexer.nextToken();
                SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
                intervalExpr.setValue(value);
                intervalExpr.setUnit(SQLIntervalUnit.valueOf((String)unit.toUpperCase()));
                return intervalExpr;
            }
            return this.primaryRest((SQLExpr)methodInvokeExpr);
        }
        SQLExpr value = this.expr();
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("Syntax error. " + this.lexer.info());
        }
        String unit = this.lexer.stringVal();
        this.lexer.nextToken();
        SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
        intervalExpr.setValue(value);
        intervalExpr.setUnit(SQLIntervalUnit.valueOf((String)unit.toUpperCase()));
        return intervalExpr;
    }

    public SQLColumnDefinition parseColumn() {
        SQLColumnDefinition column = new SQLColumnDefinition();
        column.setDbType(this.dbType);
        column.setName(this.name());
        column.setDataType(this.parseDataType());
        if (this.lexer.identifierEquals(FnvHash.Constants.GENERATED)) {
            this.lexer.nextToken();
            this.acceptIdentifier("ALWAYS");
            this.accept(Token.AS);
            this.accept(Token.LPAREN);
            SQLExpr expr = this.expr();
            this.accept(Token.RPAREN);
            column.setGeneratedAlawsAs(expr);
        }
        return this.parseColumnRest(column);
    }

    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        MySqlCharExpr charSetCollateExpr;
        SQLExpr expr;
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            expr = this.expr();
            column.setOnUpdate(expr);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            charSetCollateExpr = new MySqlCharExpr();
            charSetCollateExpr.setCharset(this.lexer.stringVal());
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                this.lexer.nextToken();
                charSetCollateExpr.setCollate(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            column.setCharsetExpr((SQLExpr)charSetCollateExpr);
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CHARSET)) {
            this.lexer.nextToken();
            charSetCollateExpr = new MySqlCharExpr();
            charSetCollateExpr.setCharset(this.lexer.stringVal());
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                this.lexer.nextToken();
                charSetCollateExpr.setCollate(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            column.setCharsetExpr((SQLExpr)charSetCollateExpr);
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.AUTO_INCREMENT)) {
            this.lexer.nextToken();
            column.setAutoIncrement(true);
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PRECISION) && column.getDataType().nameHashCode64() == FnvHash.Constants.DOUBLE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.PARTITION) {
            throw new ParserException("syntax error " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORAGE)) {
            this.lexer.nextToken();
            expr = this.expr();
            column.setStorage(expr);
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            expr = this.expr();
            column.setAsExpr(expr);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            column.setStored(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.VIRTUAL)) {
            this.lexer.nextToken();
            column.setVirtual(true);
        }
        super.parseColumnRest(column);
        return column;
    }

    protected SQLDataType parseDataTypeRest(SQLDataType dataType) {
        super.parseDataTypeRest(dataType);
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.UNSIGNED)) {
                this.lexer.nextToken();
                ((SQLDataTypeImpl)dataType).setUnsigned(true);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.ZEROFILL)) break;
            this.lexer.nextToken();
            ((SQLDataTypeImpl)dataType).setZerofill(true);
        }
        return dataType;
    }

    public SQLAssignItem parseAssignItem() {
        SQLAssignItem item = new SQLAssignItem();
        SQLExpr var = this.primary();
        String ident = null;
        long identHash = 0L;
        if (var instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)var;
            ident = identExpr.getName();
            identHash = identExpr.hashCode64();
            if (identHash == FnvHash.Constants.GLOBAL) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, true);
            } else if (identHash == FnvHash.Constants.SESSION) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, false, true);
            } else {
                var = new SQLVariantRefExpr(ident);
            }
        }
        if (identHash == FnvHash.Constants.NAMES) {
            String charset = this.lexer.stringVal();
            SQLVariantRefExpr varExpr = null;
            boolean chars = false;
            Token token = this.lexer.token();
            if (token == Token.IDENTIFIER) {
                this.lexer.nextToken();
            } else if (token == Token.DEFAULT) {
                charset = "DEFAULT";
                this.lexer.nextToken();
            } else if (token == Token.QUES) {
                varExpr = new SQLVariantRefExpr("?");
                this.lexer.nextToken();
            } else {
                chars = true;
                this.accept(Token.LITERAL_CHARS);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                MySqlCharExpr charsetExpr = new MySqlCharExpr(charset);
                this.lexer.nextToken();
                String collate = this.lexer.stringVal();
                this.lexer.nextToken();
                charsetExpr.setCollate(collate);
                item.setValue((SQLExpr)charsetExpr);
            } else if (varExpr != null) {
                item.setValue((SQLExpr)varExpr);
            } else {
                item.setValue((SQLExpr)(chars ? new SQLCharExpr(charset) : new SQLIdentifierExpr(charset)));
            }
            item.setTarget(var);
            return item;
        }
        if (identHash == FnvHash.Constants.CHARACTER) {
            var = new SQLIdentifierExpr("CHARACTER SET");
            this.accept(Token.SET);
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
        } else if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.EQ);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            item.setValue((SQLExpr)new SQLIdentifierExpr("ON"));
        } else {
            item.setValue(this.expr());
        }
        item.setTarget(var);
        return item;
    }

    public SQLName nameRest(SQLName name) {
        if (this.lexer.token() == Token.VARIANT && "@".equals(this.lexer.stringVal())) {
            this.lexer.nextToken();
            MySqlUserName userName = new MySqlUserName();
            userName.setUserName(((SQLIdentifierExpr)name).getName());
            if (this.lexer.token() == Token.LITERAL_CHARS) {
                userName.setHost("'" + this.lexer.stringVal() + "'");
            } else {
                userName.setHost(this.lexer.stringVal());
            }
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IDENTIFIED) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                userName.setIdentifiedBy(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            return userName;
        }
        return super.nameRest(name);
    }

    public MySqlPrimaryKey parsePrimaryKey() {
        this.accept(Token.PRIMARY);
        this.accept(Token.KEY);
        MySqlPrimaryKey primaryKey = new MySqlPrimaryKey();
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            primaryKey.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() != Token.LPAREN) {
            SQLName name = this.name();
            primaryKey.setName(name);
        }
        this.accept(Token.LPAREN);
        while (true) {
            Object expr = this.lexer.token() == Token.LITERAL_ALIAS ? this.name() : this.expr();
            primaryKey.addColumn((SQLExpr)expr);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            primaryKey.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        return primaryKey;
    }

    public MySqlUnique parseUnique() {
        this.accept(Token.UNIQUE);
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
        }
        MySqlUnique unique = new MySqlUnique();
        if (this.lexer.token() != Token.LPAREN) {
            SQLName indexName = this.name();
            unique.setName(indexName);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            unique.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        this.accept(Token.LPAREN);
        while (true) {
            SQLExpr column = this.expr();
            if (this.lexer.token() == Token.ASC) {
                column = new MySqlOrderingExpr(column, SQLOrderingSpecification.ASC);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DESC) {
                column = new MySqlOrderingExpr(column, SQLOrderingSpecification.DESC);
                this.lexer.nextToken();
            }
            unique.addColumn(column);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            unique.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.KEY_BLOCK_SIZE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr value = this.primary();
            unique.setKeyBlockSize(value);
        }
        return unique;
    }

    public MysqlForeignKey parseForeignKey() {
        this.accept(Token.FOREIGN);
        this.accept(Token.KEY);
        MysqlForeignKey fk = new MysqlForeignKey();
        if (this.lexer.token() != Token.LPAREN) {
            SQLName indexName = this.name();
            fk.setIndexName(indexName);
        }
        this.accept(Token.LPAREN);
        this.names(fk.getReferencingColumns(), (SQLObject)fk);
        this.accept(Token.RPAREN);
        this.accept(Token.REFERENCES);
        fk.setReferencedTableName(this.name());
        this.accept(Token.LPAREN);
        this.names(fk.getReferencedColumns());
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals(FnvHash.Constants.MATCH)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("FULL") || this.lexer.token() == Token.FULL) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.FULL);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PARTIAL)) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.PARTIAL);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.SIMPLE)) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.SIMPLE);
                this.lexer.nextToken();
            } else {
                throw new ParserException("TODO : " + this.lexer.info());
            }
        }
        while (this.lexer.token() == Token.ON) {
            SQLForeignKeyImpl.Option option;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DELETE) {
                this.lexer.nextToken();
                option = this.parseReferenceOption();
                fk.setOnDelete(option);
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                this.lexer.nextToken();
                option = this.parseReferenceOption();
                fk.setOnUpdate(option);
                continue;
            }
            throw new ParserException("syntax error, expect DELETE or UPDATE, actual " + this.lexer.token() + " " + this.lexer.info());
        }
        return fk;
    }

    protected SQLAggregateExpr parseAggregateExprRest(SQLAggregateExpr aggregateExpr) {
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.parseOrderBy();
            aggregateExpr.putAttribute("ORDER BY", (Object)orderBy);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SEPARATOR)) {
            this.lexer.nextToken();
            SQLExpr seperator = this.primary();
            seperator.setParent((SQLObject)aggregateExpr);
            aggregateExpr.putAttribute("SEPARATOR", (Object)seperator);
        }
        return aggregateExpr;
    }

    public MySqlOrderingExpr parseSelectGroupByItem() {
        MySqlOrderingExpr item = new MySqlOrderingExpr();
        item.setExpr(this.expr());
        if (this.lexer.token() == Token.ASC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.ASC);
        } else if (this.lexer.token() == Token.DESC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.DESC);
        }
        return item;
    }

    public SQLPartition parsePartition() {
        this.accept(Token.PARTITION);
        SQLPartition partitionDef = new SQLPartition();
        partitionDef.setName(this.name());
        SQLPartitionValue values = this.parsePartitionValues();
        if (values != null) {
            partitionDef.setValues(values);
        }
        while (true) {
            boolean storage = false;
            if (this.lexer.identifierEquals(FnvHash.Constants.DATA)) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                partitionDef.setDataDirectory(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.TABLESPACE) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLName tableSpace = this.name();
                partitionDef.setTablespace(tableSpace);
                continue;
            }
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                partitionDef.setIndexDirectory(this.expr());
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MAX_ROWS)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr maxRows = this.primary();
                partitionDef.setMaxRows(maxRows);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MIN_ROWS)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr minRows = this.primary();
                partitionDef.setMaxRows(minRows);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE) || (storage = this.lexer.token() == Token.STORAGE || this.lexer.identifierEquals(FnvHash.Constants.STORAGE))) {
                if (storage) {
                    this.lexer.nextToken();
                }
                this.acceptIdentifier("ENGINE");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLName engine = this.name();
                partitionDef.setEngine((SQLExpr)engine);
                continue;
            }
            if (this.lexer.token() != Token.COMMENT) break;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr comment = this.primary();
            partitionDef.setComment(comment);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                this.acceptIdentifier("SUBPARTITION");
                SQLName subPartitionName = this.name();
                SQLSubPartition subPartition = new SQLSubPartition();
                subPartition.setName(subPartitionName);
                partitionDef.addSubPartition(subPartition);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return partitionDef;
    }

    protected SQLExpr parseAliasExpr(String alias) {
        String chars = alias.substring(1, alias.length() - 1);
        return new SQLCharExpr(chars);
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "GROUP_CONCAT", "MAX", "MIN", "STDDEV", "SUM"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower((String[])strings, (boolean)true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower((String)str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            ElasticSqlExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

