/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.jdbc;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.metrics.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.GeoBounds;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.Percentiles;
import org.elasticsearch.search.aggregations.metrics.Stats;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.jdbc.ObjectResult;
import org.nlpcn.es4sql.jdbc.ObjectResultsExtractException;
import org.nlpcn.es4sql.query.DefaultQueryAction;
import org.nlpcn.es4sql.query.QueryAction;

public class ObjectResultsExtractor {
    private final boolean includeType;
    private final boolean includeScore;
    private final boolean includeId;
    private final boolean includeScrollId;
    private int currentLineIndex;
    private QueryAction queryAction;

    public ObjectResultsExtractor(boolean includeScore, boolean includeType, boolean includeId, boolean includeScrollId, QueryAction queryAction) {
        this.includeScore = includeScore;
        this.includeType = includeType;
        this.includeId = includeId;
        this.includeScrollId = includeScrollId;
        this.currentLineIndex = 0;
        this.queryAction = queryAction;
    }

    public ObjectResult extractResults(Object queryResult, boolean flat) throws ObjectResultsExtractException {
        if (queryResult instanceof SearchHits) {
            SearchHit[] hits = ((SearchHits)queryResult).getHits();
            ArrayList<Map<String, Object>> docsAsMap = new ArrayList<Map<String, Object>>();
            HashSet<String> hitFieldNames = new HashSet<String>();
            List<String> headers = this.createHeadersAndFillDocsMap(flat, hits, null, docsAsMap, hitFieldNames);
            List<List<Object>> lines = this.createLinesFromDocs(flat, docsAsMap, headers, hitFieldNames);
            return new ObjectResult(headers, lines);
        }
        if (queryResult instanceof Aggregations) {
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<List<Object>> lines = new ArrayList<List<Object>>();
            lines.add(new ArrayList());
            this.handleAggregations((Aggregations)queryResult, headers, lines);
            if (((List)lines.get(0)).size() == 0) {
                lines.remove(0);
            }
            return new ObjectResult(headers, lines);
        }
        if (queryResult instanceof SearchResponse) {
            SearchHit[] hits = ((SearchResponse)queryResult).getHits().getHits();
            ArrayList<Map<String, Object>> docsAsMap = new ArrayList<Map<String, Object>>();
            HashSet<String> hitFieldNames = new HashSet<String>();
            List<String> headers = this.createHeadersAndFillDocsMap(flat, hits, ((SearchResponse)queryResult).getScrollId(), docsAsMap, hitFieldNames);
            List<List<Object>> lines = this.createLinesFromDocs(flat, docsAsMap, headers, hitFieldNames);
            return new ObjectResult(headers, lines);
        }
        return null;
    }

    private void handleAggregations(Aggregations aggregations, List<String> headers, List<List<Object>> lines) throws ObjectResultsExtractException {
        if (this.allNumericAggregations(aggregations)) {
            lines.get(this.currentLineIndex).addAll(this.fillHeaderAndCreateLineForNumericAggregations(aggregations, headers));
            return;
        }
        List aggregationList = aggregations.asList();
        if (aggregationList.size() > 1) {
            throw new ObjectResultsExtractException("currently support only one aggregation at same level (Except for numeric metrics)");
        }
        Aggregation aggregation = (Aggregation)aggregationList.get(0);
        if (aggregation instanceof SingleBucketAggregation) {
            Aggregations singleBucketAggs = ((SingleBucketAggregation)aggregation).getAggregations();
            this.handleAggregations(singleBucketAggs, headers, lines);
            return;
        }
        if (aggregation instanceof NumericMetricsAggregation) {
            this.handleNumericMetricAggregation(headers, lines.get(this.currentLineIndex), aggregation);
            return;
        }
        if (aggregation instanceof GeoBounds) {
            this.handleGeoBoundsAggregation(headers, lines, (GeoBounds)aggregation);
            return;
        }
        if (aggregation instanceof TopHits) {
            // empty if block
        }
        if (aggregation instanceof MultiBucketsAggregation) {
            MultiBucketsAggregation bucketsAggregation = (MultiBucketsAggregation)aggregation;
            String name = bucketsAggregation.getName();
            if (!headers.contains(name)) {
                headers.add(name);
            }
            List buckets = bucketsAggregation.getBuckets();
            List<Object> currentLine = lines.get(this.currentLineIndex);
            ArrayList<Object> clonedLine = new ArrayList<Object>(currentLine);
            boolean firstLine = true;
            for (MultiBucketsAggregation.Bucket bucket : buckets) {
                String key = bucket.getKeyAsString();
                if (firstLine) {
                    firstLine = false;
                } else {
                    ++this.currentLineIndex;
                    currentLine = new ArrayList<Object>(clonedLine);
                    lines.add(currentLine);
                }
                currentLine.add(key);
                this.handleAggregations(bucket.getAggregations(), headers, lines);
            }
        }
    }

    private void handleGeoBoundsAggregation(List<String> headers, List<List<Object>> lines, GeoBounds geoBoundsAggregation) {
        String geoBoundAggName = geoBoundsAggregation.getName();
        headers.add(geoBoundAggName + ".topLeft.lon");
        headers.add(geoBoundAggName + ".topLeft.lat");
        headers.add(geoBoundAggName + ".bottomRight.lon");
        headers.add(geoBoundAggName + ".bottomRight.lat");
        List<Object> line = lines.get(this.currentLineIndex);
        line.add(String.valueOf(geoBoundsAggregation.topLeft().getLon()));
        line.add(String.valueOf(geoBoundsAggregation.topLeft().getLat()));
        line.add(String.valueOf(geoBoundsAggregation.bottomRight().getLon()));
        line.add(String.valueOf(geoBoundsAggregation.bottomRight().getLat()));
        lines.add(line);
    }

    private List<Object> fillHeaderAndCreateLineForNumericAggregations(Aggregations aggregations, List<String> header) throws ObjectResultsExtractException {
        ArrayList<Object> line = new ArrayList<Object>();
        List aggregationList = aggregations.asList();
        for (Aggregation aggregation : aggregationList) {
            this.handleNumericMetricAggregation(header, line, aggregation);
        }
        return line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleNumericMetricAggregation(List<String> header, List<Object> line, Aggregation aggregation) throws ObjectResultsExtractException {
        String name = aggregation.getName();
        if (aggregation instanceof NumericMetricsAggregation.SingleValue) {
            if (!header.contains(name)) {
                header.add(name);
            }
            line.add(((NumericMetricsAggregation.SingleValue)aggregation).value());
            return;
        } else {
            if (!(aggregation instanceof NumericMetricsAggregation.MultiValue)) throw new ObjectResultsExtractException("unknown NumericMetricsAggregation" + aggregation.getClass());
            if (aggregation instanceof Stats) {
                String[] statsHeaders = new String[]{"count", "sum", "avg", "min", "max"};
                boolean isExtendedStats = aggregation instanceof ExtendedStats;
                if (isExtendedStats) {
                    String[] extendedHeaders = new String[]{"sumOfSquares", "variance", "stdDeviation"};
                    statsHeaders = Util.concatStringsArrays(statsHeaders, extendedHeaders);
                }
                this.mergeHeadersWithPrefix(header, name, statsHeaders);
                Stats stats = (Stats)aggregation;
                line.add(stats.getCount());
                line.add(stats.getSum());
                line.add(stats.getAvg());
                line.add(stats.getMin());
                line.add(stats.getMax());
                if (!isExtendedStats) return;
                ExtendedStats extendedStats = (ExtendedStats)aggregation;
                line.add(extendedStats.getSumOfSquares());
                line.add(extendedStats.getVariance());
                line.add(extendedStats.getStdDeviation());
                return;
            } else {
                if (!(aggregation instanceof Percentiles)) throw new ObjectResultsExtractException("unknown NumericMetricsAggregation.MultiValue:" + aggregation.getClass());
                String[] percentileHeaders = new String[]{"1.0", "5.0", "25.0", "50.0", "75.0", "95.0", "99.0"};
                this.mergeHeadersWithPrefix(header, name, percentileHeaders);
                Percentiles percentiles = (Percentiles)aggregation;
                line.add(percentiles.percentile(1.0));
                line.add(percentiles.percentile(5.0));
                line.add(percentiles.percentile(25.0));
                line.add(percentiles.percentile(50.0));
                line.add(percentiles.percentile(75.0));
                line.add(percentiles.percentile(95.0));
                line.add(percentiles.percentile(99.0));
            }
        }
    }

    private void mergeHeadersWithPrefix(List<String> header, String prefix, String[] newHeaders) {
        for (int i = 0; i < newHeaders.length; ++i) {
            String newHeader = newHeaders[i];
            if (prefix != null && !prefix.equals("")) {
                newHeader = prefix + "." + newHeader;
            }
            if (header.contains(newHeader)) continue;
            header.add(newHeader);
        }
    }

    private boolean allNumericAggregations(Aggregations aggregations) {
        List aggregationList = aggregations.asList();
        for (Aggregation aggregation : aggregationList) {
            if (aggregation instanceof NumericMetricsAggregation) continue;
            return false;
        }
        return true;
    }

    private Aggregation skipAggregations(Aggregation firstAggregation) {
        while (firstAggregation instanceof SingleBucketAggregation) {
            firstAggregation = this.getFirstAggregation(((SingleBucketAggregation)firstAggregation).getAggregations());
        }
        return firstAggregation;
    }

    private Aggregation getFirstAggregation(Aggregations aggregations) {
        return (Aggregation)aggregations.asList().get(0);
    }

    private List<List<Object>> createLinesFromDocs(boolean flat, List<Map<String, Object>> docsAsMap, List<String> headers, Set<String> hitFieldNames) {
        ArrayList<List<Object>> objectLines = new ArrayList<List<Object>>();
        for (Map<String, Object> doc : docsAsMap) {
            ArrayList<Object> lines = new ArrayList<Object>();
            for (String header : headers) {
                lines.add(this.findFieldValue(header, doc, flat, hitFieldNames));
            }
            objectLines.add(lines);
        }
        return objectLines;
    }

    private List<String> createHeadersAndFillDocsMap(boolean flat, SearchHit[] hits, String scrollId, List<Map<String, Object>> docsAsMap, Set<String> hitFieldNames) {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (this.queryAction instanceof DefaultQueryAction) {
            fieldNames.addAll(((DefaultQueryAction)this.queryAction).getFieldNames());
        }
        boolean hasScrollId = this.includeScrollId || fieldNames.contains("_scroll_id");
        for (SearchHit hit : hits) {
            Map doc = Optional.ofNullable(hit.getSourceAsMap()).orElse(Maps.newHashMap());
            if (this.includeScore) {
                doc.put("_score", Float.valueOf(hit.getScore()));
            }
            if (this.includeType) {
                doc.put("_type", hit.getType());
            }
            if (this.includeId) {
                doc.put("_id", hit.getId());
            }
            if (hasScrollId) {
                doc.put("_scroll_id", scrollId);
            }
            this.mergeHeaders(headers, doc, flat);
            Map fields = hit.getFields();
            for (DocumentField searchHitField : fields.values()) {
                List values = Optional.ofNullable(searchHitField.getValues()).orElse(Collections.emptyList());
                int size = values.size();
                doc.put(searchHitField.getName(), size == 1 ? values.get(0) : (size > 1 ? values : null));
                hitFieldNames.add(searchHitField.getName());
                headers.add(searchHitField.getName());
            }
            docsAsMap.add(doc);
        }
        ArrayList<String> list = new ArrayList<String>(headers);
        if (!fieldNames.isEmpty()) {
            list.sort((o1, o2) -> {
                int i1 = fieldNames.indexOf(o1);
                int i2 = fieldNames.indexOf(o2);
                return Integer.compare(i1 < 0 ? Integer.MAX_VALUE : i1, i2 < 0 ? Integer.MAX_VALUE : i2);
            });
        }
        return list;
    }

    private Object findFieldValue(String header, Map<String, Object> doc, boolean flat, Set<String> hitFieldNames) {
        if (flat && header.contains(".") && !hitFieldNames.contains(header)) {
            String[] split = header.split("\\.");
            Object innerDoc = doc;
            for (String innerField : split) {
                if (!(innerDoc instanceof Map)) {
                    return null;
                }
                if ((innerDoc = innerDoc.get(innerField)) != null) continue;
                return null;
            }
            return innerDoc;
        }
        if (doc.containsKey(header)) {
            return doc.get(header);
        }
        return null;
    }

    private void mergeHeaders(Set<String> headers, Map<String, Object> doc, boolean flat) {
        if (!flat) {
            headers.addAll(doc.keySet());
            return;
        }
        this.mergeFieldNamesRecursive(headers, doc, "");
    }

    private void mergeFieldNamesRecursive(Set<String> headers, Map<String, Object> doc, String prefix) {
        for (Map.Entry<String, Object> field : doc.entrySet()) {
            Object value = field.getValue();
            if (value instanceof Map) {
                this.mergeFieldNamesRecursive(headers, (Map)value, prefix + field.getKey() + ".");
                continue;
            }
            headers.add(prefix + field.getKey());
        }
    }
}

