/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.domain;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.SpanNearQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.exception.SqlParseException;

public class Paramer {
    private String analysis;
    private Float boost;
    public String value;
    public Integer slop;
    private Map<String, Float> fieldsBoosts = new HashMap<String, Float>();
    private String type;
    private Float tieBreaker;
    private Operator operator;
    private String defaultField;
    private String minimumShouldMatch;
    private Boolean inOrder;
    public String clauses;

    public static Paramer parseParamer(SQLMethodInvokeExpr method) throws SqlParseException {
        Paramer instance = new Paramer();
        List parameters = method.getParameters();
        block28: for (SQLExpr expr : parameters) {
            if (expr instanceof SQLCharExpr) {
                if (instance.value == null) {
                    instance.value = ((SQLCharExpr)expr).getText();
                    continue;
                }
                instance.analysis = ((SQLCharExpr)expr).getText();
                continue;
            }
            if (expr instanceof SQLNumericLiteralExpr) {
                instance.boost = Float.valueOf(((SQLNumericLiteralExpr)expr).getNumber().floatValue());
                continue;
            }
            if (!(expr instanceof SQLBinaryOpExpr)) continue;
            SQLBinaryOpExpr sqlExpr = (SQLBinaryOpExpr)expr;
            switch (Util.expr2Object(sqlExpr.getLeft()).toString()) {
                case "query": {
                    instance.value = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "analyzer": {
                    instance.analysis = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "boost": {
                    instance.boost = Float.valueOf(Float.parseFloat(Util.expr2Object(sqlExpr.getRight()).toString()));
                    break;
                }
                case "slop": {
                    instance.slop = Integer.parseInt(Util.expr2Object(sqlExpr.getRight()).toString());
                    break;
                }
                case "fields": {
                    for (String f : Strings.splitStringByCommaToArray((String)Util.expr2Object(sqlExpr.getRight()).toString())) {
                        int index = f.lastIndexOf(94);
                        if (-1 < index) {
                            instance.fieldsBoosts.put(f.substring(0, index), Float.valueOf(Float.parseFloat(f.substring(index + 1))));
                            continue;
                        }
                        instance.fieldsBoosts.put(f, Float.valueOf(1.0f));
                    }
                    continue block28;
                }
                case "type": {
                    instance.type = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "tie_breaker": {
                    instance.tieBreaker = Float.valueOf(Float.parseFloat(Util.expr2Object(sqlExpr.getRight()).toString()));
                    break;
                }
                case "operator": {
                    instance.operator = Operator.fromString((String)Util.expr2Object(sqlExpr.getRight()).toString());
                    break;
                }
                case "default_field": {
                    instance.defaultField = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "in_order": {
                    instance.inOrder = Boolean.valueOf(Util.expr2Object(sqlExpr.getRight()).toString());
                    break;
                }
                case "clauses": {
                    instance.clauses = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "minimum_should_match": {
                    instance.minimumShouldMatch = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
            }
        }
        return instance;
    }

    public static ToXContent fullParamer(MatchPhraseQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.slop(paramer.slop.intValue());
        }
        return query;
    }

    public static ToXContent fullParamer(MatchQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.operator != null) {
            query.operator(paramer.operator);
        }
        if (paramer.minimumShouldMatch != null) {
            query.minimumShouldMatch(paramer.minimumShouldMatch);
        }
        return query;
    }

    public static ToXContent fullParamer(WildcardQueryBuilder query, Paramer paramer) {
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        return query;
    }

    public static ToXContent fullParamer(QueryStringQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.phraseSlop(paramer.slop.intValue());
        }
        if (paramer.defaultField != null) {
            query.defaultField(paramer.defaultField);
        }
        if (paramer.tieBreaker != null) {
            query.tieBreaker(paramer.tieBreaker.floatValue());
        }
        if (paramer.operator != null) {
            query.defaultOperator(paramer.operator);
        }
        if (paramer.type != null) {
            query.type(MultiMatchQueryBuilder.Type.parse((String)paramer.type.toLowerCase(Locale.ROOT), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE));
        }
        if (paramer.minimumShouldMatch != null) {
            query.minimumShouldMatch(paramer.minimumShouldMatch);
        }
        query.fields(paramer.fieldsBoosts);
        return query;
    }

    public static ToXContent fullParamer(MultiMatchQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.slop(paramer.slop.intValue());
        }
        if (paramer.type != null) {
            query.type((Object)paramer.type);
        }
        if (paramer.tieBreaker != null) {
            query.tieBreaker(paramer.tieBreaker);
        }
        if (paramer.operator != null) {
            query.operator(paramer.operator);
        }
        if (paramer.minimumShouldMatch != null) {
            query.minimumShouldMatch(paramer.minimumShouldMatch);
        }
        query.fields(paramer.fieldsBoosts);
        return query;
    }

    public static ToXContent fullParamer(SpanNearQueryBuilder query, Paramer paramer) {
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.inOrder != null) {
            query.inOrder(paramer.inOrder.booleanValue());
        }
        return query;
    }

    public static ToXContent fullParamer(MatchPhrasePrefixQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.slop(paramer.slop.intValue());
        }
        return query;
    }
}

