/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn.executors;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.plugin.nlpcn.executors.CSVResult;
import org.elasticsearch.plugin.nlpcn.executors.CsvExtractorException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.metrics.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.GeoBounds;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.Percentile;
import org.elasticsearch.search.aggregations.metrics.Percentiles;
import org.elasticsearch.search.aggregations.metrics.Stats;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.query.DefaultQueryAction;
import org.nlpcn.es4sql.query.QueryAction;

public class CSVResultsExtractor {
    private final boolean includeType;
    private final boolean includeScore;
    private final boolean includeId;
    private final boolean includeScrollId;
    private boolean includeIndex;
    private int currentLineIndex;
    private QueryAction queryAction;

    public CSVResultsExtractor(boolean includeScore, boolean includeType, boolean includeId, boolean includeScrollId, QueryAction queryAction) {
        this.includeScore = includeScore;
        this.includeType = includeType;
        this.includeId = includeId;
        this.includeScrollId = includeScrollId;
        this.currentLineIndex = 0;
        this.queryAction = queryAction;
    }

    public CSVResultsExtractor(boolean includeIndex, boolean includeScore, boolean includeType, boolean includeId, boolean includeScrollId, QueryAction queryAction) {
        this.includeIndex = includeIndex;
        this.includeScore = includeScore;
        this.includeType = includeType;
        this.includeId = includeId;
        this.includeScrollId = includeScrollId;
        this.currentLineIndex = 0;
        this.queryAction = queryAction;
    }

    public CSVResult extractResults(Object queryResult, boolean flat, String separator, boolean quote) throws CsvExtractorException {
        if (queryResult instanceof SearchHits) {
            SearchHit[] hits = ((SearchHits)queryResult).getHits();
            ArrayList<Map<String, Object>> docsAsMap = new ArrayList<Map<String, Object>>();
            HashSet<String> hitFieldNames = new HashSet<String>();
            List<String> headers = this.createHeadersAndFillDocsMap(flat, hits, null, docsAsMap, hitFieldNames);
            List<String> list = this.createCSVLinesFromDocs(flat, separator, quote, docsAsMap, headers, hitFieldNames);
            return new CSVResult(headers, list);
        }
        if (queryResult instanceof Aggregations) {
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<List<String>> lines = new ArrayList<List<String>>();
            lines.add(new ArrayList());
            this.handleAggregations((Aggregations)queryResult, headers, lines);
            ArrayList<String> csvLines = new ArrayList<String>();
            for (List list : lines) {
                csvLines.add(Joiner.on((String)separator).join(quote ? (Iterable)list.stream().map(Util::quoteString).collect(Collectors.toList()) : list));
            }
            return new CSVResult(headers, csvLines);
        }
        if (queryResult instanceof SearchResponse) {
            SearchHit[] hits = ((SearchResponse)queryResult).getHits().getHits();
            ArrayList<Map<String, Object>> docsAsMap = new ArrayList<Map<String, Object>>();
            HashSet<String> hitFieldNames = new HashSet<String>();
            List<String> headers = this.createHeadersAndFillDocsMap(flat, hits, ((SearchResponse)queryResult).getScrollId(), docsAsMap, hitFieldNames);
            List<String> list = this.createCSVLinesFromDocs(flat, separator, quote, docsAsMap, headers, hitFieldNames);
            return new CSVResult(headers, list, ((SearchResponse)queryResult).getHits().getTotalHits().value);
        }
        if (queryResult instanceof GetIndexResponse) {
            ImmutableOpenMap mappings = ((GetIndexResponse)queryResult).getMappings();
            ArrayList headers = Lists.newArrayList((Object[])new String[]{"field", "type"});
            ArrayList<String> csvLines = new ArrayList<String>();
            ArrayList<ArrayList> lines = new ArrayList<ArrayList>();
            Iterator iterator = mappings.keysIt();
            while (iterator.hasNext()) {
                String index = (String)iterator.next();
                MappingMetadata mappingMetadata = (MappingMetadata)((ImmutableOpenMap)mappings.get((Object)index)).values().toArray()[0];
                LinkedHashMap properties = (LinkedHashMap)mappingMetadata.sourceAsMap().get("properties");
                LinkedHashMap mapping = Maps.newLinkedHashMap();
                CSVResultsExtractor.parseMapping(Lists.newArrayList(), properties, mapping, 0);
                for (Object key : mapping.keySet()) {
                    lines.add(Lists.newArrayList((Object[])new String[]{key.toString(), mapping.get(key).toString()}));
                }
            }
            for (List list : lines) {
                csvLines.add(Joiner.on((String)separator).join((Iterable)list));
            }
            return new CSVResult(headers, csvLines, csvLines.size());
        }
        return null;
    }

    private static void parseMapping(ArrayList path, LinkedHashMap properties, Map<Object, Object> mapping, int children) {
        int passed = 1;
        for (Object key : properties.keySet()) {
            if (properties.get(key) instanceof LinkedHashMap) {
                LinkedHashMap value = (LinkedHashMap)properties.get(key);
                if (!key.equals("properties")) {
                    path.add(key.toString());
                }
                if (value.containsKey("type")) {
                    String realPath = CSVResultsExtractor.parsePath(path.toString());
                    mapping.put(realPath, value.get("type"));
                    if (value.containsKey("fields")) {
                        mapping.put(realPath + ".keyword", "keyword");
                    }
                    if (passed == children && path.size() - 2 >= 0) {
                        path.remove(path.size() - 2);
                    }
                    path.remove(path.size() - 1);
                } else {
                    if (value.containsKey("properties")) {
                        children = ((LinkedHashMap)value.get("properties")).size();
                    }
                    CSVResultsExtractor.parseMapping(path, value, mapping, children);
                }
            }
            ++passed;
        }
    }

    private static String parsePath(String path) {
        return path.replaceAll("\\s+", "").replace("[", "").replace("]", "").replace(",", ".");
    }

    private void handleAggregations(Aggregations aggregations, List<String> headers, List<List<String>> lines) throws CsvExtractorException {
        if (this.allNumericAggregations(aggregations)) {
            lines.get(this.currentLineIndex).addAll(this.fillHeaderAndCreateLineForNumericAggregations(aggregations, headers));
            return;
        }
        List aggregationList = aggregations.asList();
        if (aggregationList.size() > 1) {
            throw new CsvExtractorException("currently support only one aggregation at same level (Except for numeric metrics)");
        }
        Aggregation aggregation = (Aggregation)aggregationList.get(0);
        if (aggregation instanceof SingleBucketAggregation) {
            Aggregations singleBucketAggs = ((SingleBucketAggregation)aggregation).getAggregations();
            this.handleAggregations(singleBucketAggs, headers, lines);
            return;
        }
        if (aggregation instanceof NumericMetricsAggregation) {
            this.handleNumericMetricAggregation(headers, lines.get(this.currentLineIndex), aggregation);
            return;
        }
        if (aggregation instanceof GeoBounds) {
            this.handleGeoBoundsAggregation(headers, lines, (GeoBounds)aggregation);
            return;
        }
        if (aggregation instanceof TopHits) {
            // empty if block
        }
        if (aggregation instanceof MultiBucketsAggregation) {
            MultiBucketsAggregation bucketsAggregation = (MultiBucketsAggregation)aggregation;
            String name = bucketsAggregation.getName();
            if (!headers.contains(name)) {
                headers.add(name);
            }
            List buckets = bucketsAggregation.getBuckets();
            List<String> currentLine = lines.get(this.currentLineIndex);
            ArrayList<String> clonedLine = new ArrayList<String>(currentLine);
            boolean firstLine = true;
            for (MultiBucketsAggregation.Bucket bucket : buckets) {
                String key = bucket.getKeyAsString();
                if (firstLine) {
                    firstLine = false;
                } else {
                    ++this.currentLineIndex;
                    currentLine = new ArrayList<String>(clonedLine);
                    lines.add(currentLine);
                }
                currentLine.add(key);
                this.handleAggregations(bucket.getAggregations(), headers, lines);
            }
        }
    }

    private void handleGeoBoundsAggregation(List<String> headers, List<List<String>> lines, GeoBounds geoBoundsAggregation) {
        String geoBoundAggName = geoBoundsAggregation.getName();
        headers.add(geoBoundAggName + ".topLeft.lon");
        headers.add(geoBoundAggName + ".topLeft.lat");
        headers.add(geoBoundAggName + ".bottomRight.lon");
        headers.add(geoBoundAggName + ".bottomRight.lat");
        List<String> line = lines.get(this.currentLineIndex);
        line.add(String.valueOf(geoBoundsAggregation.topLeft().getLon()));
        line.add(String.valueOf(geoBoundsAggregation.topLeft().getLat()));
        line.add(String.valueOf(geoBoundsAggregation.bottomRight().getLon()));
        line.add(String.valueOf(geoBoundsAggregation.bottomRight().getLat()));
        lines.add(line);
    }

    private List<String> fillHeaderAndCreateLineForNumericAggregations(Aggregations aggregations, List<String> header) throws CsvExtractorException {
        ArrayList<String> line = new ArrayList<String>();
        List aggregationList = aggregations.asList();
        for (Aggregation aggregation : aggregationList) {
            this.handleNumericMetricAggregation(header, line, aggregation);
        }
        return line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleNumericMetricAggregation(List<String> header, List<String> line, Aggregation aggregation) throws CsvExtractorException {
        String name = aggregation.getName();
        if (aggregation instanceof NumericMetricsAggregation.SingleValue) {
            NumericMetricsAggregation.SingleValue agg;
            if (!header.contains(name)) {
                header.add(name);
            }
            line.add(!Double.isInfinite((agg = (NumericMetricsAggregation.SingleValue)aggregation).value()) ? agg.getValueAsString() : "null");
            return;
        } else {
            if (!(aggregation instanceof NumericMetricsAggregation.MultiValue)) throw new CsvExtractorException("unknown NumericMetricsAggregation" + aggregation.getClass());
            if (aggregation instanceof Stats) {
                String[] statsHeaders = new String[]{"count", "sum", "avg", "min", "max"};
                boolean isExtendedStats = aggregation instanceof ExtendedStats;
                if (isExtendedStats) {
                    String[] extendedHeaders = new String[]{"sumOfSquares", "variance", "stdDeviation"};
                    statsHeaders = Util.concatStringsArrays(statsHeaders, extendedHeaders);
                }
                this.mergeHeadersWithPrefix(header, name, statsHeaders);
                Stats stats = (Stats)aggregation;
                line.add(String.valueOf(stats.getCount()));
                line.add(stats.getSumAsString());
                line.add(stats.getAvgAsString());
                line.add(stats.getMinAsString());
                line.add(stats.getMaxAsString());
                if (!isExtendedStats) return;
                ExtendedStats extendedStats = (ExtendedStats)aggregation;
                line.add(extendedStats.getSumOfSquaresAsString());
                line.add(extendedStats.getVarianceAsString());
                line.add(extendedStats.getStdDeviationAsString());
                return;
            } else if (aggregation instanceof Percentiles) {
                ArrayList<String> percentileHeaders = new ArrayList<String>(7);
                Percentiles percentiles = (Percentiles)aggregation;
                for (Percentile p : percentiles) {
                    percentileHeaders.add(String.valueOf(p.getPercent()));
                    line.add(percentiles.percentileAsString(p.getPercent()));
                }
                this.mergeHeadersWithPrefix(header, name, percentileHeaders.toArray(new String[0]));
                return;
            } else {
                if (!(aggregation instanceof InternalTDigestPercentileRanks)) throw new CsvExtractorException("unknown NumericMetricsAggregation.MultiValue:" + aggregation.getClass());
                InternalTDigestPercentileRanks percentileRanks = (InternalTDigestPercentileRanks)aggregation;
                ArrayList<String> percentileHeaders = new ArrayList<String>(7);
                for (Percentile rank : percentileRanks) {
                    percentileHeaders.add(String.valueOf(rank.getValue()));
                    line.add(String.valueOf(rank.getPercent()));
                }
                this.mergeHeadersWithPrefix(header, name, percentileHeaders.toArray(new String[0]));
            }
        }
    }

    private void mergeHeadersWithPrefix(List<String> header, String prefix, String[] newHeaders) {
        for (int i = 0; i < newHeaders.length; ++i) {
            String newHeader = newHeaders[i];
            if (prefix != null && !prefix.equals("")) {
                newHeader = prefix + "." + newHeader;
            }
            if (header.contains(newHeader)) continue;
            header.add(newHeader);
        }
    }

    private boolean allNumericAggregations(Aggregations aggregations) {
        List aggregationList = aggregations.asList();
        for (Aggregation aggregation : aggregationList) {
            if (aggregation instanceof NumericMetricsAggregation) continue;
            return false;
        }
        return true;
    }

    private Aggregation skipAggregations(Aggregation firstAggregation) {
        while (firstAggregation instanceof SingleBucketAggregation) {
            firstAggregation = this.getFirstAggregation(((SingleBucketAggregation)firstAggregation).getAggregations());
        }
        return firstAggregation;
    }

    private Aggregation getFirstAggregation(Aggregations aggregations) {
        return (Aggregation)aggregations.asList().get(0);
    }

    private List<String> createCSVLinesFromDocs(boolean flat, String separator, boolean quote, List<Map<String, Object>> docsAsMap, List<String> headers, Set<String> hitFieldNames) {
        ArrayList<String> csvLines = new ArrayList<String>();
        for (Map<String, Object> doc : docsAsMap) {
            String line = "";
            for (String header : headers) {
                line = line + this.findFieldValue(header, doc, flat, separator, quote, hitFieldNames);
            }
            csvLines.add(line.substring(0, line.lastIndexOf(separator)));
        }
        return csvLines;
    }

    private List<String> createHeadersAndFillDocsMap(boolean flat, SearchHit[] hits, String scrollId, List<Map<String, Object>> docsAsMap, Set<String> hitFieldNames) {
        LinkedHashSet<String> csvHeaders = new LinkedHashSet<String>();
        HashMap highlightMap = Maps.newHashMap();
        for (SearchHit hit : hits) {
            hit.getHighlightFields().forEach((key, value) -> {
                String frag = value.getFragments()[0].toString();
                highlightMap.put(key, frag);
            });
            Map doc = Optional.ofNullable(hit.getSourceAsMap()).orElse(Maps.newHashMap());
            for (Map.Entry entry : doc.entrySet()) {
                if (!highlightMap.containsKey(entry.getKey())) continue;
                doc.put(entry.getKey(), highlightMap.get(entry.getKey()));
            }
            this.mergeHeaders(csvHeaders, doc, flat);
            Map fields = hit.getFields();
            for (DocumentField searchHitField : fields.values()) {
                List values = Optional.ofNullable(searchHitField.getValues()).orElse(Collections.emptyList());
                int size = values.size();
                doc.put(searchHitField.getName(), size == 1 ? values.get(0) : (size > 1 ? values : null));
                hitFieldNames.add(searchHitField.getName());
                csvHeaders.add(searchHitField.getName());
            }
            if (this.includeIndex) {
                doc.put("_index", hit.getIndex());
            }
            if (this.includeId) {
                doc.put("_id", hit.getId());
            }
            if (this.includeScore) {
                doc.put("_score", Float.valueOf(hit.getScore()));
            }
            if (this.includeType) {
                doc.put("_type", hit.getType());
            }
            if (this.includeScrollId) {
                doc.put("_scroll_id", scrollId);
            }
            docsAsMap.add(doc);
        }
        if (this.includeIndex) {
            csvHeaders.add("_index");
        }
        if (this.includeId) {
            csvHeaders.add("_id");
        }
        if (this.includeScore) {
            csvHeaders.add("_score");
        }
        if (this.includeType) {
            csvHeaders.add("_type");
        }
        if (this.includeScrollId) {
            csvHeaders.add("_scroll_id");
        }
        ArrayList<String> headers = new ArrayList<String>(csvHeaders);
        if (this.queryAction instanceof DefaultQueryAction) {
            List<String> fieldNames = ((DefaultQueryAction)this.queryAction).getFieldNames();
            headers.sort((o1, o2) -> {
                int i1 = fieldNames.indexOf(o1);
                int i2 = fieldNames.indexOf(o2);
                return Integer.compare(i1 < 0 ? Integer.MAX_VALUE : i1, i2 < 0 ? Integer.MAX_VALUE : i2);
            });
        }
        return headers;
    }

    private String findFieldValue(String header, Map<String, Object> doc, boolean flat, String separator, boolean quote, Set<String> hitFieldNames) {
        if (flat && header.contains(".") && !hitFieldNames.contains(header)) {
            String[] split = header.split("\\.");
            Object innerDoc = doc;
            for (String innerField : split) {
                if (!(innerDoc instanceof Map)) {
                    return separator;
                }
                if ((innerDoc = innerDoc.get(innerField)) != null) continue;
                return separator;
            }
            return (quote ? Util.quoteString(innerDoc.toString()) : innerDoc.toString()) + separator;
        }
        if (doc.containsKey(header)) {
            return (quote ? Util.quoteString(String.valueOf(doc.get(header))) : doc.get(header)) + separator;
        }
        return separator;
    }

    private void mergeHeaders(Set<String> headers, Map<String, Object> doc, boolean flat) {
        if (!flat) {
            headers.addAll(doc.keySet());
            return;
        }
        this.mergeFieldNamesRecursive(headers, doc, "");
    }

    private void mergeFieldNamesRecursive(Set<String> headers, Map<String, Object> doc, String prefix) {
        for (Map.Entry<String, Object> field : doc.entrySet()) {
            Object value = field.getValue();
            if (value instanceof Map) {
                this.mergeFieldNamesRecursive(headers, (Map)value, prefix + field.getKey() + ".");
                continue;
            }
            headers.add(prefix + field.getKey());
        }
    }
}

