/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.plugin.nlpcn.ComperableHitResult;
import org.elasticsearch.plugin.nlpcn.ElasticHitsExecutor;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.query.multi.MultiQueryRequestBuilder;

public class IntersectExecutor
implements ElasticHitsExecutor {
    private MultiQueryRequestBuilder builder;
    private SearchHits intersectHits;
    private String[] fieldsOrderFirstTable;
    private String[] fieldsOrderSecondTable;
    private String separator;

    public IntersectExecutor(MultiQueryRequestBuilder builder) {
        this.builder = builder;
        this.fillFieldsOrder();
        this.separator = UUID.randomUUID().toString();
    }

    @Override
    public void run() {
        ActionFuture first = this.builder.getFirstSearchRequest().execute();
        ActionFuture second = this.builder.getSecondSearchRequest().execute();
        SearchHit[] hits = ((SearchResponse)first.actionGet()).getHits().getHits();
        LinkedHashSet<ComperableHitResult> firstResult = new LinkedHashSet<ComperableHitResult>();
        this.fillComparableSetFromHits(this.fieldsOrderFirstTable, hits, firstResult);
        hits = ((SearchResponse)second.actionGet()).getHits().getHits();
        HashSet<ComperableHitResult> secondResult = new HashSet<ComperableHitResult>();
        this.fillComparableSetFromHits(this.fieldsOrderSecondTable, hits, secondResult);
        firstResult.retainAll(secondResult);
        this.fillIntersectHitsFromResults(firstResult);
    }

    @Override
    public SearchHits getHits() {
        return this.intersectHits;
    }

    private void fillIntersectHitsFromResults(Set<ComperableHitResult> comparableHitResults) {
        int currentId = 1;
        ArrayList<SearchHit> intersectHitsList = new ArrayList<SearchHit>(comparableHitResults.size());
        Set<Map.Entry<String, String>> firstTableFieldToAlias = this.builder.getFirstTableFieldToAlias().entrySet();
        for (ComperableHitResult result : comparableHitResults) {
            SearchHit originalHit = result.getOriginalHit();
            SearchHit searchHit = new SearchHit(currentId, originalHit.getId(), new Text(originalHit.getType()), originalHit.getFields(), null);
            searchHit.sourceRef(originalHit.getSourceRef());
            searchHit.getSourceAsMap().clear();
            Map<String, Object> sourceAsMap = result.getFlattenMap();
            for (Map.Entry<String, String> entry : firstTableFieldToAlias) {
                if (!sourceAsMap.containsKey(entry.getKey())) continue;
                Object value = sourceAsMap.get(entry.getKey());
                sourceAsMap.remove(entry.getKey());
                sourceAsMap.put(entry.getValue(), value);
            }
            searchHit.getSourceAsMap().putAll(sourceAsMap);
            ++currentId;
            intersectHitsList.add(searchHit);
        }
        int totalSize = currentId - 1;
        SearchHit[] unionHitsArr = intersectHitsList.toArray(new SearchHit[totalSize]);
        this.intersectHits = new SearchHits(unionHitsArr, new TotalHits((long)totalSize, TotalHits.Relation.EQUAL_TO), 1.0f);
    }

    private void fillComparableSetFromHits(String[] fieldsOrder, SearchHit[] hits, Set<ComperableHitResult> setToFill) {
        if (Objects.isNull(hits)) {
            return;
        }
        for (SearchHit hit : hits) {
            ComperableHitResult comperableHitResult = new ComperableHitResult(hit, fieldsOrder, this.separator);
            if (comperableHitResult.isAllNull()) continue;
            setToFill.add(comperableHitResult);
        }
    }

    private void fillFieldsOrder() {
        Map<String, String> firstTableFieldToAlias = this.builder.getFirstTableFieldToAlias();
        List<Field> firstTableFields = this.builder.getOriginalSelect(true).getFields();
        ArrayList<String> fieldsOrAliases = new ArrayList<String>();
        for (Field field : firstTableFields) {
            if (firstTableFieldToAlias.containsKey(field.getName())) {
                fieldsOrAliases.add(field.getAlias());
                continue;
            }
            fieldsOrAliases.add(field.getName());
        }
        Collections.sort(fieldsOrAliases);
        int fieldsSize = fieldsOrAliases.size();
        this.fieldsOrderFirstTable = new String[fieldsSize];
        this.fillFieldsArray(fieldsOrAliases, firstTableFieldToAlias, this.fieldsOrderFirstTable);
        this.fieldsOrderSecondTable = new String[fieldsSize];
        this.fillFieldsArray(fieldsOrAliases, this.builder.getSecondTableFieldToAlias(), this.fieldsOrderSecondTable);
    }

    private void fillFieldsArray(List<String> fieldsOrAliases, Map<String, String> fieldsToAlias, String[] fields) {
        Map<String, String> aliasToField = this.inverseMap(fieldsToAlias);
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            String field = fieldsOrAliases.get(i);
            if (aliasToField.containsKey(field)) {
                field = aliasToField.get(field);
            }
            fields[i] = field;
        }
    }

    private Map<String, String> inverseMap(Map<String, String> mapToInverse) {
        HashMap inverseMap = Maps.newHashMapWithExpectedSize((int)mapToInverse.size());
        for (Map.Entry<String, String> entry : mapToInverse.entrySet()) {
            inverseMap.put(entry.getValue(), entry.getKey());
        }
        return inverseMap;
    }
}

