/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.elasticsearch.plugin.nlpcn.SearchHitsResult;
import org.elasticsearch.search.SearchHit;
import org.nlpcn.es4sql.domain.Field;

public class HashJoinComparisonStructure {
    private HashMap<String, List<Map.Entry<Field, Field>>> comparisonIDtoComparisonFields = new HashMap();
    private HashMap<String, HashMap<String, SearchHitsResult>> comparisonIDtoComparisonHash = new HashMap();

    public HashJoinComparisonStructure(List<List<Map.Entry<Field, Field>>> t1ToT2FieldsComparisons) {
        if (t1ToT2FieldsComparisons == null || t1ToT2FieldsComparisons.size() == 0) {
            String comparisonId = UUID.randomUUID().toString();
            this.comparisonIDtoComparisonFields.put(comparisonId, new ArrayList());
            this.comparisonIDtoComparisonHash.put(comparisonId, new HashMap());
        }
        for (List<Map.Entry<Field, Field>> comparisonFields : t1ToT2FieldsComparisons) {
            String comparisonId = UUID.randomUUID().toString();
            this.comparisonIDtoComparisonFields.put(comparisonId, comparisonFields);
            this.comparisonIDtoComparisonHash.put(comparisonId, new HashMap());
        }
    }

    public HashMap<String, List<Map.Entry<Field, Field>>> getComparisons() {
        return this.comparisonIDtoComparisonFields;
    }

    public void insertIntoComparisonHash(String comparisonID, String comparisonKey, SearchHit hit) {
        HashMap<String, SearchHitsResult> comparisonHash = this.comparisonIDtoComparisonHash.get(comparisonID);
        SearchHitsResult currentSearchHitsResult = comparisonHash.get(comparisonKey);
        if (currentSearchHitsResult == null) {
            currentSearchHitsResult = new SearchHitsResult(new ArrayList<SearchHit>(), false);
            comparisonHash.put(comparisonKey, currentSearchHitsResult);
        }
        currentSearchHitsResult.getSearchHits().add(hit);
    }

    public SearchHitsResult searchForMatchingSearchHits(String comparisonID, String comparisonKey) {
        HashMap<String, SearchHitsResult> comparisonHash = this.comparisonIDtoComparisonHash.get(comparisonID);
        return comparisonHash.get(comparisonKey);
    }

    public List<SearchHitsResult> getAllSearchHits() {
        ArrayList<SearchHitsResult> allSearchHits = new ArrayList<SearchHitsResult>();
        for (HashMap<String, SearchHitsResult> comparisonHash : this.comparisonIDtoComparisonHash.values()) {
            allSearchHits.addAll(comparisonHash.values());
        }
        return allSearchHits;
    }
}

