/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.plugin.nlpcn.MetaSearchResult;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.nlpcn.es4sql.domain.Select;

public class ElasticUtils {
    public static SearchResponse scrollOneTimeWithHits(Client client, SearchRequestBuilder requestBuilder, Select originalSelect, int resultSize) {
        SearchRequestBuilder scrollRequest = requestBuilder.setScroll(new TimeValue(60000L)).setSize(resultSize);
        boolean ordered = originalSelect.isOrderdSelect();
        if (!ordered) {
            scrollRequest.addSort("_doc", SortOrder.ASC);
        }
        SearchResponse responseWithHits = (SearchResponse)scrollRequest.get();
        return responseWithHits;
    }

    public static XContentBuilder hitsAsXContentBuilder(SearchHits results, MetaSearchResult metaResults) throws IOException {
        if (results == null) {
            return null;
        }
        Object[] searchHits = new Object[(int)results.getTotalHits().value];
        int i = 0;
        for (SearchHit hit : results) {
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("_id", hit.getId());
            value.put("_type", hit.getType());
            value.put("_score", Float.valueOf(hit.getScore()));
            value.put("_source", hit.getSourceAsMap());
            searchHits[i] = value;
            ++i;
        }
        HashMap<String, Object> hits = new HashMap<String, Object>();
        TotalHits totalHits = results.getTotalHits();
        hits.put("total", ImmutableMap.of((Object)"value", (Object)totalHits.value, (Object)"relation", (Object)(totalHits.relation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte")));
        hits.put("max_score", Float.valueOf(results.getMaxScore()));
        hits.put("hits", searchHits);
        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).prettyPrint();
        builder.startObject();
        builder.field("took", metaResults.getTookImMilli());
        builder.field("timed_out", metaResults.isTimedOut());
        builder.field("_shards", (Map)ImmutableMap.of((Object)"total", (Object)metaResults.getTotalNumOfShards(), (Object)"successful", (Object)metaResults.getSuccessfulShards(), (Object)"failed", (Object)metaResults.getFailedShards()));
        builder.field("hits", hits);
        builder.endObject();
        return builder;
    }
}

