/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.pool.DruidPooledResultSet;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.pool.ElasticSearchConnection;
import com.alibaba.druid.pool.ElasticSearchPreparedStatement;
import com.alibaba.druid.pool.ElasticSearchResultSet;
import com.alibaba.druid.pool.PreparedStatementHolder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.plugin.nlpcn.QueryActionElasticExecutor;
import org.elasticsearch.plugin.nlpcn.executors.CsvExtractorException;
import org.nlpcn.es4sql.SearchDao;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.jdbc.ObjectResult;
import org.nlpcn.es4sql.jdbc.ObjectResultsExtractor;
import org.nlpcn.es4sql.query.QueryAction;

public class ElasticSearchDruidPooledPreparedStatement
extends DruidPooledPreparedStatement {
    private final Client client;

    public ElasticSearchDruidPooledPreparedStatement(DruidPooledConnection conn, PreparedStatementHolder holder) throws SQLException {
        super(conn, holder);
        this.client = ((ElasticSearchConnection)conn.getConnection()).getClient();
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        this.incrementExecuteQueryCount();
        this.transactionRecord(this.getSql());
        this.oracleSetRowPrefetch();
        this.conn.beforeExecute();
        try {
            ObjectResult extractor = this.getObjectResult(true, false, false, true);
            List<String> headers = extractor.getHeaders();
            List<List<Object>> lines = extractor.getLines();
            ElasticSearchResultSet rs = new ElasticSearchResultSet((Statement)((Object)this), headers, lines);
            DruidPooledResultSet poolableResultSet = new DruidPooledResultSet((DruidPooledStatement)this, (ResultSet)rs);
            this.addResultSetTrace((ResultSet)poolableResultSet);
            DruidPooledResultSet druidPooledResultSet = poolableResultSet;
            return druidPooledResultSet;
        }
        catch (Throwable t) {
            this.errorCheck(t);
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    public boolean execute() throws SQLException {
        this.checkOpen();
        this.incrementExecuteCount();
        this.transactionRecord(this.getSql());
        this.conn.beforeExecute();
        try {
            ObjectResult extractor = this.getObjectResult(true, false, false, true);
            List<String> headers = extractor.getHeaders();
            List<List<Object>> lines = extractor.getLines();
            ElasticSearchResultSet rs = new ElasticSearchResultSet((Statement)((Object)this), headers, lines);
            ((ElasticSearchPreparedStatement)this.getRawPreparedStatement()).setResults(rs);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this.errorCheck(t);
            throw this.checkException(t);
        }
        finally {
            this.conn.afterExecute();
        }
    }

    private ObjectResult getObjectResult(boolean flat, boolean includeScore, boolean includeType, boolean includeId) throws SqlParseException, SQLFeatureNotSupportedException, Exception, CsvExtractorException {
        SearchDao searchDao = new SearchDao(this.client);
        String query = ((ElasticSearchPreparedStatement)this.getRawPreparedStatement()).getExecutableSql();
        QueryAction queryAction = searchDao.explain(query);
        Object execution = QueryActionElasticExecutor.executeAnyAction(searchDao.getClient(), queryAction);
        return new ObjectResultsExtractor(includeScore, includeType, includeId, false, queryAction).extractResults(execution, flat);
    }

    public int executeUpdate() throws SQLException {
        throw new SQLException("executeUpdate not support in ElasticSearch");
    }
}

