/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.looker;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.PreDataProxy;
import xyz.erupt.annotation.config.SkipSerialize;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.query.Condition;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.Readonly;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.DateType;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.jpa.model.BaseModel;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.EruptUserVo;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptUserService;

@MappedSuperclass
@PreDataProxy(value=LookerPostLevel.class)
@Service
public class LookerPostLevel
extends BaseModel
implements DataProxy<LookerPostLevel> {
    @ManyToOne
    @EruptField(views={@View(title="\u521b\u5efa\u4eba", column="name"), @View(title="\u6240\u5c5e\u7ec4\u7ec7", column="eruptOrg.name"), @View(title="\u5c97\u4f4d", column="eruptPost.name")}, edit=@Edit(title="\u521b\u5efa\u4eba", readonly=@Readonly, type=EditType.REFERENCE_TABLE))
    private EruptUserVo createUser;
    @EruptField(views={@View(title="\u521b\u5efa\u65f6\u95f4", sortable=true)}, edit=@Edit(title="\u521b\u5efa\u65f6\u95f4", readonly=@Readonly, dateType=@DateType(type=DateType.Type.DATE_TIME)))
    private Date createTime;
    @SkipSerialize
    private Date updateTime;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    @SkipSerialize
    private EruptUser updateUser;
    @Resource
    @Transient
    private EruptUserService eruptUserService;
    @Resource
    @Transient
    private EruptContextService eruptContextService;

    public String beforeFetch(List<Condition> conditions) {
        EruptUser eruptUser = this.eruptUserService.getCurrentEruptUser();
        if (eruptUser.getIsAdmin().booleanValue()) {
            return null;
        }
        if (null == eruptUser.getEruptOrg() || null == eruptUser.getEruptPost()) {
            throw new EruptWebApiRuntimeException(eruptUser.getName() + " unbounded department cannot filter data");
        }
        return "(" + this.eruptContextService.getContextEruptClass().getSimpleName() + ".createUser.id = " + this.eruptUserService.getCurrentUid() + " or " + this.eruptContextService.getContextEruptClass().getSimpleName() + ".createUser.eruptOrg.id = " + eruptUser.getEruptOrg().getId() + " and " + this.eruptContextService.getContextEruptClass().getSimpleName() + ".createUser.eruptPost.weight < " + eruptUser.getEruptPost().getWeight() + ")";
    }

    public void beforeAdd(LookerPostLevel lookerPostLevel) {
        lookerPostLevel.setCreateTime(new Date());
        lookerPostLevel.setCreateUser(new EruptUserVo(this.eruptUserService.getCurrentUid()));
    }

    public void beforeUpdate(LookerPostLevel lookerPostLevel) {
        lookerPostLevel.setUpdateTime(new Date());
        lookerPostLevel.setUpdateUser(new EruptUser(this.eruptUserService.getCurrentUid()));
    }

    public EruptUserVo getCreateUser() {
        return this.createUser;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public EruptUser getUpdateUser() {
        return this.updateUser;
    }

    public EruptUserService getEruptUserService() {
        return this.eruptUserService;
    }

    public EruptContextService getEruptContextService() {
        return this.eruptContextService;
    }

    public void setCreateUser(EruptUserVo createUser) {
        this.createUser = createUser;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public void setUpdateUser(EruptUser updateUser) {
        this.updateUser = updateUser;
    }

    public void setEruptUserService(EruptUserService eruptUserService) {
        this.eruptUserService = eruptUserService;
    }

    public void setEruptContextService(EruptContextService eruptContextService) {
        this.eruptContextService = eruptContextService;
    }
}

