/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.model.online;

import java.util.Set;
import javax.annotation.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.FilterHandler;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.upms.model.online.EruptOnline;

@Service
public class EruptOnlineFilterHandler
implements FilterHandler {
    @Resource
    private EruptProp eruptProp;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public String filter(String condition, String[] params) {
        if (this.eruptProp.isRedisSession()) {
            Set keys = this.stringRedisTemplate.keys((Object)"erupt-auth:token:*");
            if (keys != null && keys.size() > 0) {
                StringBuilder sb = new StringBuilder(EruptOnline.class.getSimpleName() + ".token in (");
                keys.forEach(it -> sb.append("'").append(it.substring("erupt-auth:token:".length())).append("',"));
                return sb.substring(0, sb.length() - 1) + ")";
            }
            return "1 = 2";
        }
        throw new EruptApiErrorTip(EruptApiModel.Status.INFO, "Enable the RedisSession configuration to use this feature", EruptApiModel.PromptWay.NOTIFY);
    }
}

