/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.constant.MenuStatus;
import xyz.erupt.core.constant.MenuTypeEnum;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.enums.EruptFunPermissions;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptRole;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.util.UPMSUtil;
import xyz.erupt.upms.vo.EruptMenuVo;

@Service
public class EruptMenuService
implements DataProxy<EruptMenu> {
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptContextService eruptContextService;

    public List<EruptMenuVo> geneMenuListVo(List<EruptMenu> menus) {
        ArrayList<EruptMenuVo> list = new ArrayList<EruptMenuVo>();
        menus.stream().filter(menu -> menu.getStatus().intValue() == MenuStatus.OPEN.getValue()).forEach(menu -> {
            Long pid = null == menu.getParentMenu() ? null : menu.getParentMenu().getId();
            list.add(new EruptMenuVo(menu.getId(), menu.getCode(), menu.getName(), menu.getType(), menu.getValue(), menu.getIcon(), pid));
        });
        return list;
    }

    public List<EruptMenu> getUserAllMenu(EruptUser eruptUser) {
        if (null != eruptUser.getIsAdmin() && eruptUser.getIsAdmin().booleanValue()) {
            return this.eruptDao.queryEntityList(EruptMenu.class, "1=1 order by sort");
        }
        HashSet menuSet = new HashSet();
        eruptUser.getRoles().stream().filter(EruptRole::getStatus).map(EruptRole::getMenus).forEach(menuSet::addAll);
        return menuSet.stream().sorted(Comparator.comparing(EruptMenu::getSort, Comparator.nullsFirst(Integer::compareTo))).collect(Collectors.toList());
    }

    public void addBehavior(EruptMenu eruptMenu) {
        Integer obj = (Integer)this.eruptDao.getEntityManager().createQuery("select max(sort) from " + EruptMenu.class.getSimpleName()).getSingleResult();
        Optional.ofNullable(obj).ifPresent(it -> eruptMenu.setSort(it + 10));
        eruptMenu.setStatus(MenuStatus.OPEN.getValue());
    }

    public void beforeAdd(EruptMenu eruptMenu) {
        if (null == eruptMenu.getCode()) {
            eruptMenu.setCode(Erupts.generateCode());
        }
        if (StringUtils.isNotBlank((CharSequence)eruptMenu.getType()) && StringUtils.isBlank((CharSequence)eruptMenu.getValue())) {
            throw new EruptWebApiRuntimeException("When selecting a menu type, the type value cannot be empty");
        }
        if (StringUtils.isNotBlank((CharSequence)eruptMenu.getValue()) && StringUtils.isBlank((CharSequence)eruptMenu.getType())) {
            throw new EruptWebApiRuntimeException("When has menu value, the menu type cannot be empty");
        }
    }

    public void beforeUpdate(EruptMenu eruptMenu) {
        this.beforeAdd(eruptMenu);
    }

    private void flushCache() {
        EruptUserService eruptUserService = (EruptUserService)EruptSpringUtil.getBean(EruptUserService.class);
        eruptUserService.cacheUserInfo(eruptUserService.getCurrentEruptUser(), this.eruptContextService.getCurrentToken());
    }

    public void afterAdd(EruptMenu eruptMenu) {
        if (null != eruptMenu.getValue() && (MenuTypeEnum.TABLE.getCode().equals(eruptMenu.getType()) || MenuTypeEnum.TREE.getCode().equals(eruptMenu.getType()))) {
            int i = 0;
            Integer counter = (Integer)this.eruptDao.getJdbcTemplate().queryForObject(String.format("select count(*) from e_upms_menu where parent_menu_id = %d", eruptMenu.getId()), Integer.class);
            if (null != counter) {
                Integer realCounter;
                if (counter > 0 && null != (realCounter = (Integer)this.eruptDao.getJdbcTemplate().queryForObject(String.format("select count(*) from e_upms_menu where parent_menu_id = %d and value like '%s@%%'", eruptMenu.getId(), eruptMenu.getValue()), Integer.class)) && realCounter == 0) {
                    this.eruptDao.getJdbcTemplate().update(String.format("delete from e_upms_menu where parent_menu_id = %d and value like '%%@%%'", eruptMenu.getId()));
                    counter = 0;
                }
                if (counter <= 0) {
                    EruptModel eruptModel = EruptCoreService.getErupt((String)eruptMenu.getValue());
                    for (EruptFunPermissions value : EruptFunPermissions.values()) {
                        if (eruptModel != null && !value.verifyPower(eruptModel.getErupt().power())) continue;
                        this.eruptDao.persist((Object)new EruptMenu(Erupts.generateCode(), value.getName(), MenuTypeEnum.BUTTON.getCode(), UPMSUtil.getEruptFunPermissionsCode(eruptMenu.getValue(), value), eruptMenu, i += 10));
                    }
                }
            }
        }
        this.flushCache();
    }

    public void afterUpdate(EruptMenu eruptMenu) {
        this.afterAdd(eruptMenu);
    }

    public void afterDelete(EruptMenu eruptMenu) {
        this.flushCache();
    }
}

