/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.screwTheory;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.matrixlib.MatrixTestTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.algorithms.CentroidalMomentumRateCalculator;
import us.ihmc.mecano.frames.CenterOfMassReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.simulationConstructionSetTools.tools.RobotTools;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;

public class CentroidalMomentumRateTermCalculatorSCSTest {
    private static final double EPSILON = 1.0E-5;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int NUMBER_OF_ITERATIONS = 10;
    private final double controlDT = 1.0E-8;
    private final DMatrixRMaj a = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj aPrevVal = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj aDot = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj aTermCalculator = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj aDotVNumerical = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj aDotVAnalytical = new DMatrixRMaj(6, 1);

    @Test
    public void chainTest() throws UnreasonableAccelerationException {
        Random random = new Random(12651L);
        ArrayList<RevoluteJoint> joints = new ArrayList<RevoluteJoint>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        int numberOfJoints = 10;
        Vector3D[] jointAxes = new Vector3D[numberOfJoints];
        for (int i = 0; i < numberOfJoints; ++i) {
            jointAxes[i] = RandomGeometry.nextVector3D((Random)random, (double)1.0);
        }
        joints.addAll(MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (String)"blop", (RigidBodyBasics)elevator, (Vector3DReadOnly[])jointAxes));
        RobotTools.SCSRobotFromInverseDynamicsRobotModel robot = new RobotTools.SCSRobotFromInverseDynamicsRobotModel("robot", (JointBasics)elevator.getChildrenJoints().get(0));
        this.assertAAndADotV(random, joints, (RigidBodyBasics)elevator, robot, numberOfJoints);
    }

    @Test
    public void treeTest() throws UnreasonableAccelerationException {
        Random random = new Random(12651L);
        ArrayList<RevoluteJoint> joints = new ArrayList<RevoluteJoint>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        RevoluteJoint rootJoint = MultiBodySystemRandomTools.nextRevoluteJoint((Random)random, (String)"rootJoint", (RigidBodyBasics)elevator);
        RigidBody rootBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"rootBody", (JointBasics)rootJoint);
        int numberOfJoints = 10;
        joints.addAll(MultiBodySystemRandomTools.nextRevoluteJointTree((Random)random, (RigidBodyBasics)rootBody, (int)(numberOfJoints - 1)));
        joints.add(0, rootJoint);
        RobotTools.SCSRobotFromInverseDynamicsRobotModel robot = new RobotTools.SCSRobotFromInverseDynamicsRobotModel("robot", (JointBasics)rootJoint);
        this.assertAAndADotV(random, joints, (RigidBodyBasics)elevator, robot, numberOfJoints);
    }

    @Test
    public void floatingChainTest() throws UnreasonableAccelerationException {
        Random random = new Random(12651L);
        ArrayList<RevoluteJoint> joints = new ArrayList<RevoluteJoint>();
        int numberOfJoints = 12;
        Vector3D[] jointAxes = new Vector3D[numberOfJoints];
        for (int i = 0; i < numberOfJoints; ++i) {
            jointAxes[i] = RandomGeometry.nextVector3D((Random)random, (double)1.0);
        }
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain idRobot = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, jointAxes);
        RigidBody elevator = idRobot.getElevator();
        joints.addAll(idRobot.getRevoluteJoints());
        RobotTools.SCSRobotFromInverseDynamicsRobotModel robot = new RobotTools.SCSRobotFromInverseDynamicsRobotModel("robot", (JointBasics)idRobot.getRootJoint());
        this.assertAAndADotV(random, joints, (RigidBodyBasics)elevator, robot, numberOfJoints + 1);
    }

    private void assertAAndADotV(Random random, ArrayList<RevoluteJoint> joints, RigidBodyBasics elevator, RobotTools.SCSRobotFromInverseDynamicsRobotModel robot, int numJoints) throws UnreasonableAccelerationException {
        int numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{elevator}));
        DMatrixRMaj v = new DMatrixRMaj(numberOfDoFs, 1);
        JointBasics[] idJoints = new JointBasics[numJoints];
        CenterOfMassReferenceFrame centerOfMassFrame = new CenterOfMassReferenceFrame("com", worldFrame, (RigidBodyReadOnly)elevator);
        CentroidalMomentumCalculator centroidalMomentumMatrixCalculator = new CentroidalMomentumCalculator((RigidBodyReadOnly)elevator, (ReferenceFrame)centerOfMassFrame);
        this.a.reshape(6, numberOfDoFs);
        this.aPrevVal.reshape(6, numberOfDoFs);
        this.aDot.reshape(6, numberOfDoFs);
        this.aTermCalculator.reshape(6, numberOfDoFs);
        CentroidalMomentumRateCalculator centroidalMomentumRateTermCalculator = new CentroidalMomentumRateCalculator((RigidBodyReadOnly)elevator, (ReferenceFrame)centerOfMassFrame);
        for (int i = 0; i < 10; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.EFFORT, joints);
            robot.updateJointPositions_ID_to_SCS();
            robot.updateJointVelocities_ID_to_SCS();
            robot.updateJointTorques_ID_to_SCS();
            elevator.updateFramesRecursively();
            centerOfMassFrame.update();
            centroidalMomentumMatrixCalculator.reset();
            this.aPrevVal.set((DMatrixD1)centroidalMomentumMatrixCalculator.getCentroidalMomentumMatrix());
            robot.doDynamicsAndIntegrate(1.0E-8);
            robot.updateVelocities();
            robot.updateJointPositions_SCS_to_ID();
            robot.updateJointVelocities_SCS_to_ID();
            elevator.updateFramesRecursively();
            centerOfMassFrame.update();
            robot.packIdJoints(idJoints);
            MultiBodySystemTools.extractJointsState((JointReadOnly[])idJoints, (JointStateType)JointStateType.VELOCITY, (DMatrix)v);
            centroidalMomentumRateTermCalculator.reset();
            this.aDotVAnalytical.set((DMatrixD1)centroidalMomentumRateTermCalculator.getBiasSpatialForceMatrix());
            this.aTermCalculator.set((DMatrixD1)centroidalMomentumRateTermCalculator.getCentroidalMomentumMatrix());
            centroidalMomentumMatrixCalculator.reset();
            this.a.set((DMatrixD1)centroidalMomentumMatrixCalculator.getCentroidalMomentumMatrix());
            MatrixTools.numericallyDifferentiate((DMatrix1Row)this.aDot, (DMatrix1Row)this.aPrevVal, (DMatrix1Row)this.a, (double)1.0E-8);
            CommonOps_DDRM.mult((DMatrix1Row)this.aDot, (DMatrix1Row)v, (DMatrix1Row)this.aDotVNumerical);
            this.smartPrintOutADotV(1.0E-5);
            MatrixTestTools.assertMatrixEquals((DMatrix)this.aDotVNumerical, (DMatrix)this.aDotVAnalytical, (double)1.0E-5);
            MatrixTestTools.assertMatrixEquals((DMatrix)this.a, (DMatrix)this.aTermCalculator, (double)1.0E-5);
        }
    }

    private void smartPrintOutADotV(double epsilon) {
        DMatrixRMaj difference = new DMatrixRMaj(this.aDotVNumerical.numRows, this.aDotVNumerical.numCols);
        CommonOps_DDRM.subtract((DMatrixD1)this.aDotVNumerical, (DMatrixD1)this.aDotVAnalytical, (DMatrixD1)difference);
        for (int i = 0; i < difference.numRows; ++i) {
            if (!(Math.abs(difference.get(i, 0)) > epsilon)) continue;
            this.printOutADotV();
            break;
        }
    }

    private void printOutADotV() {
        int numChar = 6;
        int precision = 3;
        String format = "%" + numChar + "." + precision + "f ";
        System.out.println("----------- ADotV -----------");
        System.out.println("Numerical: ||\tAnalytical:");
        for (int i = 0; i < this.aDotVNumerical.numRows; ++i) {
            System.out.printf(format + "\t   ||\t" + format + "\n", this.aDotVNumerical.get(i, 0), this.aDotVAnalytical.get(i, 0));
        }
        System.out.println();
    }
}

