/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.dataProcessors;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.simulationConstructionSetTools.util.dataProcessors.RobotAllJointsDataChecker;
import us.ihmc.simulationConstructionSetTools.util.dataProcessors.TwoLinkRobotForTesting;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.simulationTesting.SimulationTestingParameters;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;

public class RobotAllJointsDataCheckerTest {
    private static final SimulationTestingParameters simulationTestingParameters = SimulationTestingParameters.createFromSystemProperties();

    @AfterEach
    public void destroySimulationAndRecycleMemory() {
        if (simulationTestingParameters.getKeepSCSUp()) {
            // empty if block
        }
    }

    @Test
    public void test() {
        TwoLinkRobotForTesting twoLinkRobotForTesting = new TwoLinkRobotForTesting();
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)twoLinkRobotForTesting, (SimulationConstructionSetParameters)simulationTestingParameters);
        scs.setDT(1.0E-5, 100);
        scs.startOnAThread();
        twoLinkRobotForTesting.setElbowPosition(0.0);
        twoLinkRobotForTesting.setUpperPosition(3.0);
        twoLinkRobotForTesting.setElbowVelocity(-2.0);
        twoLinkRobotForTesting.setUpperVelocity(-3.0);
        scs.simulate(6.0);
        while (scs.isSimulating()) {
            Thread.yield();
        }
        RobotAllJointsDataChecker robotAllJointsDataChecker = new RobotAllJointsDataChecker(scs, (Robot)twoLinkRobotForTesting);
        robotAllJointsDataChecker.cropFirstPoint();
        scs.applyDataProcessingFunction((YoBufferProcessor)robotAllJointsDataChecker);
    }
}

