/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.ControllerFailureException;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.simulationconstructionset.util.simulationRunner.StateFileComparer;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariableDifference;

public class NothingChangedVerifier {
    private final String baseFilename;
    private final String newFilename;
    private final boolean writeNewBaseFile;
    private final SimulationConstructionSet scs;
    private final BlockingSimulationRunner blockingSimulationRunner;

    public NothingChangedVerifier(String runName, SimulationConstructionSet scs) {
        this.scs = scs;
        this.blockingSimulationRunner = new BlockingSimulationRunner(scs, 600.0);
        String pathName = "StateComparison";
        File dir = new File(pathName);
        if (!dir.exists()) {
            dir.mkdir();
        }
        String computerName = NothingChangedVerifier.getComputerName();
        this.baseFilename = pathName + "/" + runName + "_base." + computerName + ".state";
        this.newFilename = pathName + "/" + runName + "_new." + computerName + ".state";
        File baseFile = new File(this.baseFilename);
        boolean bl = this.writeNewBaseFile = !baseFile.exists();
        if (this.writeNewBaseFile) {
            JOptionPane.showMessageDialog(null, "Warning! " + this.baseFilename + " doesn't exist. Creating it.");
        }
        ThreadTools.sleep((long)1000L);
    }

    public boolean getWriteNewBaseFile() {
        return this.writeNewBaseFile;
    }

    public void runSimulation(double simTime) throws BlockingSimulationRunner.SimulationExceededMaximumTimeException, ControllerFailureException {
        if (simTime > 0.0) {
            this.blockingSimulationRunner.simulateAndBlock(simTime);
        }
    }

    public void runAndVerifySameResultsAsPreviously(double simTime, double maxPercentDifference, ArrayList<String> stringsToIgnore) throws BlockingSimulationRunner.SimulationExceededMaximumTimeException, ControllerFailureException {
        this.runSimulation(simTime);
        this.verifySameResultsAsPreviously(maxPercentDifference, stringsToIgnore);
    }

    public void verifySameResultsAsPreviously(double maxPercentDifference, ArrayList<String> stringsToIgnore) {
        if (this.writeNewBaseFile) {
            this.scs.writeState(this.baseFilename);
        } else {
            this.scs.writeState(this.newFilename);
            ArrayList variableDifferences = StateFileComparer.percentualCompareStateFiles((String)this.baseFilename, (String)this.newFilename, (double)maxPercentDifference, stringsToIgnore);
            if (variableDifferences.isEmpty()) {
                System.out.println("Sims are the same!");
            } else {
                String message = this.baseFilename + " and " + this.newFilename + " are not the same.";
                System.err.println(message + "Changed variables:\n" + VariableDifference.allVariableDifferencesToString((List)variableDifferences));
                JOptionPane.showMessageDialog(null, message);
                System.err.flush();
            }
        }
    }

    private static String getComputerName() {
        try {
            String computerName = InetAddress.getLocalHost().getHostName();
            return computerName;
        }
        catch (Exception e) {
            System.out.println("Exception caught =" + e.getMessage());
            return "unknown";
        }
    }
}

