/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.dataExporter;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.dataExporter.TorqueSpeedDataExporterGraphCreator;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;

@Tag(value="gui-slow")
public class DataExporterGraphCreatorTest {
    @Test
    public void testDataExporterGraphCreator() throws IOException {
        SimulationConstructionSet sim = this.createSimulation();
        TorqueSpeedDataExporterGraphCreator graphCreator = new TorqueSpeedDataExporterGraphCreator(sim.getRobots()[0], sim.getDataBuffer());
        File path = new File(System.getProperty("java.io.tmpdir"));
        Path tmpPath = Files.createTempDirectory(Paths.get(path.getAbsolutePath(), new String[0]), "test", new FileAttribute[0]);
        graphCreator.createJointTorqueSpeedGraphs(tmpPath.toFile(), "", true, true);
        int fileCount = tmpPath.toFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("jpg") || name.endsWith("pdf");
            }
        }).length;
        Assert.assertTrue((fileCount > 1 ? 1 : 0) != 0);
        tmpPath.toFile().deleteOnExit();
    }

    private SimulationConstructionSet createSimulation() {
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
        parameters.setCreateGUI(false);
        return new SimulationConstructionSet(this.createRobot(), parameters);
    }

    private Robot createRobot() {
        Robot robot = new Robot("RandomRobot");
        PinJoint pinJoint = new PinJoint("TestPinJoint", (Tuple3DReadOnly)new Vector3D(), robot, (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        robot.addRootJoint((Joint)pinJoint);
        return robot;
    }
}

