/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import jassimp.AiBuiltInWrapperProvider;
import jassimp.AiIOSystem;
import jassimp.AiPostProcessSteps;
import jassimp.AiScene;
import jassimp.AiWrapperProvider;
import jassimp.JassimpLibraryLoader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Set;

public final class Jassimp {
    public static final AiWrapperProvider<?, ?, ?, ?, ?> BUILTIN = new AiBuiltInWrapperProvider();
    private static AiWrapperProvider<?, ?, ?, ?, ?> s_wrapperProvider = new AiBuiltInWrapperProvider();
    private static JassimpLibraryLoader s_libraryLoader = new JassimpLibraryLoader();
    private static volatile boolean s_libraryLoaded = false;
    private static final Object s_libraryLoadingLock = new Object();
    public static int NATIVE_AIVEKTORKEY_SIZE;
    public static int NATIVE_AIQUATKEY_SIZE;
    public static int NATIVE_AIVEKTOR3D_SIZE;
    public static int NATIVE_FLOAT_SIZE;
    public static int NATIVE_INT_SIZE;
    public static int NATIVE_UINT_SIZE;
    public static int NATIVE_DOUBLE_SIZE;
    public static int NATIVE_LONG_SIZE;

    public static AiScene importFile(String filename) throws IOException {
        return Jassimp.importFile(filename, EnumSet.noneOf(AiPostProcessSteps.class));
    }

    public static AiScene importFile(String filename, AiIOSystem<?> ioSystem) throws IOException {
        return Jassimp.importFile(filename, EnumSet.noneOf(AiPostProcessSteps.class), ioSystem);
    }

    public static AiScene importFile(String filename, Set<AiPostProcessSteps> postProcessing) throws IOException {
        return Jassimp.importFile(filename, postProcessing, null);
    }

    public static AiScene importFile(String filename, Set<AiPostProcessSteps> postProcessing, AiIOSystem<?> ioSystem) throws IOException {
        Jassimp.loadLibrary();
        return Jassimp.aiImportFile(filename, AiPostProcessSteps.toRawValue(postProcessing), ioSystem);
    }

    public static native int getVKeysize();

    public static native int getQKeysize();

    public static native int getV3Dsize();

    public static native int getfloatsize();

    public static native int getintsize();

    public static native int getuintsize();

    public static native int getdoublesize();

    public static native int getlongsize();

    public static native String getErrorString();

    public static AiWrapperProvider<?, ?, ?, ?, ?> getWrapperProvider() {
        return s_wrapperProvider;
    }

    public static void setWrapperProvider(AiWrapperProvider<?, ?, ?, ?, ?> wrapperProvider) {
        s_wrapperProvider = wrapperProvider;
    }

    public static void setLibraryLoader(JassimpLibraryLoader libraryLoader) {
        s_libraryLoader = libraryLoader;
    }

    static Object wrapMatrix(float[] data) {
        return s_wrapperProvider.wrapMatrix4f(data);
    }

    static Object wrapColor3(float red, float green, float blue) {
        return Jassimp.wrapColor4(red, green, blue, 1.0f);
    }

    static Object wrapColor4(float red, float green, float blue, float alpha) {
        ByteBuffer temp = ByteBuffer.allocate(16);
        temp.putFloat(red);
        temp.putFloat(green);
        temp.putFloat(blue);
        temp.putFloat(alpha);
        temp.flip();
        return s_wrapperProvider.wrapColor(temp, 0);
    }

    static Object wrapVec3(float x, float y, float z) {
        ByteBuffer temp = ByteBuffer.allocate(12);
        temp.putFloat(x);
        temp.putFloat(y);
        temp.putFloat(z);
        temp.flip();
        return s_wrapperProvider.wrapVector3f(temp, 0, 3);
    }

    static Object wrapSceneNode(Object parent, Object matrix, int[] meshRefs, String name) {
        return s_wrapperProvider.wrapSceneNode(parent, matrix, meshRefs, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibrary() {
        if (!s_libraryLoaded) {
            Object object = s_libraryLoadingLock;
            synchronized (object) {
                if (!s_libraryLoaded) {
                    s_libraryLoader.loadLibrary();
                    NATIVE_AIVEKTORKEY_SIZE = Jassimp.getVKeysize();
                    NATIVE_AIQUATKEY_SIZE = Jassimp.getQKeysize();
                    NATIVE_AIVEKTOR3D_SIZE = Jassimp.getV3Dsize();
                    NATIVE_FLOAT_SIZE = Jassimp.getfloatsize();
                    NATIVE_INT_SIZE = Jassimp.getintsize();
                    NATIVE_UINT_SIZE = Jassimp.getuintsize();
                    NATIVE_DOUBLE_SIZE = Jassimp.getdoublesize();
                    NATIVE_LONG_SIZE = Jassimp.getlongsize();
                    s_libraryLoaded = true;
                }
            }
        }
    }

    private static native AiScene aiImportFile(String var0, long var1, AiIOSystem<?> var3) throws IOException;

    private Jassimp() {
    }
}

