/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import java.nio.ByteBuffer;

public final class AiVector {
    private final ByteBuffer m_buffer;
    private final int m_offset;
    private final int m_numComponents;

    public AiVector(ByteBuffer buffer, int offset, int numComponents) {
        if (null == buffer) {
            throw new IllegalArgumentException("buffer may not be null");
        }
        this.m_buffer = buffer;
        this.m_offset = offset;
        this.m_numComponents = numComponents;
    }

    public float getX() {
        return this.m_buffer.getFloat(this.m_offset);
    }

    public float getY() {
        if (this.m_numComponents <= 1) {
            throw new UnsupportedOperationException("vector has only 1 component");
        }
        return this.m_buffer.getFloat(this.m_offset + 4);
    }

    public float getZ() {
        if (this.m_numComponents <= 2) {
            throw new UnsupportedOperationException("vector has only 2 components");
        }
        return this.m_buffer.getFloat(this.m_offset + 8);
    }

    public void setX(float x) {
        this.m_buffer.putFloat(this.m_offset, x);
    }

    public void setY(float y) {
        if (this.m_numComponents <= 1) {
            throw new UnsupportedOperationException("vector has only 1 component");
        }
        this.m_buffer.putFloat(this.m_offset + 4, y);
    }

    public void setZ(float z) {
        if (this.m_numComponents <= 2) {
            throw new UnsupportedOperationException("vector has only 2 components");
        }
        this.m_buffer.putFloat(this.m_offset + 8, z);
    }

    public int getNumComponents() {
        return this.m_numComponents;
    }

    public String toString() {
        return "[" + this.getX() + ", " + this.getY() + ", " + this.getZ() + "]";
    }
}

