/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import java.nio.ByteBuffer;

public final class AiQuaternion {
    private final ByteBuffer m_buffer;
    private final int m_offset;

    public AiQuaternion(ByteBuffer buffer, int offset) {
        if (null == buffer) {
            throw new IllegalArgumentException("buffer may not be null");
        }
        this.m_buffer = buffer;
        this.m_offset = offset;
    }

    public float getX() {
        return this.m_buffer.getFloat(this.m_offset + 4);
    }

    public float getY() {
        return this.m_buffer.getFloat(this.m_offset + 8);
    }

    public float getZ() {
        return this.m_buffer.getFloat(this.m_offset + 12);
    }

    public float getW() {
        return this.m_buffer.getFloat(this.m_offset);
    }

    public void setX(float x) {
        this.m_buffer.putFloat(this.m_offset + 4, x);
    }

    public void setY(float y) {
        this.m_buffer.putFloat(this.m_offset + 8, y);
    }

    public void setZ(float z) {
        this.m_buffer.putFloat(this.m_offset + 12, z);
    }

    public void setW(float w) {
        this.m_buffer.putFloat(this.m_offset, w);
    }

    public String toString() {
        return "[" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ", " + this.getW() + "]";
    }
}

