/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import jassimp.AiAnimBehavior;
import jassimp.AiWrapperProvider;
import jassimp.Jassimp;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class AiNodeAnim {
    private final int POS_KEY_SIZE = Jassimp.NATIVE_AIVEKTORKEY_SIZE;
    private final int ROT_KEY_SIZE = Jassimp.NATIVE_AIQUATKEY_SIZE;
    private final int SCALE_KEY_SIZE = Jassimp.NATIVE_AIVEKTORKEY_SIZE;
    private final String m_nodeName;
    private final int m_numPosKeys;
    private ByteBuffer m_posKeys;
    private final int m_numRotKeys;
    private ByteBuffer m_rotKeys;
    private final int m_numScaleKeys;
    private ByteBuffer m_scaleKeys;
    private final AiAnimBehavior m_preState;
    private final AiAnimBehavior m_postState;

    AiNodeAnim(String nodeName, int numPosKeys, int numRotKeys, int numScaleKeys, int preBehavior, int postBehavior) {
        this.m_nodeName = nodeName;
        this.m_numPosKeys = numPosKeys;
        this.m_numRotKeys = numRotKeys;
        this.m_numScaleKeys = numScaleKeys;
        this.m_preState = AiAnimBehavior.fromRawValue(preBehavior);
        this.m_postState = AiAnimBehavior.fromRawValue(postBehavior);
        this.m_posKeys = ByteBuffer.allocateDirect(numPosKeys * this.POS_KEY_SIZE);
        this.m_posKeys.order(ByteOrder.nativeOrder());
        this.m_rotKeys = ByteBuffer.allocateDirect(numRotKeys * this.ROT_KEY_SIZE);
        this.m_rotKeys.order(ByteOrder.nativeOrder());
        this.m_scaleKeys = ByteBuffer.allocateDirect(numScaleKeys * this.SCALE_KEY_SIZE);
        this.m_scaleKeys.order(ByteOrder.nativeOrder());
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    public int getNumPosKeys() {
        return this.m_numPosKeys;
    }

    public ByteBuffer getPosKeyBuffer() {
        ByteBuffer buf = this.m_posKeys.duplicate();
        buf.order(ByteOrder.nativeOrder());
        return buf;
    }

    public double getPosKeyTime(int keyIndex) {
        return this.m_posKeys.getDouble(this.POS_KEY_SIZE * keyIndex);
    }

    public float getPosKeyX(int keyIndex) {
        return this.m_posKeys.getFloat(this.POS_KEY_SIZE * keyIndex + 8);
    }

    public float getPosKeyY(int keyIndex) {
        return this.m_posKeys.getFloat(this.POS_KEY_SIZE * keyIndex + 12);
    }

    public float getPosKeyZ(int keyIndex) {
        return this.m_posKeys.getFloat(this.POS_KEY_SIZE * keyIndex + 16);
    }

    public <V3, M4, C, N, Q> V3 getPosKeyVector(int keyIndex, AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        return wrapperProvider.wrapVector3f(this.m_posKeys, this.POS_KEY_SIZE * keyIndex + 8, 3);
    }

    public int getNumRotKeys() {
        return this.m_numRotKeys;
    }

    public ByteBuffer getRotKeyBuffer() {
        ByteBuffer buf = this.m_rotKeys.duplicate();
        buf.order(ByteOrder.nativeOrder());
        return buf;
    }

    public double getRotKeyTime(int keyIndex) {
        return this.m_rotKeys.getDouble(this.ROT_KEY_SIZE * keyIndex);
    }

    public float getRotKeyW(int keyIndex) {
        return this.m_rotKeys.getFloat(this.ROT_KEY_SIZE * keyIndex + 8);
    }

    public float getRotKeyX(int keyIndex) {
        return this.m_rotKeys.getFloat(this.ROT_KEY_SIZE * keyIndex + 12);
    }

    public float getRotKeyY(int keyIndex) {
        return this.m_rotKeys.getFloat(this.ROT_KEY_SIZE * keyIndex + 16);
    }

    public float getRotKeyZ(int keyIndex) {
        return this.m_rotKeys.getFloat(this.ROT_KEY_SIZE * keyIndex + 20);
    }

    public <V3, M4, C, N, Q> Q getRotKeyQuaternion(int keyIndex, AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        return wrapperProvider.wrapQuaternion(this.m_rotKeys, this.ROT_KEY_SIZE * keyIndex + 8);
    }

    public int getNumScaleKeys() {
        return this.m_numScaleKeys;
    }

    public ByteBuffer getScaleKeyBuffer() {
        ByteBuffer buf = this.m_scaleKeys.duplicate();
        buf.order(ByteOrder.nativeOrder());
        return buf;
    }

    public double getScaleKeyTime(int keyIndex) {
        return this.m_scaleKeys.getDouble(this.SCALE_KEY_SIZE * keyIndex);
    }

    public float getScaleKeyX(int keyIndex) {
        return this.m_scaleKeys.getFloat(this.SCALE_KEY_SIZE * keyIndex + 8);
    }

    public float getScaleKeyY(int keyIndex) {
        return this.m_scaleKeys.getFloat(this.SCALE_KEY_SIZE * keyIndex + 12);
    }

    public float getScaleKeyZ(int keyIndex) {
        return this.m_scaleKeys.getFloat(this.SCALE_KEY_SIZE * keyIndex + 16);
    }

    public <V3, M4, C, N, Q> V3 getScaleKeyVector(int keyIndex, AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        return wrapperProvider.wrapVector3f(this.m_scaleKeys, this.SCALE_KEY_SIZE * keyIndex + 8, 3);
    }

    public AiAnimBehavior getPreState() {
        return this.m_preState;
    }

    public AiAnimBehavior getPostState() {
        return this.m_postState;
    }
}

