/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import jassimp.AiMetadataEntry;
import jassimp.AiWrapperProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AiNode {
    private final String m_name;
    private final AiNode m_parent;
    private final int[] m_meshReferences;
    private final List<AiNode> m_children = new ArrayList<AiNode>();
    private final Map<String, AiMetadataEntry> m_metaData = new HashMap<String, AiMetadataEntry>();
    private final Object m_transformationMatrix;

    AiNode(AiNode parent, Object transform, int[] meshReferences, String name) {
        this.m_parent = parent;
        this.m_transformationMatrix = transform;
        this.m_meshReferences = meshReferences;
        this.m_name = name;
        if (null != this.m_parent) {
            this.m_parent.addChild(this);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public int getNumChildren() {
        return this.getChildren().size();
    }

    public <V3, M4, C, N, Q> M4 getTransform(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        return (M4)this.m_transformationMatrix;
    }

    public List<AiNode> getChildren() {
        return this.m_children;
    }

    public AiNode getParent() {
        return this.m_parent;
    }

    public AiNode findNode(String name) {
        if (this.m_name.equals(name)) {
            return this;
        }
        for (AiNode child : this.m_children) {
            if (null == child.findNode(name)) continue;
            return child;
        }
        return null;
    }

    public int getNumMeshes() {
        return this.m_meshReferences.length;
    }

    public int[] getMeshes() {
        return this.m_meshReferences;
    }

    public Map<String, AiMetadataEntry> getMetadata() {
        return this.m_metaData;
    }

    void addChild(AiNode child) {
        this.m_children.add(child);
    }
}

