/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public final class AiMatrix4f {
    private final float[] m_data;

    public AiMatrix4f(float[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (data.length != 16) {
            throw new IllegalArgumentException("array length is not 16");
        }
        this.m_data = data;
    }

    public float get(int row, int col) {
        if (row < 0 || row > 3) {
            throw new IndexOutOfBoundsException("Index: " + row + ", Size: 4");
        }
        if (col < 0 || col > 3) {
            throw new IndexOutOfBoundsException("Index: " + col + ", Size: 4");
        }
        return this.m_data[row * 4 + col];
    }

    public FloatBuffer toByteBuffer() {
        ByteBuffer bbuf = ByteBuffer.allocateDirect(64);
        bbuf.order(ByteOrder.nativeOrder());
        FloatBuffer fbuf = bbuf.asFloatBuffer();
        fbuf.put(this.m_data);
        fbuf.flip();
        return fbuf;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                buf.append(this.m_data[row * 4 + col]).append(" ");
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

