/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import java.nio.ByteBuffer;

public final class AiColor {
    private final ByteBuffer m_buffer;
    private final int m_offset;

    public AiColor(ByteBuffer buffer, int offset) {
        this.m_buffer = buffer;
        this.m_offset = offset;
    }

    public float getRed() {
        return this.m_buffer.getFloat(this.m_offset);
    }

    public float getGreen() {
        return this.m_buffer.getFloat(this.m_offset + 4);
    }

    public float getBlue() {
        return this.m_buffer.getFloat(this.m_offset + 8);
    }

    public float getAlpha() {
        return this.m_buffer.getFloat(this.m_offset + 12);
    }

    public void setRed(float red) {
        this.m_buffer.putFloat(this.m_offset, red);
    }

    public void setGreen(float green) {
        this.m_buffer.putFloat(this.m_offset + 4, green);
    }

    public void setBlue(float blue) {
        this.m_buffer.putFloat(this.m_offset + 8, blue);
    }

    public void setAlpha(float alpha) {
        this.m_buffer.putFloat(this.m_offset + 12, alpha);
    }

    public String toString() {
        return "[" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "]";
    }
}

