/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import jassimp.AiIOSystem;
import jassimp.AiInputStreamIOStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class AiClassLoaderIOSystem
implements AiIOSystem<AiInputStreamIOStream> {
    private final Class<?> clazz;
    private final ClassLoader classLoader;

    public AiClassLoaderIOSystem(ClassLoader classLoader) {
        this.clazz = null;
        this.classLoader = classLoader;
    }

    public AiClassLoaderIOSystem(Class<?> clazz) {
        this.clazz = clazz;
        this.classLoader = null;
    }

    @Override
    public AiInputStreamIOStream open(String filename, String ioMode) {
        try {
            InputStream is;
            if (this.clazz != null) {
                is = this.clazz.getResourceAsStream(filename);
            } else if (this.classLoader != null) {
                is = this.classLoader.getResourceAsStream(filename);
            } else {
                System.err.println("[" + this.getClass().getSimpleName() + "] No class or classLoader provided to resolve " + filename);
                return null;
            }
            if (is != null) {
                return new AiInputStreamIOStream(is);
            }
            System.err.println("[" + this.getClass().getSimpleName() + "] Cannot find " + filename);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void close(AiInputStreamIOStream file) {
    }

    @Override
    public boolean exists(String path) {
        URL url = null;
        if (this.clazz != null) {
            url = this.clazz.getResource(path);
        } else if (this.classLoader != null) {
            url = this.classLoader.getResource(path);
        }
        return url != null;
    }

    @Override
    public char getOsSeparator() {
        return '/';
    }
}

