/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent.runtime.barrierScheduler.implicitContext;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class ParkingBarrier {
    private final AtomicReference<Thread> waitingThread = new AtomicReference<Object>(null);

    public void await() {
        if (!this.waitingThread.compareAndSet(null, Thread.currentThread())) {
            throw new IllegalStateException("only one thread can await() on a barrier at a time");
        }
        while (this.waitingThread.get() != null) {
            LockSupport.park(this);
        }
    }

    public boolean release() {
        Thread waitingThreadRef = this.waitingThread.getAndSet(null);
        if (waitingThreadRef == null) {
            return false;
        }
        LockSupport.unpark(waitingThreadRef);
        return true;
    }

    public boolean isSleeping() {
        return this.waitingThread.get() != null;
    }
}

