/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.util;

import us.ihmc.affinity.Processor;
import us.ihmc.realtime.PeriodicParameters;
import us.ihmc.realtime.PriorityParameters;
import us.ihmc.realtime.RealtimeThread;
import us.ihmc.util.ThreadFactory;
import us.ihmc.util.ThreadInterface;

public class RealtimeThreadFactory
implements ThreadFactory {
    private final PriorityParameters priorityParameters;
    private final PeriodicParameters periodicParameters;
    private final Processor[] processors;

    public RealtimeThreadFactory(PriorityParameters priorityParameters, PeriodicParameters periodicParameters, Processor ... processors) {
        this.priorityParameters = priorityParameters;
        this.periodicParameters = periodicParameters;
        this.processors = processors;
    }

    @Override
    public ThreadInterface createThread(Runnable runnable, String name) {
        RealtimeThread realtimeThread = new RealtimeThread(this.priorityParameters, this.periodicParameters, runnable, name);
        if (this.processors != null && this.processors.length > 0) {
            realtimeThread.setAffinity(this.processors);
        }
        return realtimeThread;
    }
}

