/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.realtime;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import us.ihmc.affinity.Affinity;
import us.ihmc.affinity.Processor;
import us.ihmc.process.SchedulerAlgorithm;
import us.ihmc.realtime.MonotonicTime;
import us.ihmc.realtime.PeriodicParameters;
import us.ihmc.realtime.PriorityParameters;
import us.ihmc.realtime.RealtimeNative;
import us.ihmc.util.ThreadInterface;

public class RealtimeThread
implements Runnable,
ThreadInterface {
    private static final ThreadLocal<RealtimeThread> realtimeThreads = new ThreadLocal();
    private static final AtomicInteger threadNumber = new AtomicInteger(1);
    private volatile ThreadStatus threadStatus = ThreadStatus.NEW;
    private final long threadID;
    private final String name;
    protected final Runnable runnable;
    private Processor[] affinity = null;
    private final ReentrantLock joinLock = new ReentrantLock();
    private boolean hasJoined = false;
    private int returnValue;

    public RealtimeThread(PriorityParameters priorityParameters) {
        this(priorityParameters, null, null, null);
    }

    public RealtimeThread(PriorityParameters priorityParameters, String name) {
        this(priorityParameters, null, null, name);
    }

    public RealtimeThread(PriorityParameters priorityParameters, Runnable runnable) {
        this(priorityParameters, null, runnable, null);
    }

    public RealtimeThread(PriorityParameters priorityParameters, Runnable runnable, String name) {
        this(priorityParameters, null, runnable, name);
    }

    public RealtimeThread(PriorityParameters priorityParameters, PeriodicParameters periodicParameters) {
        this(priorityParameters, periodicParameters, null, null);
    }

    public RealtimeThread(PriorityParameters priorityParameters, PeriodicParameters periodicParameters, String name) {
        this(priorityParameters, periodicParameters, null, name);
    }

    public RealtimeThread(PriorityParameters priorityParameters, PeriodicParameters periodicParameters, Runnable runnable) {
        this(priorityParameters, periodicParameters, runnable, null);
    }

    public RealtimeThread(PriorityParameters priorityParameters, PeriodicParameters periodicParameters, Runnable runnable, String name) {
        boolean periodic = false;
        boolean startOnClock = false;
        long startSeconds = 0L;
        long startNanos = 0L;
        long periodSeconds = 0L;
        long periodNanos = 0L;
        if (periodicParameters != null) {
            periodic = true;
            if (periodicParameters.getStartTime() != null) {
                startOnClock = true;
                startSeconds = periodicParameters.getStartTime().seconds();
                startNanos = periodicParameters.getStartTime().nanoseconds();
            }
            periodSeconds = periodicParameters.getPeriod().seconds();
            periodNanos = periodicParameters.getPeriod().nanoseconds();
        }
        this.threadID = RealtimeNative.createThread(this, priorityParameters.getPriority(), periodic, startOnClock, startSeconds, startNanos, periodSeconds, periodNanos);
        this.runnable = runnable;
        this.name = name != null ? name + "-realtime-thread-" + threadNumber.getAndIncrement() : "realtime-thread-" + threadNumber.getAndIncrement();
    }

    public final synchronized void setAffinity(Processor ... processors) {
        this.affinity = processors;
        if (this.threadStatus == ThreadStatus.STARTED) {
            Affinity.setAffinity(this, processors);
        }
    }

    @Override
    public final synchronized void start() {
        if (this.threadStatus != ThreadStatus.NEW) {
            throw new IllegalThreadStateException("Thread already started");
        }
        if (RealtimeNative.startThread(this.threadID) != 0) {
            throw new RuntimeException("Cannot start realtime thread, do you have permission");
        }
        if (this.affinity != null) {
            Affinity.setAffinity(this, this.affinity);
        }
        this.threadStatus = ThreadStatus.STARTED;
    }

    void runFromNative() {
        realtimeThreads.set(this);
        Thread.currentThread().setName(this.name);
        this.run();
    }

    @Override
    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public ThreadStatus getStatus() {
        return this.threadStatus;
    }

    public long waitForNextPeriod(long offset) {
        return RealtimeNative.waitForNextPeriod(this.threadID, offset);
    }

    public long waitForNextPeriod() {
        return RealtimeNative.waitForNextPeriod(this.threadID, 0L);
    }

    public void setNextPeriodToClock() {
        RealtimeNative.setNextPeriodToClock(this.threadID);
    }

    public long waitUntil(MonotonicTime time) {
        return RealtimeNative.waitUntil(this.threadID, time.seconds(), time.nanoseconds());
    }

    public static long getCurrentMonotonicClockTime() {
        return RealtimeNative.getCurrentTimeNative();
    }

    public static SchedulerAlgorithm getCurrentThreadScheduler() {
        int sched = RealtimeNative.getCurrentThreadScheduler();
        return SchedulerAlgorithm.fromCOrdinal(sched);
    }

    public static int getCurrentThreadPriority() {
        return RealtimeNative.getCurrentThreadPriority();
    }

    public static RealtimeThread getCurrentRealtimeThread() {
        RealtimeThread currentThread = realtimeThreads.get();
        if (currentThread == null) {
            throw new RuntimeException("Current thread is not a realtime thread");
        }
        return currentThread;
    }

    @Override
    public void getNextTriggerTime(MonotonicTime timeToPack) {
        long timestamp = RealtimeNative.getNextPeriod(this.threadID);
        timeToPack.set(0L, timestamp);
    }

    public void setNextPeriod(MonotonicTime nextControllerTrigger) {
        RealtimeNative.setNextPeriod(this.threadID, nextControllerTrigger.seconds(), nextControllerTrigger.nanoseconds());
    }

    public void join() {
        this.joinWithReturn();
    }

    public int joinWithReturn() {
        this.joinLock.lock();
        if (!this.hasJoined) {
            this.returnValue = RealtimeNative.join(this.threadID);
            this.hasJoined = true;
        }
        this.joinLock.unlock();
        return this.returnValue;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public long getCurrentRealtimeClock() {
        return RealtimeNative.getCurrentRealtimeClockTimeNative();
    }

    public void finalize() {
        RealtimeNative.destroy(this.threadID);
    }

    static enum ThreadStatus {
        NEW,
        STARTED;

    }
}

