/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent.runtime.barrierScheduler.implicitContext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.Task;

public class BarrierScheduler<C>
implements Runnable {
    private static final int BUSY_SLEEP_RESOLUTION_NS = 10000;
    private final List<? extends Task<C>> tasks;
    private final boolean[] releaseTasks;
    private final C masterContext;
    private final TaskOverrunBehavior overrunBehavior;
    private long tick;

    public BarrierScheduler(Collection<? extends Task<C>> tasks, C masterContext, TaskOverrunBehavior overrunBehavior) {
        this.tasks = new ArrayList<Task<C>>(tasks);
        this.releaseTasks = new boolean[tasks.size()];
        this.masterContext = masterContext;
        this.overrunBehavior = overrunBehavior;
    }

    @Override
    public void run() {
        int i;
        if (this.overrunBehavior == TaskOverrunBehavior.BUSY_WAIT) {
            while (!this.allTasksOnSchedule()) {
                try {
                    Thread.sleep(0L, 10000);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            Task<C> task = this.tasks.get(i);
            this.releaseTasks[i] = task.isPending(this.tick) && task.isSleeping();
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            if (!this.releaseTasks[i]) continue;
            this.tasks.get(i).updateMasterContext(this.masterContext);
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            if (!this.releaseTasks[i]) continue;
            this.tasks.get(i).updateLocalContext(this.masterContext);
        }
        for (i = 0; i < this.tasks.size(); ++i) {
            if (!this.releaseTasks[i] || this.tasks.get(i).release()) continue;
            throw new RuntimeException("tried to release an unwaiting task");
        }
        ++this.tick;
    }

    private boolean allTasksOnSchedule() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            Task<C> task = this.tasks.get(i);
            if (!task.isPending(this.tick) || task.isSleeping()) continue;
            return false;
        }
        return true;
    }

    public void shutdown() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            Task<C> task = this.tasks.get(i);
            while (!task.hasShutdown()) {
                task.requestShutdown();
            }
        }
    }

    public static enum TaskOverrunBehavior {
        BUSY_WAIT,
        SKIP_TICK;

    }
}

