/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent;

import us.ihmc.concurrent.Builder;
import us.ihmc.concurrent.ConcurrentRingBuffer;

public class ConcurrentRingBufferBenchmark {
    public static void main(String[] args) {
        final long iterations = Long.parseLong(args[0]);
        long writesPerIteration = 1L;
        final ConcurrentRingBuffer<MutableLong> concurrentRingBuffer = new ConcurrentRingBuffer<MutableLong>(new MutableLongBuilder(), 1024);
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (long value = 0L; value < iterations; ++value) {
                    int y = 0;
                    while ((long)y < 1L) {
                        MutableLong nextValue;
                        while ((nextValue = (MutableLong)concurrentRingBuffer.next()) == null) {
                        }
                        nextValue.value = value;
                        ++y;
                    }
                    concurrentRingBuffer.commit();
                }
            }
        }).start();
        boolean running = true;
        long iteration = 0L;
        long start = System.nanoTime();
        while (running) {
            MutableLong value;
            if (!concurrentRingBuffer.poll()) continue;
            while ((value = concurrentRingBuffer.read()) != null) {
                if (value.value != iteration) {
                    throw new RuntimeException("Values not equal");
                }
                if (++iteration < (iterations - 1L) * 1L) continue;
                running = false;
                break;
            }
            concurrentRingBuffer.flush();
        }
        long executionTime = System.nanoTime() - start;
        double executionTimeS = (double)executionTime / 1.0E9;
        double average = (double)iterations / executionTimeS;
        System.out.println(iterations + " iterations, total execution time: " + executionTime + "ns; " + executionTimeS + "s.");
        System.out.println("Average: " + average + " iterations/s");
    }

    private static class MutableLongBuilder
    implements Builder<MutableLong> {
        private MutableLongBuilder() {
        }

        @Override
        public MutableLong newInstance() {
            return new MutableLong();
        }
    }

    private static class MutableLong {
        public long value;

        private MutableLong() {
        }
    }
}

